/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.data;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.preferences.FAAnalyticsConstants;
import com.ibm.etools.fa.pdtclient.analytics.util.FAAnalyticsDatabaseUtility;
import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.shared.common.error.StandardException;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DatabaseManager {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DatabaseManager.class);
    private static final String DERBY_LOG_FILE = "derby.log";
    private static final String CREATE_TABLE_HEAD = "CREATE TABLE History (";
    private static final String STRING_DATA_TYPE = "VARCHAR(878)";
    private static final String INTEGER_DATA_TYPE = "INTEGER";
    private static final String DATE_DATA_TYPE = "DATE";
    private static final String INSERT_VALUE_HEAD = "INSERT INTO History (";
    private static final String DELETE_ROW_HEAD = "DELETE FROM History WHERE ";
    private static final String DROP_TABLE = "DROP TABLE History";
    private String databaseAddress;
    private String databaseConnectionString;
    private String prebuiltInsertValueString;
    private String prebuiltDeleteRowString;
    private String source;
    private List<String> columnNames = new ArrayList<String>();
    private List<Map<String, String>> entries;
    private static final EmbeddedDriver DRIVER = new EmbeddedDriver();

    public DatabaseManager(String source) throws CoreException {
        if (source == null) {
            throw new IllegalArgumentException("Must specify a non-null source.");
        }
        if (source.trim().isEmpty() || !source.contains("/")) {
            throw new IllegalArgumentException("Must specify a source containing 1 or more / characters");
        }
        IFolder folder = FACorePlugin.getRoot().getFolder("analytics_database");
        System.setProperty("derby.system.home", folder.getRawLocation().toString());
        System.setProperty("derby.stream.error.file", folder.getFile(DERBY_LOG_FILE).getRawLocation().toString());
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.databaseAddress = "jdbc:derby:" + folder.getFile("db").getRawLocation().toString();
        this.databaseConnectionString = this.databaseAddress + ";create=true";
        String[] split = source.split("/");
        if (split.length < 1) {
            throw new IllegalStateException("Error: can't get hosthame from '" + source + "'");
        }
        this.source = source;
        this.entries = Arrays.asList(ViewParser.parse((String)source).getList());
    }

    private static void open() throws SQLException {
        logger.trace((Object)("registerDriver " + String.valueOf(DRIVER)));
        DriverManager.registerDriver((Driver)DRIVER);
    }

    private void shutdown() {
        block4: {
            logger.trace((Object)" shutting down a database from your application");
            try {
                DriverManager.getConnection(this.databaseAddress + ";shutdown=true");
            }
            catch (SQLException e) {
                if (e.getCause() instanceof StandardException) break block4;
                logger.error((Throwable)e);
            }
        }
        try {
            logger.trace(new Object[]{"Deregistering JDBC driver ", DRIVER});
            DriverManager.deregisterDriver((Driver)DRIVER);
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public List<List<String>> queryDatabase(String queryString, int resultsLimit) throws SQLException {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        try {
            ArrayList<List<String>> arrayList;
            Statement query;
            Connection databaseConnection;
            Throwable throwable;
            block35: {
                block34: {
                    DatabaseManager.open();
                    throwable = null;
                    Object var5_6 = null;
                    databaseConnection = DriverManager.getConnection(this.databaseConnectionString);
                    query = databaseConnection.createStatement(1004, 1007);
                    if (resultsLimit > 0) {
                        query.setMaxRows(resultsLimit);
                    }
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (ResultSet queryResult = query.executeQuery(queryString);){
                        ResultSetMetaData resultData = queryResult.getMetaData();
                        int numColumns = resultData.getColumnCount();
                        int i = 1;
                        while (i <= numColumns) {
                            result.add(new ArrayList());
                            String columnLabel = resultData.getColumnLabel(i);
                            ((List)result.get(i - 1)).add(columnLabel);
                            ++i;
                        }
                        i = 1;
                        while (i <= numColumns) {
                            List column = (List)result.get(i - 1);
                            while (queryResult.next()) {
                                column.add(queryResult.getString(i));
                            }
                            queryResult.beforeFirst();
                            ++i;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    arrayList = result;
                    if (query == null) break block34;
                    query.close();
                }
                if (databaseConnection == null) break block35;
                databaseConnection.close();
            }
            return arrayList;
            {
                catch (Throwable throwable4) {
                    try {
                        try {
                            if (query != null) {
                                query.close();
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            if (databaseConnection != null) {
                                databaseConnection.close();
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.shutdown();
        }
    }

    public void populateTable(IProgressMonitor monitor) throws IOException, SQLException, ParseException, NumberFormatException {
        try {
            DatabaseManager.open();
            if (this.entries.isEmpty()) {
                throw new IOException("The Fault Entry list is empty?");
            }
            this.columnNames = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Connection databaseConnection = DriverManager.getConnection(this.databaseConnectionString);){
                    Set<String> columnNamesSet = this.entries.get(0).keySet();
                    columnNamesSet.remove(ViewParser.class.getCanonicalName());
                    for (String columnName : columnNamesSet) {
                        if (columnName.startsWith(ViewParser.class.getCanonicalName())) continue;
                        this.columnNames.add(columnName);
                    }
                    this.createTable(databaseConnection);
                    this.insertRecords(databaseConnection, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                logger.error((Object)Messages.DatabaseManager_SQLErrorInitialisingDatabase, (Throwable)e);
                throw e;
            }
        }
        finally {
            this.shutdown();
        }
    }

    private void createTable(Connection databaseConnection) throws SQLException {
        StringBuilder createTableStringBuilder = new StringBuilder(CREATE_TABLE_HEAD);
        this.addCustomColumns();
        createTableStringBuilder = this.tableColumns(createTableStringBuilder);
        createTableStringBuilder = DatabaseManager.formatBracketTail(createTableStringBuilder);
        StringBuilder insertValueStringBuilder = new StringBuilder(INSERT_VALUE_HEAD);
        insertValueStringBuilder = this.buildInsertStringFieldNames(insertValueStringBuilder);
        insertValueStringBuilder = DatabaseManager.formatBracketTail(insertValueStringBuilder);
        insertValueStringBuilder.append(" VALUES (");
        logger.trace(new Object[]{"Inserting ", this.columnNames.size(), "?s"});
        int i = 0;
        while (i < this.columnNames.size()) {
            insertValueStringBuilder.append("?,");
            ++i;
        }
        insertValueStringBuilder = DatabaseManager.formatBracketTail(insertValueStringBuilder);
        StringBuilder deleteRowStringBuilder = new StringBuilder(DELETE_ROW_HEAD);
        this.prebuiltDeleteRowString = this.buildDeleteStringFields(deleteRowStringBuilder).toString();
        this.prebuiltInsertValueString = insertValueStringBuilder.toString();
        try {
            databaseConnection.createStatement().execute(DROP_TABLE);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        logger.trace(new Object[]{"Statement: ", createTableStringBuilder});
        databaseConnection.createStatement().execute(createTableStringBuilder.toString());
    }

    private void insertRecords(Connection databaseConnection, IProgressMonitor monitor) throws SQLException, ParseException, NumberFormatException {
        logger.trace((Object)this.prebuiltInsertValueString);
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement preparedInsertStatement = databaseConnection.prepareStatement(this.prebuiltInsertValueString);){
            monitor.beginTask(Messages.DatabaseManager_InsertingFaultEntriesMonitor, this.entries.size());
            Iterator<Map<String, String>> iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                Map<String, String> currentObject;
                Map<String, String> currentEntry = currentObject = iterator.next();
                monitor.worked(1);
                DatabaseManager.substituteStatementParameters(preparedInsertStatement, currentEntry);
                preparedInsertStatement.execute();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private StringBuilder tableColumns(StringBuilder createTableStringBuilder) {
        for (String name : this.columnNames) {
            createTableStringBuilder = name.equals(DATE_DATA_TYPE) ? createTableStringBuilder.append("\"" + name + "\" DATE,") : (FAAnalyticsConstants.DATABASE_HEADER_NUMERIC_LIST.contains(name) ? createTableStringBuilder.append("\"" + name + "\" INTEGER,") : createTableStringBuilder.append("\"" + name + "\" VARCHAR(878),"));
        }
        return createTableStringBuilder;
    }

    private void addCustomColumns() {
        this.columnNames.add("WEEKDAY");
        this.columnNames.add("MONTH");
        this.columnNames.add("YEAR");
    }

    private StringBuilder buildInsertStringFieldNames(StringBuilder insertRecordStringBuilder) {
        logger.trace(new Object[]{"fields=", this.columnNames.size()});
        for (String column : this.columnNames) {
            insertRecordStringBuilder.append("\"" + column + "\",");
        }
        return insertRecordStringBuilder;
    }

    private StringBuilder buildDeleteStringFields(StringBuilder deleteRecordStringBuilder) {
        int i = 0;
        while (i < this.columnNames.size()) {
            deleteRecordStringBuilder.append("\"" + this.columnNames.get(i) + "\" = ?");
            if (i != this.columnNames.size() - 1) {
                deleteRecordStringBuilder.append(" AND ");
            }
            ++i;
        }
        return deleteRecordStringBuilder;
    }

    private static PreparedStatement substituteStatementParameters(PreparedStatement preparedStatement, Map<String, String> currentEntry) throws SQLException, ParseException, NumberFormatException {
        int parameterNumber = 0;
        for (Map.Entry<String, String> value : currentEntry.entrySet()) {
            if (value.getKey().startsWith(ViewParser.class.getCanonicalName())) continue;
            ++parameterNumber;
            if (FAAnalyticsConstants.DATABASE_HEADER_DATE_LIST.contains(value.getKey())) {
                preparedStatement.setDate(parameterNumber, FAAnalyticsDatabaseUtility.convertStringToSQLDate(value.getValue()));
                continue;
            }
            if (FAAnalyticsConstants.DATABASE_HEADER_NUMERIC_LIST.contains(value.getKey())) {
                if (value.getValue().trim().isEmpty()) {
                    preparedStatement.setInt(parameterNumber, 0);
                    continue;
                }
                preparedStatement.setInt(parameterNumber, Integer.valueOf(value.getValue()));
                continue;
            }
            preparedStatement.setString(parameterNumber, value.getValue());
        }
        preparedStatement.setString(++parameterNumber, FAAnalyticsDatabaseUtility.convertDateToDayOfWeek(currentEntry.get(DATE_DATA_TYPE)));
        preparedStatement.setString(++parameterNumber, FAAnalyticsDatabaseUtility.convertDateToMonthOfYear(currentEntry.get(DATE_DATA_TYPE)));
        preparedStatement.setString(++parameterNumber, FAAnalyticsDatabaseUtility.convertDateToYearNumber(currentEntry.get(DATE_DATA_TYPE)));
        return preparedStatement;
    }

    public void updateDatabase(List<Map<String, String>> newEntries) throws SQLException, NumberFormatException, ParseException {
        block24: {
            try {
                DatabaseManager.open();
                ListDiff differences = Diffs.computeListDiff(this.entries, newEntries);
                this.entries = newEntries;
                if (differences.getDifferences().length <= 0) break block24;
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Connection databaseConnection = DriverManager.getConnection(this.databaseConnectionString);){
                        ListDiffEntry[] listDiffEntryArray = differences.getDifferences();
                        int n = listDiffEntryArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ListDiffEntry difference = listDiffEntryArray[n2];
                            String sqlCommand = "";
                            sqlCommand = difference.isAddition() ? this.prebuiltInsertValueString : this.prebuiltDeleteRowString;
                            Throwable throwable2 = null;
                            Object var12_16 = null;
                            try (PreparedStatement preparedInsertStatement = databaseConnection.prepareStatement(sqlCommand);){
                                DatabaseManager.substituteStatementParameters(preparedInsertStatement, (Map)difference.getElement());
                                preparedInsertStatement.execute();
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (NumberFormatException | SQLException | ParseException e) {
                    logger.error((Object)"An exception occurred while updating the database.", (Throwable)e);
                    throw e;
                }
            }
            finally {
                this.shutdown();
            }
        }
    }

    private static StringBuilder formatBracketTail(StringBuilder stringBuilder) {
        stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder = stringBuilder.append(")");
        return stringBuilder;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getSize() {
        return this.entries.size();
    }

    public List<Map<String, String>> getEntries() {
        return this.entries;
    }
}

