/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.chart;

import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractAxisChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.ChartType;
import com.ibm.etools.fa.pdtclient.analytics.data.ChartData;
import java.util.List;

public class TextReportBuilder
extends AbstractAxisChartBuilder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved.";
    private StringBuilder sb = new StringBuilder();

    public TextReportBuilder() {
        super(ChartType.TEXT);
    }

    @Override
    protected void createChart() {
    }

    @Override
    protected void plot(ChartData data) {
        this.sb.append("<!DOCTYPE html>\r\n<html>\r\n<head>\r\n<style>\r\ntable, th, td {\r\n    border: 1px solid black;\r\n    border-collapse: collapse;\r\n}\r\nth, td {\r\n    padding: 5px;\r\n    text-align: left;\r\n}\r\n</style>\r\n</head><body>");
        this.sb.append("<table style=\"width:100%\"><caption>" + data.getChartTitle() + "</caption>");
        if (this.legendEnabled) {
            this.sb.append("<caption>" + this.legendTitle + "</caption>" + System.lineSeparator());
        }
        this.sb.append("<tr><th>" + this.xTitle + " (" + data.getxSeriesHeader() + ")</th> <th>" + this.yTitle + " (" + data.getySeriesHeader() + ")</th></tr> " + System.lineSeparator());
        List<String> xSeries = data.getxSeries();
        List<Double> ySeries = data.getySeries();
        int i = 0;
        while (i < xSeries.size()) {
            this.sb.append("<tr><td>" + xSeries.get(i) + "</td><td>" + String.valueOf(ySeries.get(i)) + "</td></tr>" + System.lineSeparator());
            ++i;
        }
        this.sb.append("</table>" + System.lineSeparator());
        this.sb.append("</body>\r\n</html>");
    }

    @Override
    protected void title(ChartData data) {
    }

    @Override
    protected void legend(ChartData data) {
    }

    @Override
    protected void xSeries(ChartData data) {
    }

    @Override
    protected void ySeries(ChartData data) {
    }

    @Override
    protected void xAxis(ChartData data) {
    }

    @Override
    protected void yAxis(ChartData data) {
    }

    @Override
    public String getTextVersion() {
        String text = this.sb.toString();
        this.sb = new StringBuilder();
        return text;
    }
}

