/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.chart;

import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractNoAxisChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.ChartType;
import com.ibm.etools.fa.pdtclient.analytics.data.ChartData;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.CallBackValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.attribute.impl.JavaNumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;

public class PieChartBuilder
extends AbstractNoAxisChartBuilder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    SeriesDefinition seriesXDef;
    public boolean pieDonut = false;
    public boolean pieExploded = false;

    public PieChartBuilder() {
        super(ChartType.PIE);
    }

    @Override
    protected void plot(ChartData data) {
        this.chart.getPlot().setBackground((Fill)ColorDefinitionImpl.WHITE());
        this.chart.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.WHITE());
    }

    @Override
    protected void title(ChartData data) {
        if (data == null) {
            throw new IllegalArgumentException("Must specify a non-null ChartData.");
        }
        this.chart.getTitle().getLabel().getCaption().setValue(data.getChartTitle());
        this.chart.getTitle().getLabel().getCaption().getFont().setName(this.chartTitleFontName);
        this.chart.getTitle().getLabel().getCaption().getFont().setSize((float)this.chartTitleFontSize);
        this.chart.getTitle().getLabel().getCaption().getFont().setBold(this.chartTitleBold);
        this.chart.getTitle().getLabel().getCaption().getFont().setItalic(this.chartTitleItalic);
    }

    @Override
    protected void legend(ChartData data) {
        this.chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
        this.chart.getLegend().setVisible(this.legendEnabled);
        if (this.legendEnabled) {
            this.chart.getLegend().getTitle().setVisible(this.legendTitleEnabled);
            if (this.legendTitleEnabled) {
                this.chart.getLegend().getTitle().getCaption().setValue(this.legendTitle);
                this.chart.getLegend().getTitle().getCaption().getFont().setName(this.legendTitleFontName);
                this.chart.getLegend().getTitle().getCaption().getFont().setSize((float)this.legendTitleFontSize);
                this.chart.getLegend().getTitle().getCaption().getFont().setBold(this.legendTitleBold);
                this.chart.getLegend().getTitle().getCaption().getFont().setItalic(this.legendTitleItalic);
            }
            this.chart.getLegend().getText().getFont().setName(this.legendLabelFontName);
            this.chart.getLegend().getText().getFont().setSize((float)this.legendLabelFontSize);
            this.chart.getLegend().getText().getFont().setBold(this.legendLabelBold);
            this.chart.getLegend().getText().getFont().setBold(this.legendLabelItalic);
        }
    }

    @Override
    protected void xSeries(ChartData data) {
        TextDataSet categoryValues = TextDataSetImpl.create(data.getxSeries());
        Series seriesCategory = SeriesImpl.create();
        seriesCategory.setDataSet((DataSet)categoryValues);
        this.seriesXDef = SeriesDefinitionImpl.create();
        ((ChartWithoutAxes)this.chart).getSeriesDefinitions().add((Object)this.seriesXDef);
        this.seriesXDef.getSeries().add((Object)seriesCategory);
    }

    @Override
    protected void ySeries(ChartData data) {
        NumberDataSet numberValues = NumberDataSetImpl.create(data.getySeries());
        PieSeries pieSeries = (PieSeries)PieSeriesImpl.create();
        if (this.pieExploded) {
            pieSeries.setExplosion(10);
        }
        if (this.pieDonut) {
            pieSeries.setInnerRadiusPercent(false);
            pieSeries.setInnerRadius(70.0);
        }
        pieSeries.setDataSet((DataSet)numberValues);
        DataPoint dp = pieSeries.getDataPoint();
        dp.getComponents().clear();
        dp.setPrefix("(");
        dp.setSuffix(")");
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.BASE_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0")));
        dp.getComponents().add((Object)DataPointComponentImpl.create((DataPointComponentType)DataPointComponentType.ORTHOGONAL_VALUE_LITERAL, (FormatSpecifier)JavaNumberFormatSpecifierImpl.create((String)"0")));
        pieSeries.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)500, null))));
        pieSeries.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONDBLCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)String.valueOf("Callback")))));
        pieSeries.setSeriesIdentifier((Object)data);
        SeriesDefinition seriesYDef = SeriesDefinitionImpl.create();
        this.seriesXDef.getSeriesDefinitions().add((Object)seriesYDef);
        seriesYDef.getSeries().add((Object)pieSeries);
    }

    public boolean isPieDonut() {
        return this.pieDonut;
    }

    public void setPieDonut(boolean pieDonut) {
        this.pieDonut = pieDonut;
    }

    public boolean isPieExploded() {
        return this.pieExploded;
    }

    public void setPieExploded(boolean pieExploded) {
        this.pieExploded = pieExploded;
    }
}

