/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.chart;

import com.ibm.etools.fa.pdtclient.analytics.chart.AbstractChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.BarChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.LineChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.PieChartBuilder;
import com.ibm.etools.fa.pdtclient.analytics.chart.TextReportBuilder;

public enum ChartType {
    BAR("Bar Chart"),
    LINE("Line Chart"),
    PIE("Pie Chart"),
    TEXT("Text");

    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public String name;

    private ChartType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AbstractChartBuilder stringToChartBuilder(String input) {
        return ChartType.chartTypeToChartBuilder(ChartType.stringToChartType(input));
    }

    public static ChartType stringToChartType(String input) {
        ChartType[] typeList;
        if (input == null) {
            throw new IllegalArgumentException("Must provide a non-null input.");
        }
        ChartType[] chartTypeArray = typeList = ChartType.values();
        int n = typeList.length;
        int n2 = 0;
        while (n2 < n) {
            ChartType currentType = chartTypeArray[n2];
            if (input.equals(currentType.getName())) {
                return currentType;
            }
            ++n2;
        }
        return null;
    }

    public static AbstractChartBuilder chartTypeToChartBuilder(ChartType chartType) {
        if (chartType == null) {
            throw new IllegalArgumentException("Must provide a non-null ChartType.");
        }
        switch (chartType) {
            case BAR: {
                return new BarChartBuilder();
            }
            case LINE: {
                return new LineChartBuilder();
            }
            case PIE: {
                return new PieChartBuilder();
            }
            case TEXT: {
                return new TextReportBuilder();
            }
        }
        return null;
    }
}

