/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.action.dialog;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunction;
import com.ibm.etools.fa.pdtclient.analytics.ui.view.model.ChartFunctionManager;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveCurrentChartActionDialog
extends Dialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Composite dialogComposite;
    private Label chartNameLabel;
    private Text chartNameText;
    private Button okayButton;
    private Button cancelButton;
    private ChartFunctionManager chartManager;
    private ChartFunction chartFunction;
    private String chartName;

    public SaveCurrentChartActionDialog(Shell parentShell, ChartFunctionManager chartManager, ChartFunction chartFunction) {
        super(parentShell);
        this.chartManager = chartManager;
        if (chartFunction == null) {
            throw new IllegalArgumentException("Must provide a non-null ChartFunction.");
        }
        this.chartFunction = chartFunction;
        this.chartName = this.chartFunction.getName();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.SaveCurrentChartActionDialog_SaveCurrentChartAs);
        this.dialogComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        this.chartNameLabel = GUI.label((Composite)this.dialogComposite, (String)Messages.SaveCurrentChartActionDialog_EnterChartNameLabel, (Object)GUI.grid.d.fillH((int)1), (int)0);
        this.chartNameText = GUI.text((Composite)this.dialogComposite, (Object)GUI.grid.d.fillH((int)1), (int)4);
        this.chartNameText.setTextLimit(255);
        this.chartNameText.setText(this.chartFunction.getName());
        this.chartNameText.setFocus();
        this.createListeners();
        return parent;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.horiz((int)131072, (boolean)false, (int)2));
        GridData buttonData = new GridData(131072, -1, false, false, 1, 1);
        buttonData.widthHint = 150;
        this.okayButton = GUI.button.push((Composite)buttonComposite, (String)Messages.SaveCurrentChartActionDialog_Okay, (Object)buttonData);
        this.okayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveCurrentChartActionDialog.this.okPressed();
            }
        });
        this.cancelButton = GUI.button.push((Composite)buttonComposite, (String)Messages.SaveCurrentChartActionDialog_Cancel, (Object)buttonData);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveCurrentChartActionDialog.this.cancelPressed();
            }
        });
        return buttonComposite;
    }

    private void createListeners() {
        this.chartNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SaveCurrentChartActionDialog.this.chartNameText.getText().trim().isEmpty() || !SaveCurrentChartActionDialog.this.chartManager.checkFunctionNameUnique(SaveCurrentChartActionDialog.this.chartNameText.getText().trim())) {
                    SaveCurrentChartActionDialog.this.okayButton.setEnabled(false);
                } else {
                    SaveCurrentChartActionDialog.this.chartName = SaveCurrentChartActionDialog.this.chartNameText.getText().trim();
                    SaveCurrentChartActionDialog.this.okayButton.setEnabled(true);
                }
            }
        });
        this.chartNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && !SaveCurrentChartActionDialog.this.chartNameText.getText().trim().isEmpty() && SaveCurrentChartActionDialog.this.chartManager.checkFunctionNameUnique(SaveCurrentChartActionDialog.this.chartNameText.getText().trim())) {
                    try {
                        SaveCurrentChartActionDialog.this.okPressed();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (e.character == '\u001b') {
                    SaveCurrentChartActionDialog.this.cancelPressed();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public String getSpecifiedName() {
        return this.chartName;
    }
}

