/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.action.dialog;

import com.ibm.etools.fa.pdtclient.analytics.Messages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ChangeResultsLimitDialog
extends InputDialog {
    private static final String VALID_LIMIT_RANGE_REGEX = "\\d{1,5}";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public ChangeResultsLimitDialog(Shell parentShell, int initialLimit) {
        super(parentShell, Messages.ChangeResultsLimitDialog_DialogTitle, Messages.ChangeResultsLimitDialog_LabelMessage, "" + initialLimit, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().matches(ChangeResultsLimitDialog.VALID_LIMIT_RANGE_REGEX)) {
                    if (Integer.valueOf(newText.trim()) > 0) {
                        return null;
                    }
                    return Messages.ChangeResultsLimitDialog_2;
                }
                return Messages.ChangeResultsLimitDialog_3;
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Control createDialogArea = super.createDialogArea(parent);
        this.getText().setTextLimit(5);
        this.getText().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!Character.isDigit(e.character) && !Character.isISOControl(e.character)) {
                    e.doit = false;
                }
            }
        });
        return createDialogArea;
    }

    public int getValueAsInt() {
        if (this.getValue() != null && this.getValue().matches(VALID_LIMIT_RANGE_REGEX)) {
            return Integer.parseInt(this.getValue());
        }
        return -1;
    }
}

