/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.jhost.ui.fatp;

import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.StringTokenizer;

public class Validator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    private static boolean isUpperOrLowerCaseAlphabet(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c >= 'a' && c <= 'z';
    }

    public static boolean matchDsnPattern(String dsn, String pattern) {
        if (!Validator.validateDataSetName(dsn) || !Validator.validateDataSetNamePattern(pattern)) {
            return false;
        }
        StringTokenizer dsnTokenizer = new StringTokenizer(dsn, ".");
        StringTokenizer patternTokenizer = new StringTokenizer(pattern, ".");
        while (patternTokenizer.hasMoreTokens() && dsnTokenizer.hasMoreTokens()) {
            String currentPatternToken = patternTokenizer.nextToken();
            String currentDsnToken = dsnTokenizer.nextToken();
            if (currentPatternToken.equals("**")) {
                if (patternTokenizer.hasMoreTokens()) {
                    String nextPatternToken = patternTokenizer.nextToken();
                    boolean foundMatch = false;
                    while (true) {
                        if (Validator.matchToken(currentDsnToken, nextPatternToken)) {
                            foundMatch = true;
                            break;
                        }
                        if (!dsnTokenizer.hasMoreTokens()) break;
                        currentDsnToken = dsnTokenizer.nextToken();
                    }
                    if (foundMatch) continue;
                    return false;
                }
                return true;
            }
            if (Validator.matchToken(currentDsnToken, currentPatternToken)) continue;
            return false;
        }
        return !dsnTokenizer.hasMoreTokens() && !patternTokenizer.hasMoreTokens();
    }

    private static boolean matchToken(String dsnToken, String patternToken) {
        if (patternToken.indexOf(42) == -1) {
            return dsnToken.equals(patternToken);
        }
        int patternIndex = 0;
        int dsnIndex = 0;
        while (patternIndex < patternToken.length()) {
            if (patternToken.charAt(patternIndex) == '*') {
                if (patternIndex == patternToken.length() - 1) {
                    return true;
                }
                char nextChar = patternToken.charAt(++patternIndex);
                while (dsnIndex < dsnToken.length() && nextChar != dsnToken.charAt(dsnIndex)) {
                    ++dsnIndex;
                }
            } else if (dsnToken.charAt(dsnIndex) != patternToken.charAt(patternIndex)) {
                return false;
            }
            ++patternIndex;
            ++dsnIndex;
        }
        return true;
    }

    public static boolean validateDataSetName(String dsn) {
        return Validator.validateDataSetName(dsn, false);
    }

    public static boolean validateDataSetName(String dsn, boolean allowVariableNames) {
        if (dsn == null) {
            return false;
        }
        if ((dsn = dsn.trim()).startsWith("'") && dsn.length() > 1) {
            dsn = dsn.substring(1);
        }
        if (dsn.endsWith("'") && dsn.length() > 1) {
            dsn = dsn.substring(0, dsn.length() - 1);
        }
        if (dsn.length() < 3 || dsn.length() > 44) {
            return false;
        }
        if (!allowVariableNames && dsn.indexOf("..") != -1 || dsn.charAt(0) == '.' || dsn.charAt(dsn.length() - 1) == '.') {
            return false;
        }
        if (allowVariableNames) {
            dsn = dsn.replace("..", ".");
        }
        StringTokenizer st = new StringTokenizer(dsn, ".");
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (Validator.validateSegment(segment, allowVariableNames)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean validateDataSetNamePattern(String dsnPattern) {
        if (dsnPattern == null) {
            return false;
        }
        if (Validator.validateDataSetName(dsnPattern = dsnPattern.trim())) {
            return true;
        }
        if (dsnPattern.isEmpty() || dsnPattern.length() > 44) {
            return false;
        }
        st = new StringTokenizer(dsnPattern, ".");
        tokenCount = StringUtils.countRegexpMatches((String)dsnPattern, (String)"\\.");
        if (tokenCount <= 22) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            segment = st.nextToken();
            if (Validator.validatePatternSegment(segment)) continue;
            return false;
lbl14:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl15:
        // 1 sources

        return true;
    }

    public static boolean validateDataSetNameWithMember(String name) {
        String memberName;
        block5: {
            if (name == null) {
                return false;
            }
            if ((name = name.trim()).isEmpty()) {
                return false;
            }
            try {
                String dsn = name.substring(0, name.lastIndexOf(40));
                memberName = name.substring(name.lastIndexOf(40) + 1, name.length() - 1);
                if (Validator.validateDataSetName(dsn)) break block5;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return Validator.validateSegment(memberName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateDataSetNameWithMemberList(String name) {
        if (name == null) {
            return false;
        }
        if ((name = name.trim()).isEmpty()) {
            return false;
        }
        try {
            String dsn = name.substring(0, name.lastIndexOf(40));
            String[] memberNameList = name.substring(name.lastIndexOf(40) + 1, name.length() - 1).split(",");
            if (!Validator.validateDataSetName(dsn)) {
                return false;
            }
            String[] stringArray = memberNameList;
            int n = memberNameList.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String memberName = stringArray[n2];
                if (!Validator.validateSegment(memberName)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean validateDataSetNameWithUserID(String dsn) {
        if (dsn == null) {
            return false;
        }
        if ((dsn = dsn.trim()).isEmpty() || dsn.length() > 44) {
            return false;
        }
        st = new StringTokenizer(dsn, ".");
        tokenCount = StringUtils.countRegexpMatches((String)dsn, (String)"\\.");
        if (tokenCount <= 22) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            segment = st.nextToken();
            if (Validator.validateSegmentWithUserID(segment)) continue;
            return false;
lbl12:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl13:
        // 1 sources

        return true;
    }

    private static boolean validateFirstPatternSegmentChar(char c) {
        if (Validator.isUpperOrLowerCaseAlphabet(c)) {
            return true;
        }
        return c == '#' || c == '@' || c == '$' || c == '*';
    }

    private static boolean validateFirstSegmentChar(char c) {
        return Validator.validateFirstSegmentChar(c, false);
    }

    private static boolean validateFirstSegmentChar(char c, boolean allowVariableNames) {
        if (Validator.isUpperOrLowerCaseAlphabet(c)) {
            return true;
        }
        if (c == '#' || c == '@' || c == '$') {
            return true;
        }
        return allowVariableNames && c == '&';
    }

    public static boolean validatePatternSegment(String segment) {
        if (segment.isEmpty() || segment.length() > 8) {
            return false;
        }
        if (segment.equals("**")) {
            return true;
        }
        if (segment.indexOf("**") != -1) {
            return false;
        }
        char c = segment.charAt(0);
        if (!Validator.validateFirstPatternSegmentChar(c)) {
            return false;
        }
        int i = 1;
        while (i < segment.length()) {
            c = segment.charAt(i);
            if (!Validator.validatePatternSegmentChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean validatePatternSegmentChar(char c) {
        if (Validator.isUpperOrLowerCaseAlphabet(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        return c == '#' || c == '@' || c == '$' || c == '-' || c == '*';
    }

    public static boolean validateSegment(String segment) {
        return Validator.validateSegment(segment, false);
    }

    public static boolean validateSegment(String segment, boolean allowVariableNames) {
        if (segment.isEmpty() || segment.length() > 8) {
            return false;
        }
        char c = segment.charAt(0);
        if (!Validator.validateFirstSegmentChar(c, allowVariableNames)) {
            return false;
        }
        int i = 1;
        while (i < segment.length()) {
            c = segment.charAt(i);
            if (!Validator.validateSegmentChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean validateSegmentChar(char c) {
        if (Validator.isUpperOrLowerCaseAlphabet(c)) {
            return true;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        return c == '#' || c == '@' || c == '$' || c == '-';
    }

    private static boolean validateSegmentWithUserID(String segment) {
        if (segment.isEmpty() || segment.length() > 8) {
            return false;
        }
        if (segment.equals("USERID()")) {
            return true;
        }
        char c = segment.charAt(0);
        if (!Validator.validateFirstSegmentChar(c)) {
            return false;
        }
        int i = 1;
        while (i < segment.length()) {
            c = segment.charAt(i);
            if (!Validator.validateSegmentChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

