/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.jhost.ui.fatp;

import com.ibm.etools.fa.pdtclient.jhost.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATPCleanupTracker;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.jhost.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class FATP
implements AutoCloseable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(FATP.class);
    public static final String PROTOCOL_ID = "FATP/1.1";
    public static final String REQUEST_METHOD_CONNECT = "CONNECT";
    public static final String REQUEST_METHOD_OTPIONS = "OPTIONS";
    public static final String REQUEST_METHOD_HEAD = "HEAD";
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD_PUT = "PUT";
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_METHOD_TRACE = "TRACE";
    public static final String REQUEST_METHOD_DEBUG = "DEBUG";
    public static final String REQUEST_METHOD_COPY = "COPY";
    public static final String REQUEST_METHOD_MOVE = "MOVE";
    public static final String REQUEST_METHOD_DELETE = "DELETE";
    public static final String RESPONSE_STATUS_CONTINUE = "100";
    public static final String RESPONSE_STATUS_OK = "200";
    public static final String RESPONSE_STATUS_CREATED = "201";
    public static final String RESPONSE_STATUS_ACCEPTED = "202";
    public static final String RESPONSE_STATUS_NO_CONTENT = "204";
    public static final String RESPONSE_STATUS_RESET_CONTENT = "205";
    public static final String RESPONSE_STATUS_PARTIAL_CONTENT = "206";
    public static final String RESPONSE_STATUS_MULTIPLE_CHOICES = "300";
    public static final String RESPONSE_STATUS_FOUND = "302";
    public static final String RESPONSE_STATUS_SEE_OTHER = "303";
    public static final String RESPONSE_STATUS_NOT_MODIFIED = "304";
    public static final String RESPONSE_STATUS_BAD_REQUEST = "400";
    public static final String RESPONSE_STATUS_UNAUTHORIZED = "401";
    public static final String RESPONSE_STATUS_FORBIDDEN = "403";
    public static final String RESPONSE_STATUS_NOT_FOUND = "404";
    public static final String RESPONSE_STATUS_METHOD_NOT_ALLOWED = "405";
    public static final String RESPONSE_STATUS_NOT_ACCEPTABLE = "406";
    public static final String RESPONSE_STATUS_CONFLICT = "409";
    public static final String RESPONSE_STATUS_UNSUPPORTED_MEDIA_TYPE = "415";
    public static final String RESPONSE_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE = "416";
    public static final String RESPONSE_STATUS_EXPECTATION_FAILED = "417";
    public static final String RESPONSE_STATUS_INTERNAL_SERVER_ERROR = "500";
    public static final String RESPONSE_STATUS_NOT_IMPLEMENTED = "501";
    public static final String RESPONSE_STATUS_SERVICE_UNAVAILABLE = "503";
    public static final String RESPONSE_STATUS_FATP_VERSION_NOT_SUPPORTED = "505";
    public static final String GENERAL_HEADER_CACHE_CONTROL = "Cache-Control";
    public static final String GENERAL_HEADER_CONNECTION = "Connection";
    public static final String GENERAL_HEADER_DATE = "Date";
    public static final String GENERAL_HEADER_PRAGMA = "Pragma";
    public static final String GENERAL_HEADER_TRAILER = "Trailer";
    public static final String GENERAL_HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String GENERAL_HEADER_UPGRADE = "Upgrade";
    public static final String GENERAL_HEADER_WARNING = "Warning";
    public static final String GENERAL_HEADER_SERVER = "Server";
    public static final String REQUEST_HEADER_ACCEPT = "Accept";
    public static final String REQUEST_HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String REQUEST_HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String REQUEST_HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String REQUEST_HEADER_EXPECT = "Expect";
    public static final String REQUEST_HEADER_HOST = "Host";
    public static final String REQUEST_HEADER_IF_MATCH = "If-Match";
    public static final String REQUEST_HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String REQUEST_HEADER_IF_NONE_MATCH = "If-None-Match";
    public static final String REQUEST_HEADER_IF_RANGE = "If-Range";
    public static final String REQUEST_HEADER_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String REQUEST_HEADER_INCLUDE_DATA_SETS = "Include-Data-Sets";
    public static final String REQUEST_HEADER_MESSAGE = "Message";
    public static final String REQUEST_HEADER_RANGE = "Range";
    public static final String REQUEST_HEADER_REFERER = "Referer";
    public static final String REQUEST_HEADER_TE = "TE";
    public static final String REQUEST_HEADER_USER_AGENT = "User-Agent";
    public static final String REQUEST_HEADER_SUPPRESS_STATUS_CODE_ERROR = "Suppress-Status-Code-Error";
    public static final String REQUEST_HEADER_CLIENT = "Client";
    public static final String RESPONSE_HEADER_ACCEPT_RANGES = "Accept-Ranges";
    public static final String RESPONSE_HEADER_ETAG = "ETag";
    public static final String RESPONSE_HEADER_LOCATION = "Location";
    public static final String RESPONSE_HEADER_RETRY_AFTER = "Retry-After";
    public static final String RESPONSE_HEADER_SERVER = "Server";
    public static final String RESPONSE_HEADER_VARY = "Vary";
    public static final String ENTITY_HEADER_ALLOW = "Allow";
    public static final String ENTITY_HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String ENTITY_HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String ENTITY_HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String ENTITY_HEADER_CONTENT_LOCATION = "Content-Location";
    public static final String ENTITY_HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String ENTITY_HEADER_CONTENT_RANGE = "Content-Range";
    public static final String ENTITY_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String ENTITY_HEADER_EXPIRES = "Expires";
    public static final String ENTITY_HEADER_LAST_MODIFIED = "Last-Modified";
    public static final String ENTITY_HEADER_DESTINATION = "Destination";
    public static final String ENTITY_HEADER_OVERWRITE = "Overwrite";
    public static final String UNKNOWN_CLIENT_VERSION = "unknown";
    private String request_line = "";
    private String status_line = "";
    private Map<String, String> general_header = new HashMap<String, String>();
    private Map<String, String> request_header = new HashMap<String, String>();
    private Map<String, String> response_header = new HashMap<String, String>();
    private Map<String, String> entity_header = new HashMap<String, String>();
    private File temp_file = null;
    private RandomAccessFile entity_body = null;
    private String description = null;

    public static FATP create_request(String _method, String _uri) {
        FATP request = new FATP();
        request.request_line = _method + " " + Ipv6Utils.bracketWrap((String)_uri) + " FATP/1.1";
        return request;
    }

    private static boolean is_general_header(String _field) {
        switch (_field) {
            case "Cache-Control": 
            case "Pragma": 
            case "Server": 
            case "Warning": 
            case "Date": 
            case "Trailer": 
            case "Transfer-Encoding": 
            case "Connection": 
            case "Upgrade": {
                return true;
            }
        }
        return false;
    }

    private static boolean is_request_header(String _field) {
        switch (_field) {
            case "User-Agent": 
            case "Referer": 
            case "Accept-Encoding": 
            case "If-None-Match": 
            case "Accept-Language": 
            case "TE": 
            case "Host": 
            case "If-Match": 
            case "If-Range": 
            case "Range": 
            case "Accept-Charset": 
            case "If-Modified-Since": 
            case "If-Unmodified-Since": 
            case "Accept": 
            case "Expect": {
                return true;
            }
        }
        return false;
    }

    private static boolean is_response_header(String _field) {
        switch (_field) {
            case "Server": 
            case "Retry-After": 
            case "ETag": 
            case "Vary": 
            case "Accept-Ranges": 
            case "Location": {
                return true;
            }
        }
        return false;
    }

    private static String parse_line(ByteArrayInputStream _response, Charset charset) {
        byte[] crlf = charset.encode("\r\n").array();
        byte[] pair = new byte[2];
        StringBuilder line = new StringBuilder();
        while (_response.available() > 0) {
            pair[0] = pair[1];
            pair[1] = (byte)_response.read();
            if (pair[0] != crlf[0] && pair[1] != crlf[1]) {
                line.append(new String(pair, 0, 1, charset));
                continue;
            }
            return line.toString().substring(1);
        }
        return null;
    }

    public static FATP parse_response(ByteArrayInputStream _response, Charset charset) throws Exception {
        FATP response = new FATP();
        response.status_line = FATP.parse_line(_response, charset);
        if (response.status_line == null) {
            response.dispose();
            return null;
        }
        if (!response.is_valid_response()) {
            response.dispose();
            throw new Exception("Invalid response \"" + response.status_line + "\"");
        }
        if (response.parse_message_header(_response, charset)) {
            return response;
        }
        response.dispose();
        return null;
    }

    public FATP() {
        PDSafeRunner.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                FATP.this.temp_file = File.createTempFile("fatp", "entity");
                FATPCleanupTracker.add(FATP.this.temp_file);
                FATP.this.temp_file.deleteOnExit();
                FATP.this.entity_body = new RandomAccessFile(FATP.this.temp_file, "rw");
                return null;
            }
        });
    }

    public void append_body(byte[] _body) {
        this.append_body(_body, _body.length);
    }

    public void append_body(byte[] _body, int _length) {
        this.append_body(_body, 0, _length);
    }

    public void append_body(final byte[] _body, final int _offset, final int _length) {
        PDSafeRunner.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                FATP.this.entity_body.seek(FATP.this.entity_body.length());
                FATP.this.entity_body.write(_body, _offset, _length);
                return null;
            }
        });
    }

    public void append_body(final int _body) {
        PDSafeRunner.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                FATP.this.entity_body.seek(FATP.this.entity_body.length());
                FATP.this.entity_body.write(_body);
                return null;
            }
        });
    }

    public void append_to_entity_header(String _field, String _value) {
        if (!this.entity_header.containsKey(_field)) {
            this.set_entity_header(_field, _value);
        } else {
            this.entity_header.put(_field, this.entity_header.get(_field) + "," + _value);
        }
    }

    public void append_to_general_header(String _field, String _value) {
        if (!this.general_header.containsKey(_field)) {
            this.set_general_header(_field, _value);
        } else {
            this.general_header.put(_field, this.general_header.get(_field) + "," + _value);
        }
    }

    public void append_to_request_header(String _field, String _value) {
        if (!this.request_header.containsKey(_field)) {
            this.set_request_header(_field, _value);
        } else {
            this.request_header.put(_field, this.request_header.get(_field) + "," + _value);
        }
    }

    public void append_to_response_header(String _field, String _value) {
        if (!this.response_header.containsKey(_field)) {
            this.set_response_header(_field, _value);
        } else {
            this.response_header.put(_field, this.response_header.get(_field) + "," + _value);
        }
    }

    private static String buildHeaders(Map<String, String> headerMap) {
        StringBuilder headers = new StringBuilder();
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            headers.append(entry.getKey());
            headers.append(":");
            headers.append(entry.getValue());
            headers.append("\r\n");
        }
        return headers.toString();
    }

    public void dispose() {
        PDSafeRunner.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                if (FATP.this.entity_body != null) {
                    FATP.this.entity_body.close();
                    FATP.this.entity_body = null;
                }
                return null;
            }
        });
        if (this.temp_file != null) {
            if (this.temp_file.exists() && !this.temp_file.delete()) {
                logger.trace(new Object[]{this.temp_file, " temp file delete failed."});
            }
            this.temp_file = null;
        }
    }

    public String get_body(Charset charset) {
        return XMLUtils.replaceIllegalXMLCharacters((String)new String(this.get_body(), charset));
    }

    public byte[] get_body() {
        try {
            if (this.entity_body != null) {
                byte[] body = new byte[(int)this.entity_body.length()];
                this.entity_body.seek(0L);
                this.entity_body.read(body);
                return body;
            }
            return new byte[0];
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    public int get_body_length() {
        try {
            return this.entity_body == null ? 0 : (int)this.entity_body.length();
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            return 0;
        }
    }

    public String get_entity_header(String _field) {
        if (!this.entity_header.containsKey(_field)) {
            return "";
        }
        return this.entity_header.get(_field);
    }

    public String get_entity_headers() {
        return FATP.buildHeaders(this.entity_header);
    }

    public String get_general_header(String _field) {
        if (!this.general_header.containsKey(_field)) {
            return "";
        }
        return this.general_header.get(_field);
    }

    public String get_general_headers() {
        return FATP.buildHeaders(this.general_header);
    }

    public String get_request_header(String _field) {
        if (!this.request_header.containsKey(_field)) {
            return "";
        }
        return this.request_header.get(_field);
    }

    public String get_request_headers() {
        return FATP.buildHeaders(this.request_header);
    }

    public String get_request_method() {
        return this.request_line.split(" ")[0];
    }

    public String get_request_protocol() {
        return this.request_line.split(" ")[2];
    }

    public String get_request_uri() {
        return this.request_line.split(" ")[1];
    }

    public String get_response_header(String _field) {
        if (!this.response_header.containsKey(_field)) {
            return "";
        }
        return this.response_header.get(_field);
    }

    public String get_response_headers() {
        return FATP.buildHeaders(this.response_header);
    }

    public String get_status_line() {
        return this.status_line;
    }

    public String get_status_code() {
        return this.status_line.split(" ")[1];
    }

    public String get_status_protocol() {
        return this.status_line.split(" ")[0];
    }

    public String get_status_reason_phrase() {
        String statusReason = this.status_line.split(" ", 3)[2].trim();
        if (!statusReason.equals(this.get_status_code())) {
            return statusReason;
        }
        switch (this.get_status_code()) {
            case "400": {
                return statusReason + Messages.FATP_ERROR_BAD_REQUEST;
            }
            case "401": {
                return statusReason + Messages.FATP_ERROR_UNAUTHORIZED;
            }
            case "403": {
                return statusReason + Messages.FATP_ERROR_FORBIDDEN;
            }
            case "404": {
                return statusReason + Messages.FATP_ERROR_NOTFOUND;
            }
            case "405": {
                return statusReason + Messages.FATP_ERROR_METHOD_NOTALLOWED;
            }
            case "406": {
                return statusReason + Messages.FATP_ERROR_NOTACCEPTABLE;
            }
            case "409": {
                return statusReason + Messages.FATP_ERROR_CONFLICT;
            }
            case "415": {
                return statusReason + Messages.FATP_ERROR_UNSUPPORTED_MEDIA_TYPE;
            }
            case "416": {
                return statusReason + Messages.FATP_ERROR_REQUESTED_RANGE_NOT_SATISFIABLE;
            }
            case "417": {
                return statusReason + Messages.FATP_ERROR_EXPECTATION_FAILED;
            }
            case "501": {
                return statusReason + Messages.FATP_NotImplemented;
            }
            case "200": {
                return statusReason + Messages.FATP_OK;
            }
            case "204": {
                return statusReason + Messages.FATP_NoContent;
            }
            case "206": {
                return statusReason + Messages.FATP_PartialContent;
            }
        }
        return statusReason;
    }

    public File get_temp_file() {
        return this.temp_file;
    }

    private Ipv6Utils.HostPort getStrippedHostPort() {
        Ipv6Utils.HostPort hostPort = Ipv6Utils.parseHostPort((String)this.get_request_header(REQUEST_HEADER_HOST));
        return new Ipv6Utils.HostPort(Ipv6Utils.bracketStrip((String)hostPort.getHost()), hostPort.getPort());
    }

    public Ipv6Utils.HostPort getEncodedHostPort() {
        Ipv6Utils.HostPort hostPort = this.getStrippedHostPort();
        return new Ipv6Utils.HostPort(Ipv6Utils.encode((String)hostPort.getHost()), hostPort.getPort());
    }

    public String getWrappedHostRequestHeader() {
        return this.get_request_header(REQUEST_HEADER_HOST);
    }

    public String getStrippedHostRequestHeader() {
        Ipv6Utils.HostPort hostPort = this.getStrippedHostPort();
        return hostPort.getHost() + ":" + hostPort.getPort();
    }

    public String getEncodedRequestHeader() {
        Ipv6Utils.HostPort hostPort = this.getEncodedHostPort();
        return hostPort.getHost() + ":" + hostPort.getPort();
    }

    public String getHostOSPath() {
        Ipv6Utils.HostPort hostPort = this.getEncodedHostPort();
        return hostPort.getHost() + "/" + hostPort.getPort();
    }

    public void setHostRequestHeader(String authority) {
        Ipv6Utils.HostPort hostPort = Ipv6Utils.parseHostPort((String)authority);
        this.set_request_header(REQUEST_HEADER_HOST, Ipv6Utils.bracketWrap((String)hostPort.getHost()) + ":" + hostPort.getPort());
    }

    public boolean is_client_error_response() {
        switch (this.get_status_code()) {
            case "400": 
            case "401": 
            case "403": 
            case "404": 
            case "405": 
            case "406": 
            case "409": 
            case "415": 
            case "416": 
            case "417": {
                return true;
            }
        }
        return false;
    }

    public boolean is_information_response() {
        return this.get_status_code().equals(RESPONSE_STATUS_CONTINUE);
    }

    public boolean is_redirection_response() {
        switch (this.get_status_code()) {
            case "300": 
            case "302": 
            case "303": 
            case "304": {
                return true;
            }
        }
        return false;
    }

    public boolean is_server_error_response() {
        switch (this.get_status_code()) {
            case "500": 
            case "501": 
            case "503": 
            case "505": {
                return true;
            }
        }
        return false;
    }

    public boolean is_successful_response() {
        switch (this.get_status_code()) {
            case "200": 
            case "201": 
            case "202": 
            case "204": 
            case "205": 
            case "206": {
                return true;
            }
        }
        return false;
    }

    public boolean is_valid_response() {
        return this.get_status_protocol().equals(PROTOCOL_ID) && (this.is_information_response() || this.is_successful_response() || this.is_redirection_response() || this.is_client_error_response() || this.is_server_error_response());
    }

    public int parse_chunks(ByteArrayInputStream _chunk, Charset _charset) throws Exception {
        String line = FATP.parse_line(_chunk, _charset);
        if (line == null) {
            return -1;
        }
        int chunk_size = Integer.parseInt(line.split(" ", 2)[0], 16);
        if (_chunk.available() < chunk_size) {
            return -1;
        }
        if (chunk_size == 0) {
            if (!this.parse_message_header(_chunk, _charset)) {
                return -1;
            }
        } else {
            byte[] chunk_bytes = new byte[chunk_size];
            _chunk.read(chunk_bytes, 0, chunk_size);
            line = FATP.parse_line(_chunk, _charset);
            if (line == null || !line.isEmpty()) {
                return -1;
            }
            this.append_body(chunk_bytes);
        }
        return chunk_size;
    }

    private boolean parse_message_header(ByteArrayInputStream _header, Charset charset) throws Exception {
        String line = FATP.parse_line(_header, charset);
        if (line != null) {
            while (line != null && !line.isEmpty()) {
                String[] header = line.split(":", 2);
                if (header.length < 2) {
                    throw new Exception("Invalid header \"" + line + "\"");
                }
                String key = header[0].trim();
                String val = header[1].trim();
                if (FATP.is_general_header(key)) {
                    this.append_to_general_header(key, val);
                } else if (FATP.is_response_header(key)) {
                    this.append_to_response_header(key, val);
                } else if (FATP.is_request_header(key)) {
                    this.append_to_request_header(key, val);
                } else {
                    this.append_to_entity_header(key, val);
                }
                line = FATP.parse_line(_header, charset);
            }
            if (line != null && line.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void remove_request_header(String _field) {
        if (this.request_header.containsKey(_field)) {
            this.request_header.remove(_field);
        }
    }

    public void set_entity_header(String _field, String _value) {
        this.entity_header.put(_field, _value);
    }

    public void set_general_header(String _field, String _value) {
        this.general_header.put(_field, _value);
    }

    public void set_request_header(String _field, String _value) {
        this.request_header.put(_field, _value);
    }

    public void set_response_header(String _field, String _value) {
        this.response_header.put(_field, _value);
    }

    public void set_status_line(String protocol, String returnCode, String reasonPhrase) {
        this.status_line = protocol + " " + returnCode + " " + reasonPhrase;
    }

    public String get_request_description() {
        return this.description;
    }

    public void set_request_description(String description) {
        this.description = description;
    }

    public int getHostVersion() {
        String[] parts;
        int index;
        String version = this.get_general_header("Server");
        if (!StringUtils.isNullOrEmpty((String)version) && (index = version.indexOf(32)) > -1 && (parts = (version = version.substring(0, index)).substring(1).replace('R', ':').replace('M', ':').split(":")).length == 3) {
            try {
                return Integer.parseInt(parts[0]) * 10000 + Integer.parseInt(parts[1]) * 100 + Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String toString() {
        if (!this.request_line.isEmpty()) {
            return this.request_line + "\r\n" + this.get_general_headers() + this.get_request_headers() + this.get_entity_headers() + "\r\n";
        }
        if (!this.status_line.isEmpty()) {
            return this.status_line + "\r\n" + this.get_general_headers() + this.get_response_headers() + this.get_entity_headers() + "\r\n";
        }
        return "";
    }

    public String toTrace() {
        return this.description + " " + this.toString().replace("\r\n", ", ");
    }

    @Override
    public void close() {
        this.dispose();
    }
}

