/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.jhost.ui.fatp;

import com.ibm.etools.fa.pdtclient.jhost.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.Validator;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FARL {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String SCHEME = "fatp";
    public static final String CONNECTION_CLOSE = "close";
    private static final String CODEPAGE_ENGLISH = "cp1047";
    private static final String CODEPAGE_JAPANESE = "cp939";
    private static final String CODEPAGE_KOREAN = "cp933";
    public static final Charset CHARSET_ENGLISH = Charset.forName("cp1047");
    public static final Charset CHARSET_JAPANESE = Charset.forName("cp939");
    public static final Charset CHARSET_KOREAN = Charset.forName("cp933");
    public static final String CONTENT_CODING_GZIP = "gzip";
    public static final String CONTENT_CODING_DEFLATE = "deflate";
    public static final String CONTENT_CODING_IDENTITY = "identity";
    public static final String TRANSFER_CODING_CHUNKED = "chunked";
    public static final String TRANSFER_CODING_GZIP = "gzip";
    public static final String TRANSFER_CODING_DEFLATE = "deflate";
    public static final String TRANSFER_CODING_IDENTITY = "identity";
    public static final String TRANSFER_CODING_TRAILERS = "trailers";
    public static final String MEDIA_TYPE_TEXT_PLAIN = "text/plain";
    public static final String MEDIA_TYPE_TEXT_XML = "text/xml";
    public static final String MEDIA_TYPE_APPLICATION_MINIDUMP = "application/minidump";
    public static final String PRODUCT_TOKEN_FAULT_ANALYZER_PLUGIN = "jhost/1.0 FATP/1.1";
    public static final String LANGUAGE_TAG_ENGLISH = "en";
    public static final String LANGUAGE_TAG_JAPANESE = "ja";
    public static final String LANGUAGE_TAG_KOREAN = "ko";
    public static final String ENTITY_TAG_HISTORY_FILE = "\"history file\"";
    public static final String ENTITY_TAG_DEFAULT_HISTORY_FILE = "\"default history file\"";
    public static final String ENTITY_TAG_REPORT = "\"report\"";
    public static final String ENTITY_TAG_MINIDUMP = "\"minidump\"";
    public static final String ENTITY_TAG_FILE = "\"file\"";
    public static final String ENTITY_TAG_VIEW = "\"view\"";
    public static final String ENTITY_TAG_LOOKUP = "\"lookup\"";
    public static final String ENTITY_TAG_IDIHUSRM = "\"IDIHUSRM\"";
    public static final String ENTITY_TAG_LANGX = "\"langx\"";
    public static final String ENTITY_TAG_CODE = "\"code\"";
    public static final String ENTITY_TAG_INFO = "\"info\"";
    public static final String ENTITY_TAG_IDITRACE = "\"iditrace\"";
    public static final String ENTITY_TAG_ZZDEBUG = "\"zzdebug\"";
    public static final String ENTITY_TAG_LOCK_FLAG = "\"lock flag\"";
    public static final String ENTITY_TAG_USERNAME = "\"username\"";
    public static final String ENTITY_TAG_USER_TITLE = "\"user title\"";
    public static final String ENTITY_TAG_CE = "\"CE\"";
    public static final String ENTITY_TAG_ANALYTICS_DATA = "\"analytics\"";
    public static final String ENTITY_TAG_VIEW_LIST = "\"viewlist\"";
    public static final String ENTITY_TAG_LAST_ACC = "\"last accessed history files\"";
    public static final String ENTITY_TAG_CHECK_HISTORY_FILE_EXISTS = "\"checkHistoryFileExists\"";
    public static final String ENTITY_TAG_GET_ABEND_JOB_JCL = "\"getJobJcl\"";
    public static final String ENTITY_TAG_GET_RT_RECORDS = "\"getRTrecords\"";
    public static final String RANGE_UNIT_BYTES = "bytes";
    public static final String EXPECT_CONTINUE = "100-continue";
    public static final String ENTITY_OVERWRITE_FALSE = "F";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(FATP.class);

    public static URI getFARLURI(String hostname) {
        return FARL.getFARLURIimpl(MessageFormat.format("{0}://{1}", SCHEME, Ipv6Utils.bracketWrap((String)hostname).toUpperCase()));
    }

    public static URI getFARLURI(String hostname, String port) {
        return FARL.getFARLURIimpl(MessageFormat.format("{0}://{1}:{2}/", SCHEME, Ipv6Utils.bracketWrap((String)hostname).toUpperCase(), port));
    }

    public static URI getFARLURI(String hostname, String port, String dataset) {
        return FARL.getFARLURIimpl(MessageFormat.format("{0}://{1}:{2}/{3}", SCHEME, Ipv6Utils.bracketWrap((String)hostname).toUpperCase(), port, dataset));
    }

    public static URI getFARLURI(String hostname, String port, String dataset, String member) {
        return FARL.getFARLURIimpl(MessageFormat.format("{0}://{1}:{2}/{3}({4})", SCHEME, Ipv6Utils.bracketWrap((String)hostname).toUpperCase(), port, dataset, member));
    }

    private static URI getFARLURIimpl(String uriString) {
        int index = ((String)uriString).indexOf(35);
        if (index != -1 && index != ((String)uriString).length() - 1) {
            String rhs = ((String)uriString).substring(index + 1, ((String)uriString).length());
            String lhs = ((String)uriString).substring(0, index);
            rhs = rhs.replaceAll("#", "%23");
            uriString = lhs + "#" + rhs;
        }
        return URI.create((String)uriString);
    }

    public static String getPathStringIncludingHash(URI _uri) {
        if (_uri.getFragment() == null) {
            return _uri.getPath();
        }
        String rhs = _uri.getFragment().replaceAll("%23", "#");
        return _uri.getPath() + "#" + rhs;
    }

    public static FATP connect(URI _uri) {
        FATP fatp = FATP.create_request("OPTIONS", "*");
        FARL.set_request_defaults(fatp, _uri);
        return fatp;
    }

    public static FATP copy_fault_entry(URI _src, URI _dst, String includeDataSets, boolean appendIncludeHeader) {
        if (!Validator.validateDataSetNameWithMemberList(FARL.getPathStringIncludingHash(_src).substring(1)) || !Validator.validateDataSetName(FARL.getPathStringIncludingHash(_dst).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("COPY", FARL.getPathStringIncludingHash(_src));
        FARL.set_request_defaults(fatp, _src);
        fatp.set_request_header("If-Match", ENTITY_TAG_REPORT);
        if (appendIncludeHeader) {
            fatp.append_to_request_header("Include-Data-Sets", includeDataSets);
        }
        fatp.set_entity_header("Destination", FARL.getPathStringIncludingHash(_dst));
        fatp.set_entity_header("Overwrite", ENTITY_OVERWRITE_FALSE);
        fatp.set_request_description(Messages.CopyFaultEntryHandler_CopyFaultEntry);
        return fatp;
    }

    public static FATP delete_fault_entry(URI _src) {
        if (!Validator.validateDataSetNameWithMemberList(FARL.getPathStringIncludingHash(_src).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("DELETE", FARL.getPathStringIncludingHash(_src));
        FARL.set_request_defaults(fatp, _src);
        fatp.set_request_header("If-Match", ENTITY_TAG_REPORT);
        fatp.set_request_description(Messages.DeleteFaultEntryHandler_DeleteFaultEntry);
        return fatp;
    }

    public static FATP disconnect(URI _uri) {
        FATP fatp = FATP.create_request("HEAD", "*");
        fatp.set_general_header("Connection", CONNECTION_CLOSE);
        fatp.setHostRequestHeader(_uri.getAuthority());
        fatp.set_request_header("User-Agent", PRODUCT_TOKEN_FAULT_ANALYZER_PLUGIN);
        fatp.set_request_header("Date", DateFormat.getDateTimeInstance().format(new Date()));
        fatp.set_request_description(Messages.FATPJob_Closing_connections);
        return fatp;
    }

    public static FATP get_default_history_file(URI _uri) {
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_DEFAULT_HISTORY_FILE);
        fatp.set_request_header("TE", "identity");
        fatp.set_request_description(Messages.RefreshHistoryFileHandler_Get_default_history_file);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP get_job_jcl(URI _uri) {
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_GET_ABEND_JOB_JCL);
        fatp.set_request_header("TE", "identity");
        fatp.set_request_description(Messages.FARL_AttemptingGetJobJcl);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP createNewHistoryFile(URI _uri, String allocationString) {
        if (!Validator.validateDataSetName(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("POST", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_HISTORY_FILE);
        fatp.set_request_header("TE", "identity");
        fatp.append_body(allocationString.getBytes(CHARSET_ENGLISH));
        fatp.set_entity_header("Content-Length", String.valueOf(fatp.get_body_length()));
        fatp.set_entity_header("Content-Type", "text/plain;charset=" + String.valueOf(CHARSET_ENGLISH));
        fatp.set_request_description(Messages.RefreshHistoryFileHandler_Create_history_file);
        return fatp;
    }

    public static FATP get_history_file(URI _uri) {
        if (!Validator.validateDataSetName(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_HISTORY_FILE);
        fatp.set_request_header("TE", "identity");
        fatp.set_request_description(Messages.RefreshHistoryFileHandler_Open_history_file);
        return fatp;
    }

    public static FATP get_iditrace(URI _uri, String languageTag) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_IDITRACE);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_header("Accept-Language", languageTag);
        fatp.set_request_description(Messages.RefreshReportHandler_Downloading_IDITRACE);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP get_zzdebug(URI _uri, String languageTag) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_ZZDEBUG);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_header("Accept-Language", languageTag);
        fatp.set_request_description(Messages.FARL_downloadZZDEBUG);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP get_info(URI _uri, String languageTag) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_INFO);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_header("Accept-Language", languageTag);
        fatp.set_request_description(Messages.PropertiesHandler_GetFaultEntryInformation);
        return fatp;
    }

    public static FATP get_history_file_info(URI _uri, String languageTag) {
        if (!Validator.validateDataSetName(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_INFO);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_header("Accept-Language", languageTag);
        fatp.set_request_description(Messages.PropertiesHandler_GetFaultEntryInformation);
        return fatp;
    }

    public static FATP get_fault_analytics_data(URI _uri) {
        if (!(Validator.validateDataSetName(FARL.getPathStringIncludingHash(_uri).substring(1)) || Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1)) || FARL.getPathStringIncludingHash(_uri).substring(1).isEmpty())) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_PLAIN);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_ANALYTICS_DATA);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.PropertiesHandler_GetAnalyticsData);
        return fatp;
    }

    public static FATP get_langx(URI _uri) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_LANGX);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.RefreshReportHandler_Saving_langx_source);
        return fatp;
    }

    public static FATP get_minidump(URI _uri) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.append_to_request_header("Accept", MEDIA_TYPE_APPLICATION_MINIDUMP);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_MINIDUMP);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.RefreshReportHandler_DownloadingMinidump);
        return fatp;
    }

    public static FATP get_report(URI _uri, String languageTag) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_PLAIN);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_REPORT);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_header("Accept-Language", languageTag);
        fatp.set_request_description(Messages.RefreshReportHandler_Downloading_report);
        return fatp;
    }

    public static FATP get_server_headers(URI _uri) {
        FATP fatp = FATP.create_request("HEAD", "*");
        FARL.set_request_defaults(fatp, _uri);
        return fatp;
    }

    public static FATP get_file(URI _uri) {
        if (!(FARL.getPathStringIncludingHash(_uri).substring(1).isEmpty() || Validator.validateDataSetName(FARL.getPathStringIncludingHash(_uri).substring(1)) || Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1)))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_FILE);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.DownloadDumpHandler_Downloading_dataset);
        return fatp;
    }

    public static FATP get_last_accessed_history_files(URI _uri) {
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_LAST_ACC);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.FARL_GettingLastAccessHistoryFiles);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP get_check_history_file_exists(URI _uri) {
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_CHECK_HISTORY_FILE_EXISTS);
        fatp.set_request_header("TE", "identity");
        fatp.set_request_description(Messages.FARL_checkIfHistoryFileExists);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP lookup_message(URI _uri, String message) {
        FATP fatp = FATP.create_request("GET", "*");
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_LOOKUP);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.set_request_header("Message", message);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.FARL_lookupMessage);
        return fatp;
    }

    public static FATP loadUserMessages(URI _uri) {
        FATP fatp = FATP.create_request("GET", "*");
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_IDIHUSRM);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.FARL_loadUserMessages);
        return fatp;
    }

    public static FATP get_view(URI _uri) {
        if (!FARL.getPathStringIncludingHash(_uri).substring(1).isEmpty() && !Validator.validateDataSetName(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_VIEW);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.RefreshViewHandler_Refreshing_view_dataset);
        return fatp;
    }

    public static FATP get_view_list(URI _uri) {
        FATP fatp = FATP.create_request("GET", null);
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_VIEW_LIST);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.ViewListHandler_Adding_view_list);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP move_fault_entry(URI _src, URI _dst, String includeDataSets, boolean appendIncludeHeader) {
        if (!Validator.validateDataSetNameWithMemberList(FARL.getPathStringIncludingHash(_src).substring(1)) || !Validator.validateDataSetName(FARL.getPathStringIncludingHash(_dst).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("MOVE", FARL.getPathStringIncludingHash(_src));
        FARL.set_request_defaults(fatp, _src);
        fatp.set_request_header("If-Match", ENTITY_TAG_REPORT);
        if (appendIncludeHeader) {
            fatp.append_to_request_header("Include-Data-Sets", includeDataSets);
        }
        fatp.set_entity_header("Destination", FARL.getPathStringIncludingHash(_dst));
        fatp.set_entity_header("Overwrite", ENTITY_OVERWRITE_FALSE);
        fatp.set_request_description(Messages.MoveFaultEntryHandler_MoveFaultEntry);
        return fatp;
    }

    public static FATP refresh_report(URI _uri, String _options, String languageTag) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("POST", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_PLAIN);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_REPORT);
        fatp.set_request_description(Messages.RefreshReportHandler_Refreshing_report);
        fatp.set_request_header("Accept-Language", languageTag);
        if (_options == null) {
            _options = "";
        }
        if (_options.startsWith("IDIOPTS(")) {
            String options_dsn;
            fatp.set_general_header("Pragma", "options=" + options_dsn + ((options_dsn = _options.split("\\)", 2)[0].split("\\(", 2)[1]).contains("(") ? ")" : ""));
        }
        Pattern optionPattern = Pattern.compile("^(?:IDIOPTS\\(.+?\\))?(DATASETS\\(.*?\\))$");
        Matcher datasetsMatcher = optionPattern.matcher(_options);
        String datasets = null;
        datasets = datasetsMatcher.matches() && datasetsMatcher.groupCount() == 1 ? datasetsMatcher.group(1) : "";
        fatp.append_body(datasets.getBytes(CHARSET_ENGLISH));
        fatp.set_entity_header("Content-Length", String.valueOf(datasets.length()));
        fatp.set_entity_header("Content-Type", "text/plain;charset=" + String.valueOf(CHARSET_ENGLISH));
        return fatp;
    }

    public static FATP set_fault_entry_lock_flag(URI faultEntryUri, String lockFlag) {
        if (!Validator.validateDataSetNameWithMember(faultEntryUri.getPath().substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("PUT", faultEntryUri.getPath());
        FARL.set_request_defaults(fatp, faultEntryUri);
        fatp.set_request_header("If-Match", ENTITY_TAG_LOCK_FLAG);
        fatp.append_body(lockFlag.getBytes(CHARSET_ENGLISH));
        fatp.set_entity_header("Content-Length", String.valueOf(fatp.get_body_length()));
        fatp.set_entity_header("Content-Type", "text/plain;charset=" + String.valueOf(CHARSET_ENGLISH));
        fatp.set_request_description(Messages.SetFaultEntryLockFlag);
        return fatp;
    }

    public static FATP set_fault_entry_username(URI _src, String username) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_src).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("PUT", FARL.getPathStringIncludingHash(_src));
        FARL.set_request_defaults(fatp, _src);
        fatp.set_request_header("If-Match", ENTITY_TAG_USERNAME);
        fatp.append_body(username.getBytes(CHARSET_ENGLISH));
        fatp.set_entity_header("Content-Length", String.valueOf(fatp.get_body_length()));
        fatp.set_entity_header("Content-Type", "text/plain;charset=" + String.valueOf(CHARSET_ENGLISH));
        fatp.set_request_description(Messages.SetFaultEntryUsername);
        return fatp;
    }

    public static FATP set_fault_entry_user_title(URI _src, String userTitle) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_src).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("PUT", FARL.getPathStringIncludingHash(_src));
        FARL.set_request_defaults(fatp, _src);
        fatp.set_request_header("If-Match", ENTITY_TAG_USER_TITLE);
        fatp.append_body(userTitle.getBytes(CHARSET_ENGLISH));
        fatp.set_entity_header("Content-Length", String.valueOf(fatp.get_body_length()));
        fatp.set_entity_header("Content-Type", "text/plain;charset=" + String.valueOf(CHARSET_ENGLISH));
        fatp.set_request_description(Messages.SetFaultEntryUserTitle);
        return fatp;
    }

    private static void set_request_defaults(FATP _fatp, URI _uri) {
        _fatp.setHostRequestHeader(_uri.getAuthority());
        _fatp.set_request_header("User-Agent", PRODUCT_TOKEN_FAULT_ANALYZER_PLUGIN);
        _fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        _fatp.append_to_request_header("Accept-Charset", CODEPAGE_ENGLISH);
        _fatp.append_to_request_header("Accept-Charset", CODEPAGE_JAPANESE);
        _fatp.append_to_request_header("Accept-Charset", CODEPAGE_KOREAN);
        _fatp.append_to_request_header("Accept-Charset", StandardCharsets.UTF_8.name());
        _fatp.set_request_header("Accept-Encoding", "identity");
        _fatp.set_request_header("Date", DateFormat.getDateTimeInstance().format(new Date()));
        _fatp.set_request_header("Accept-Language", System.getProperty("user.language"));
    }

    @Deprecated
    public static FATP start_CE(URI _uri) {
        if (!FARL.getPathStringIncludingHash(_uri).substring(1).isEmpty() && !Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_CE);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_description(Messages.CEHandler_Starting_Process);
        return fatp;
    }

    public static FATP getRTRecordSegments(URI _uri, String languageTag) {
        if (!Validator.validateDataSetNameWithMember(FARL.getPathStringIncludingHash(_uri).substring(1))) {
            return null;
        }
        FATP fatp = FATP.create_request("GET", FARL.getPathStringIncludingHash(_uri));
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_header("Accept", MEDIA_TYPE_TEXT_XML);
        fatp.append_to_request_header("If-Match", ENTITY_TAG_GET_RT_RECORDS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_TRAILERS);
        fatp.append_to_request_header("TE", TRANSFER_CODING_CHUNKED);
        fatp.set_request_header("Accept-Language", languageTag);
        fatp.set_request_description(Messages.RefreshReportHandler_Downloading_saved_report);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP trace_on(URI _uri) {
        FATP fatp = FATP.create_request("TRACE", "*");
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_description(Messages.Preferences_Trace_on);
        return fatp;
    }

    public static FATP zzdebug_on(URI _uri) {
        FATP fatp = FATP.create_request("DEBUG", "*");
        FARL.set_request_defaults(fatp, _uri);
        fatp.set_request_description(Messages.FARL_EnablingZZDEBUG);
        return fatp;
    }

    public static String getFATP_URI(String hostName) {
        return "fatp://" + hostName;
    }
}

