/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.jhost.core.util;

import java.util.List;
import java.util.Objects;

public abstract class FACSVHelper {
    private FACSVHelper() {
    }

    public static <T> String commaSeperateItems(List<T> items, int maxItems) {
        Objects.requireNonNull(items, "Please provide a non-null List of items to CSVize");
        if (maxItems < 0) {
            throw new IllegalArgumentException("Please provide a maxItems of 0 or more.");
        }
        if (items.size() <= maxItems) {
            maxItems = items.size();
        }
        return FACSVHelper.commaSeperateItems(items.subList(0, maxItems));
    }

    private static <T> String commaSeperateItems(List<T> items) {
        Objects.requireNonNull(items, "Please provide a non-null List of items to CSVize");
        if (items.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (T item : items) {
            sb.append(item).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

