/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.nodes;

import com.ibm.pdtools.common.component.jhost.core.model.ISystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsErrorFinder;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelper;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelperNull;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.ISystemTreeNodeProvider;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadErrorNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.RootNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class SystemsTreeNode
implements ISystemsLabelDecorator,
ISystemTreeNodeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private volatile SystemsTreeNode parent;
    private volatile boolean inRS;

    protected SystemsTreeNode() {
        this.parent = null;
        this.inRS = false;
    }

    public SystemsTreeNode(SystemsTreeNode parent) {
        this.parent = this instanceof RootNode ? null : parent;
    }

    public SystemsTreeNode getParent() {
        return this.parent;
    }

    public boolean isInRS() {
        return this.inRS;
    }

    public void setParent(SystemsTreeNode newParent) {
        this.parent = newParent;
    }

    public SystemsTreeNode setInRS(boolean inRS) {
        this.inRS = inRS;
        return this;
    }

    public Object getDataObject() {
        return this;
    }

    public String toString() {
        return "TN: " + this.getClass().getCanonicalName();
    }

    public List<? extends SystemsTreeNode> getChildren() {
        return this.getKnownChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        return Collections.emptyList();
    }

    public boolean hasChildren() {
        return this.getKnownChildren().size() > 0;
    }

    public void refreshSelf() {
        for (SystemsTreeNode systemsTreeNode : this.getKnownChildren()) {
            systemsTreeNode.refreshSelf();
        }
    }

    public void justUnloadThis() {
        this.getHelper().justUnload(this.getDataObject());
    }

    public DelayedNodeHelper getHelper() {
        return DelayedNodeHelperNull.getInstance();
    }

    protected List<SystemsTreeNode> findDecendents() {
        ArrayList<SystemsTreeNode> nodesFound = new ArrayList<SystemsTreeNode>();
        ArrayList<? extends SystemsTreeNode> nodesToVisit = new ArrayList<SystemsTreeNode>();
        nodesToVisit.add(this);
        while (nodesToVisit.size() > 0) {
            SystemsTreeNode current = (SystemsTreeNode)nodesToVisit.remove(nodesToVisit.size() - 1);
            if (!current.hasChildren()) continue;
            List<? extends SystemsTreeNode> children = current.getKnownChildren();
            for (SystemsTreeNode systemsTreeNode : children) {
                nodesFound.add(systemsTreeNode);
            }
            nodesToVisit.addAll(children);
        }
        return nodesFound;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public boolean checkDecorateImageStatic() {
        return SystemsErrorFinder.INSTANCE.hasError(this) && !(this instanceof LoadErrorNode);
    }

    public Object getNewImage(Object anImage) {
        return anImage;
    }

    public static SystemsTreeNode getTargetNode(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof PDSystemsView) {
            TreeViewer tree = ((PDSystemsView)activePart).getTreeViewer();
            tree.expandToLevel((Object)PDTreeHandlerUtil.getFirstSelectedTreeNode(event), 1);
            return PDTreeHandlerUtil.getFirstSelectedTreeNode(event);
        }
        return null;
    }

    public boolean isNotEnabled() {
        return false;
    }

    @Override
    public SystemsTreeNode getFirstNonGrouperNode() {
        return this;
    }
}

