/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.nodes;

import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferenceFeaturesPage;
import com.ibm.pdtools.common.component.ui.views.systems.IHostLeave;
import com.ibm.pdtools.common.component.ui.views.systems.IPDPersistableNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.Objects;

public abstract class SystemsHostUniqueNode
extends SystemsTreeNode
implements IHostProvider,
IHostLeave,
IPDPersistableNode {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost host;
    private PDFeature pdFeature;
    protected boolean queriesLoaded = false;

    protected SystemsHostUniqueNode(PDFeature pdFeature) {
        this.host = null;
        this.pdFeature = pdFeature;
    }

    @Override
    public boolean isSupported(IPDHost host, SystemsTreeNode parent) {
        this.setHost(host);
        this.setParent(parent);
        if (host != null) {
            if (this.pdFeature != null && PDCommonPreferenceFeaturesPage.getFeatureMode(this.getPreferenceId()) && (!this.isQuokka() || PDCommonPreferenceFeaturesPage.isQuokkaEnabled())) {
                return host.supports(this.pdFeature);
            }
            return false;
        }
        return false;
    }

    private void setHost(IPDHost host) {
        if (this.host == null) {
            this.host = host;
        }
    }

    public SystemsHostUniqueNode(IPDHost host, SystemsTreeNode parent) {
        super(parent);
        this.host = Objects.requireNonNull(host, "Must provide a non-null host.");
    }

    public IPDHost getSystem() {
        return this.host;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.host.equals(((SystemsHostUniqueNode)obj).host);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() * this.host.hashCode();
    }

    public boolean isQuokka() {
        return false;
    }

    @Override
    public String getPersistanceName() {
        return String.valueOf(this.getParent().getDataObject()) + "-->" + this.getDataObject().toString();
    }
}

