/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.model;

import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.ui.prefs.PDCommonPreferenceFeaturesPage;
import com.ibm.pdtools.common.component.ui.views.systems.SorterEBCDIC;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.ChildGrouperNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadErrorNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadingNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class DelayedNodeHelper<E extends IHostProvider, V> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ContentCache<E, V> entityContentCache;
    public static final Comparator<SystemsTreeNode> NODE_COMPARATOR = new SystemsTreeNodeComparator();

    public DelayedNodeHelper(ContentCache<E, V> entityContentCache) {
        this.entityContentCache = entityContentCache;
    }

    public boolean isYetToLoad(E entity) {
        IContentLoadStatus<V> loadStatus = this.entityContentCache.getLoadStatus(entity);
        return loadStatus == null || !loadStatus.isLoading() && !loadStatus.isCompleted();
    }

    public void triggerLoad(E entity) {
        if (this.isYetToLoad(entity)) {
            this.entityContentCache.acquireContentLock(entity);
            this.entityContentCache.loadContent(entity);
        }
    }

    public void triggerUnload(E entity) {
        this.entityContentCache.unloadContent(entity);
    }

    public void justUnload(Object entity) {
        this.entityContentCache.unloadContentOnly(entity);
    }

    public ContentCache<E, V> getEntityContentCache() {
        return this.entityContentCache;
    }

    public Runnable getRetryLoadingRunnable(E entity) {
        return new RetryLoadingRunnable(this, entity);
    }

    public List<? extends SystemsTreeNode> getKnownChildren(E entity, SystemsTreeNode parent, ChildrenCreator<V> creator) {
        IContentLoadStatus<V> loadStatus = this.entityContentCache.getLoadStatus(entity);
        List<SystemsTreeNode> children = this.getLoadingChildren(loadStatus, entity, parent);
        if (children != null) {
            return children;
        }
        children = creator.createChildrenFromContent(loadStatus.getContentOnly(), parent);
        return DelayedNodeHelper.applyGrouping(children);
    }

    public List<? extends SystemsTreeNode> getLoadingChildren(IContentLoadStatus<V> loadStatus, E entity, SystemsTreeNode parent) {
        if (loadStatus == null || !loadStatus.isStarted()) {
            return Collections.emptyList();
        }
        if (!loadStatus.isCompleted()) {
            return Collections.singletonList(new LoadingNode(parent));
        }
        if (loadStatus.getError() != null) {
            return Collections.singletonList(new LoadErrorNode(loadStatus.getError(), new RetryLoadingRunnable(this, entity), parent));
        }
        return null;
    }

    public static List<? extends SystemsTreeNode> applyGrouping(List<? extends SystemsTreeNode> children) {
        Objects.requireNonNull(children, "Parameter is null in DelayedNodeHelper.applyGrouping");
        int windowSize = PDCommonPreferenceFeaturesPage.getChildrenWindowSize();
        if (children.size() <= windowSize) {
            return children;
        }
        Collections.sort(children, NODE_COMPARATOR);
        ArrayList<ChildGrouperNode> groupers = new ArrayList<ChildGrouperNode>();
        int i = 0;
        while (i < children.size()) {
            List<? extends SystemsTreeNode> subList = children.subList(i, Math.min(i + windowSize, children.size()));
            ChildGrouperNode grouperNode = new ChildGrouperNode(subList, children.get(0).getParent());
            for (SystemsTreeNode systemsTreeNode : subList) {
                systemsTreeNode.setParent(grouperNode);
            }
            groupers.add(grouperNode);
            i += windowSize;
        }
        return groupers;
    }

    public static interface ChildrenCreator<V> {
        public List<? extends SystemsTreeNode> createChildrenFromContent(V var1, SystemsTreeNode var2);
    }

    private static class RetryLoadingRunnable
    implements Runnable {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private final E entity;
        final /* synthetic */ DelayedNodeHelper this$0;

        public RetryLoadingRunnable(E entity) {
            this.this$0 = var1_1;
            this.entity = entity;
        }

        @Override
        public void run() {
            this.this$0.triggerUnload(this.entity);
        }
    }

    public static class SystemsTreeNodeComparator
    implements Comparator<SystemsTreeNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(SystemsTreeNode o1, SystemsTreeNode o2) {
            return SorterEBCDIC.getInstance().compare(null, o1, o2);
        }
    }
}

