/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.model;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ContentLoader<V>
implements IContentLoadStatus<V> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(ContentCache.class);
    private Job loadJob = null;
    private V content = null;
    private Exception error = null;
    private boolean started = false;

    public synchronized void loadContent(final ICallableWithProgress<V> loader, final Runnable onComplete, String jobName) {
        Objects.requireNonNull(loader, "Please provide a non-null loader.");
        if (!this.isLoading() && !this.isCompleted()) {
            final String name = jobName == null ? Messages.ContentLoader_Loading : jobName;
            final String trace = PDLogger.isTraceEnabled() ? PDLogger.filteredTrace((StackTraceElement[])Thread.currentThread().getStackTrace()) : null;
            this.loadJob = new Job(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    block12: {
                        monitor.beginTask(name, -1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        try {
                            try {
                                if (monitor.isCanceled()) break block12;
                                Object loadedContent = loader.call(howIsGoing);
                                ContentLoader contentLoader = ContentLoader.this;
                                synchronized (contentLoader) {
                                    if (ContentLoader.this.loadJob == this) {
                                        ContentLoader.this.content = loadedContent;
                                        if (PDLogger.isTraceEnabled()) {
                                            logger.trace((Object)("Loaded content " + String.valueOf(ContentLoader.this.content)));
                                            if (trace != null && (ContentLoader.this.content == null || "[]".equals(ContentLoader.this.content.toString()))) {
                                                logger.trace((Object)trace);
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (ContentLoader.this.loadJob == this) {
                                    ContentLoader.this.setError(e);
                                }
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    onComplete.run();
                }
            });
            this.started = true;
            this.loadJob.setUser(true);
            this.loadJob.setPriority(30);
            List<PDSystemsView> pdSystemView = PDSystemsView.getInstances();
            if (pdSystemView.size() > 0) {
                IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)pdSystemView.get(0).getSite().getAdapter(IWorkbenchSiteProgressService.class);
                siteService.schedule(this.loadJob, 0L, true);
            } else {
                IWorkbenchWindow workbenchWindow;
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
                    IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)workbenchWindow.getPartService().getActivePart().getSite().getAdapter(IWorkbenchSiteProgressService.class);
                    siteService.schedule(this.loadJob, 0L, true);
                }
            }
        }
    }

    public synchronized void unloadContent() {
        if (this.loadJob != null) {
            this.loadJob.cancel();
            this.loadJob = null;
        }
        this.content = null;
        this.error = null;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isLoading() {
        return this.loadJob != null && this.loadJob.getState() != 0;
    }

    public synchronized boolean isCompleted() {
        return this.loadJob != null && this.loadJob.getState() == 0;
    }

    private synchronized void setError(Exception error) {
        this.error = error;
        if (error instanceof InterruptedException) {
            logger.trace((Throwable)error);
        } else {
            logger.error((Throwable)error);
        }
    }

    public synchronized Exception getError() {
        return this.error;
    }

    public synchronized V getContentOnly() {
        if (!this.isCompleted()) {
            return null;
        }
        return this.content;
    }

    public static interface ICallableWithProgress<V> {
        public V call(IHowIsGoing var1) throws CommunicationException, InterruptedException;
    }
}

