/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.handlers;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsErrorFinder;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDEventNode;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.LoadErrorNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import org.eclipse.core.commands.ExecutionEvent;

public class ViewErrors
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String COMMAND_ID = "com.ibm.pdtools.common.component.ui.model.commands.viewErrors";

    @Override
    protected void handle(ExecutionEvent event) {
        if (event.getTrigger() instanceof PDEventNode) {
            SystemsTreeNode node = PDTreeHandlerUtil.getFirstSelectedRseNode(event);
            if (node != null) {
                ViewErrors.showIt(node, ((PDEventNode)((Object)event.getTrigger())).isFromPDSystemsView());
            }
        } else {
            ViewErrors.showIt(PDTreeHandlerUtil.getFirstSelectedTreeNode(event), true);
        }
    }

    private static void showIt(final SystemsTreeNode node, final boolean refreshTree) {
        if (!SystemsErrorFinder.INSTANCE.hasError(node)) {
            PDDialogs.openErrorThreadSafe(Messages.ViewErrors_NO_ERROR_AVAILABLE);
            return;
        }
        PDSafeUIRunner.asyncExec(new Runnable(){

            @Override
            public void run() {
                String errorText = SystemsErrorFinder.INSTANCE.getErrorText(node);
                if (node instanceof LoadErrorNode) {
                    final LoadErrorNode errorNode = (LoadErrorNode)node;
                    PDDialogWithText.ITextDialogRunnable retryAction = new PDDialogWithText.ITextDialogRunnable(){

                        @Override
                        public void run(PDDialogWithText context) {
                            errorNode.refreshSelf();
                            context.close();
                            if (refreshTree) {
                                PDSystemsView.tryRefresh();
                            }
                        }
                    };
                    PDDialogWithText.openErrorThreadSafe(Messages.Error, Messages.ViewErrors_ERRORS_SHOWN_BELOW, errorText, new String[]{Messages.ViewErrors_BUTTON_RETRY}, new PDDialogWithText.ITextDialogRunnable[]{retryAction});
                } else {
                    PDDialogWithText.openErrorThreadSafe(Messages.Error, Messages.ViewErrors_ERRORS_SHOWN_BELOW, errorText);
                }
            }
        });
    }

    public static void doOpen(SystemsTreeNode selected, IPDHost system) {
        if (system != null && selected != null) {
            ViewErrors.showIt(selected, false);
        }
    }
}

