/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class PDTypedUtil<TYPE> {
    private final Class<TYPE> type;

    protected static <T> List<T> getSelectedTreeNodesChecked(ExecutionEvent event, Class<T> type, boolean all) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        return PDTypedUtil.getSelectedItems(selection, type, all);
    }

    protected static <T> List<T> getSelectedTreeNodes(ExecutionEvent event, Class<T> type, boolean all) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return PDTypedUtil.getSelectedItems(selection, type, all);
    }

    private static <T> T getFirstSelectedTreeNodeChecked(ExecutionEvent event, Class<T> type) throws ExecutionException {
        List<T> nodes = PDTypedUtil.getSelectedTreeNodesChecked(event, type, false);
        if (!nodes.isEmpty()) {
            return nodes.get(0);
        }
        throw new ExecutionException("selection is empty.");
    }

    private static <T> T getFirstSelectedTreeNode(ExecutionEvent event, Class<T> type) {
        List<T> nodes = PDTypedUtil.getSelectedTreeNodes(event, type, false);
        if (!nodes.isEmpty()) {
            return nodes.get(0);
        }
        return null;
    }

    private static <T> T getFirstSelectedNodeWithType(ISelection selection, Class<T> type) {
        List<T> selectedTreeNodes = PDTypedUtil.getSelectedItems(selection, type, false);
        if (!selectedTreeNodes.isEmpty()) {
            return selectedTreeNodes.get(0);
        }
        return null;
    }

    private static <T> List<T> getSelectedItems(ISelection selection, Class<T> type, boolean all) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<T> selectedItems = new ArrayList<T>();
            if (all) {
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (type.isInstance(item)) {
                        selectedItems.add(type.cast(item));
                    }
                    ++n2;
                }
            } else {
                Object item = ss.getFirstElement();
                if (type.isInstance(item)) {
                    selectedItems.add(type.cast(item));
                }
            }
            return selectedItems;
        }
        return Collections.emptyList();
    }

    public List<TYPE> getSelectedItems(ISelection selection) {
        return PDTypedUtil.getSelectedItems(selection, this.type, true);
    }

    public TYPE getFirstSelectedTreeNode(ISelection selection) {
        return PDTypedUtil.getFirstSelectedNodeWithType(selection, this.type);
    }

    public TYPE getFirstSelectedTreeNodeChecked(ExecutionEvent event) throws ExecutionException {
        return PDTypedUtil.getFirstSelectedTreeNodeChecked(event, this.type);
    }

    public TYPE getFirstSelectedTreeNode(ExecutionEvent event) {
        return PDTypedUtil.getFirstSelectedTreeNode(event, this.type);
    }

    public List<TYPE> getSelectedTreeNodesChecked(ExecutionEvent event) throws ExecutionException {
        return PDTypedUtil.getSelectedTreeNodesChecked(event, this.type, true);
    }

    protected PDTypedUtil(Class<TYPE> type) {
        this.type = type;
    }
}

