/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.handlers;

import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDEventNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public final class PDTreeHandlerUtil {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static SystemsTreeNode getFirstSelectedTreeNode(ExecutionEvent event) {
        Objects.requireNonNull(event, "Event must not be null");
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return PDTreeHandlerUtil.getFirstSelectedElement(currentSelection);
    }

    public static SystemsTreeNode getFirstSelectedRseNode(ExecutionEvent event) {
        Objects.requireNonNull(event, "Event must not be null");
        if (event.getTrigger() instanceof PDEventNode) {
            return ((PDEventNode)((Object)event.getTrigger())).getNode();
        }
        return null;
    }

    public static SystemsTreeNode getFirstSelectedElement(ISelection selection) {
        ITreeSelection treeSel;
        if (selection instanceof ITreeSelection && (treeSel = (ITreeSelection)selection).getFirstElement() instanceof SystemsTreeNode) {
            return (SystemsTreeNode)treeSel.getFirstElement();
        }
        return null;
    }

    public static List<SystemsTreeNode> getSelectedTreeNodes(ExecutionEvent event) {
        Objects.requireNonNull(event, "Event must not be null");
        ArrayList<SystemsTreeNode> selectedTreeNodes = new ArrayList<SystemsTreeNode>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof ITreeSelection) {
            ITreeSelection treeSel = (ITreeSelection)currentSelection;
            for (Object next : treeSel) {
                if (!(next instanceof SystemsTreeNode)) continue;
                selectedTreeNodes.add((SystemsTreeNode)next);
            }
        }
        return selectedTreeNodes;
    }

    public static Object getFirstSelectedDataObject(ExecutionEvent event) {
        Objects.requireNonNull(event, "Event must not be null");
        return PDTreeHandlerUtil.getFirstSelectedTreeNode(event).getDataObject();
    }

    public static List<Object> getSelectedDataObjects(ExecutionEvent event) {
        Objects.requireNonNull(event, "Event must not be null");
        ArrayList<Object> selectedDataObjects = new ArrayList<Object>();
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof ITreeSelection) {
            ITreeSelection treeSel = (ITreeSelection)currentSelection;
            for (Object next : treeSel) {
                if (!(next instanceof SystemsTreeNode)) continue;
                selectedDataObjects.add(((SystemsTreeNode)next).getDataObject());
            }
        }
        if (selectedDataObjects.isEmpty()) {
            PDLogger.get(PDTreeHandlerUtil.class).trace((Object)"Cancelling - no items selected");
        }
        return selectedDataObjects;
    }

    public static PDSystemsView getActiveSystemsViewChecked(ExecutionEvent event) throws ExecutionException {
        Objects.requireNonNull(event, "Event must not be null");
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (!(part instanceof PDSystemsView)) {
            throw new ExecutionException("Systems Information view is not the active part");
        }
        return (PDSystemsView)part;
    }

    public static IPDHost getSystemFrom(Object o) {
        if (o instanceof SystemsTreeNode) {
            o = ((SystemsTreeNode)o).getDataObject();
        } else if (o instanceof PDEventNode) {
            o = ((PDEventNode)((Object)o)).getSystem();
        }
        if (o instanceof IPDHost) {
            return (IPDHost)o;
        }
        if (o instanceof IHostProvider) {
            return ((IHostProvider)o).getSystem();
        }
        SystemLookupDialog dialog = new SystemLookupDialog();
        if (dialog.open() == 0) {
            return dialog.getSelectedHost();
        }
        PDLogger.get(PDTreeHandlerUtil.class).trace((Object)("User cancelled selecting a system. Object was: " + String.valueOf(o)));
        return null;
    }

    public static IPDHost getHost(String address, int parseInt) {
        List hosts = PDHostJhost.findPDHosts((String)address, (int)parseInt);
        IPDHost host = null;
        if (hosts.isEmpty()) {
            ConnectionUtilities.openDialogForNewConnection();
        } else if (hosts.size() > 1) {
            SystemLookupDialog dialog = new SystemLookupDialog();
            if (dialog.open() == 0) {
                host = dialog.getSelectedHost();
            }
        } else {
            host = (IPDHost)hosts.get(0);
        }
        return host;
    }

    private PDTreeHandlerUtil() {
    }
}

