/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems.handlers;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProviderName;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyName
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void handle(ExecutionEvent event) throws ExecutionException {
        List<SystemsTreeNode> selectedNodes = PDTreeHandlerUtil.getSelectedTreeNodes(event);
        StringBuffer toCopy = new StringBuffer();
        for (SystemsTreeNode node : selectedNodes) {
            Object item;
            if (toCopy.length() > 0) {
                toCopy.append("\r\n");
            }
            if ((item = node.getDataObject()) instanceof IHostProviderName) {
                toCopy.append(((IHostProviderName)item).copyName());
                continue;
            }
            toCopy.append(SystemsLabelProvider.getTextStatic(node));
        }
        if (toCopy.length() > 0) {
            Clipboard cb = new Clipboard(Display.getDefault());
            TextTransfer textTransfer = TextTransfer.getInstance();
            String stringToCopy = toCopy.toString();
            try {
                try {
                    cb.setContents(new Object[]{stringToCopy}, new Transfer[]{textTransfer});
                }
                catch (SWTError e) {
                    PDDialogWithText.openInformation(Display.getDefault().getActiveShell(), Messages.Error, Messages.CopyName_COPY_OF_BELOW_NAMES_FAILED, stringToCopy);
                    cb.dispose();
                }
            }
            finally {
                cb.dispose();
            }
        }
    }
}

