/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SystemsLabelDecorator
extends LabelDecorator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ListenerList<ILabelProviderListener> listeners = new ListenerList();
    private static final Map<String, Image> loadedImages = new HashMap<String, Image>();

    public Image decorateImage(Image image, Object element, IDecorationContext context) {
        return this.decorateImage(image, element);
    }

    public String decorateText(String text2, Object element, IDecorationContext context) {
        return this.decorateText(text2, element);
    }

    public boolean prepareDecoration(Object element, String originalText, IDecorationContext context) {
        return true;
    }

    public static synchronized void clearImageCache() {
        loadedImages.clear();
        for (Image i : loadedImages.values()) {
            i.dispose();
        }
    }

    public Image decorateImage(Image image, Object element) {
        return SystemsLabelDecorator.decorateImageStatic(image, element);
    }

    public static synchronized Image decorateImageStatic(Image image, Object element) {
        Image newImage = image;
        Object item = element;
        boolean has_IMG_NAME_ERROR = false;
        if (element instanceof SystemsTreeNode) {
            item = ((SystemsTreeNode)element).getDataObject();
        }
        if (element instanceof HostNode && item instanceof IPDHost && ((IPDHost)item).isSecured()) {
            newImage = SystemsLabelDecorator.overlay(newImage, "secured", 1);
        }
        if (item instanceof ISystemsLabelDecorator) {
            newImage = (Image)((ISystemsLabelDecorator)item).getNewImage((Object)newImage);
            if (((ISystemsLabelDecorator)item).checkDecorateImageStatic()) {
                has_IMG_NAME_ERROR = true;
            }
        }
        if (element instanceof ISystemsLabelDecorator && ((ISystemsLabelDecorator)element).checkDecorateImageStatic()) {
            has_IMG_NAME_ERROR = true;
        }
        if (has_IMG_NAME_ERROR) {
            newImage = SystemsLabelDecorator.overlay(newImage, "error", 2);
        }
        return newImage == image ? null : newImage;
    }

    public String decorateText(String text2, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static Image overlay(Image image, String overlayImageName, int position) {
        if (image == null || overlayImageName == null) {
            return null;
        }
        Image newImage = loadedImages.get(image.toString() + overlayImageName + Integer.toString(position));
        if (newImage == null) {
            DecorationOverlayIcon errorOverlayer = new DecorationOverlayIcon(image, SystemsLabelDecorator.getImageDescByName(overlayImageName), position);
            newImage = errorOverlayer.createImage();
            loadedImages.put(image.toString() + overlayImageName + Integer.toString(position), newImage);
        }
        return newImage;
    }

    private static ImageDescriptor getImageDescByName(String imageName) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.pdtools.common.component.ui", (String)(ISystemsLabelDecorator.iconsDir + ISystemsLabelDecorator.decorationDir + imageName.toLowerCase() + ".gif"));
    }
}

