/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.core.model.ISorterEBCDIC;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.ChildGrouperNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class SorterEBCDIC
extends ViewerSorter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final SorterEBCDIC instance = new SorterEBCDIC();

    public static SorterEBCDIC getInstance() {
        return instance;
    }

    private SorterEBCDIC() {
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Object item;
        IBaseLabelProvider baseLabelProvider;
        int result = SorterEBCDIC.checkFixedRelations(e1, e2);
        if (result != 0) {
            return result;
        }
        result = -SorterEBCDIC.checkFixedRelations(e2, e1);
        if (result != 0) {
            return result;
        }
        if (e1 instanceof ISorterEBCDIC && ((ISorterEBCDIC)e1).sameInstance(e2)) {
            return ((ISorterEBCDIC)e1).compare(e2);
        }
        if (!e1.getClass().equals(e2.getClass())) {
            String e1CanonicalName = e1.getClass().getCanonicalName();
            String e2CanonicalName = e2.getClass().getCanonicalName();
            if (e1CanonicalName != null && e2CanonicalName != null) {
                return e1CanonicalName.compareTo(e2CanonicalName);
            }
        }
        String e1Text = "";
        String e2Text = "";
        if (viewer != null && (baseLabelProvider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider labeller = (ILabelProvider)baseLabelProvider;
            e1Text = labeller.getText(e1);
            e2Text = labeller.getText(e2);
        }
        if (e1Text == null || e1Text.isEmpty()) {
            e1Text = SystemsLabelProvider.getTextStatic(e1);
        }
        if (e2Text == null || e2Text.isEmpty()) {
            e2Text = SystemsLabelProvider.getTextStatic(e2);
        }
        if ((item = e1) instanceof SystemsTreeNode) {
            item = ((SystemsTreeNode)item).getDataObject();
        }
        HostType hostType = null;
        if (item instanceof IHostProvider) {
            IPDHost system = ((IHostProvider)item).getSystem();
            if (system != null) {
                hostType = system.getHostType();
            }
        } else if (item instanceof IPDHost) {
            hostType = ((IPDHost)item).getHostType();
        }
        return hostType == null ? e1Text.compareToIgnoreCase(e2Text) : new ByteStringComparator(hostType).compare(e1Text, e2Text);
    }

    private static int checkFixedRelations(Object e1, Object e2) {
        if (e1 instanceof ChildGrouperNode && !(e2 instanceof ChildGrouperNode)) {
            return 1;
        }
        if (e1 instanceof ISorterEBCDIC && ((ISorterEBCDIC)e1).hasFixedRelations()) {
            return -1;
        }
        return 0;
    }
}

