/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.views.systems;

import com.ibm.pdtools.common.component.core.model.INaiveTreeUpdater;
import com.ibm.pdtools.common.component.core.model.ITreeContentHolder;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IMemento;

public class PDNaiveTreeUpdater
implements INaiveTreeUpdater {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final TreeViewer viewer;
    private final HostRegistry hostRegistry;
    private final PDTreeContentHolder treeContent;
    private final EListener<EntityEvent<IPDHost>> hostRegistryListener;
    private final INaiveTreeUpdater[] systemsNaiveTreeUpdater;

    public PDNaiveTreeUpdater(final TreeViewer viewer, HostRegistry hostRegistry, final PDTreeContentHolder treeContent) {
        int i;
        this.viewer = viewer;
        this.hostRegistry = hostRegistry;
        this.treeContent = treeContent;
        ITreeContentHolder[] systemsTreeContentHolder = PDHost.getTreeContentHolders();
        if (systemsTreeContentHolder != null) {
            this.systemsNaiveTreeUpdater = new INaiveTreeUpdater[systemsTreeContentHolder.length];
            i = 0;
            while (i < systemsTreeContentHolder.length) {
                this.systemsNaiveTreeUpdater[i] = systemsTreeContentHolder[i].createNaiveTreeUpdater();
                this.systemsNaiveTreeUpdater[i].initialize((INaiveTreeUpdater)this);
                ++i;
            }
        } else {
            this.systemsNaiveTreeUpdater = null;
        }
        this.hostRegistryListener = new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(final EntityEvent<IPDHost> event) {
                block8: {
                    block10: {
                        block9: {
                            block7: {
                                PDNaiveTreeUpdater.this.doAsyncRefresh();
                                if (event.getType() != EntityEventType.ADDED) break block7;
                                final List<HostNode> allHostNodes = treeContent.getNodesOfType(HostNode.class);
                                PDSafeUIRunner.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        viewer.refresh();
                                        IPDHost host = (IPDHost)event.getEntity();
                                        for (HostNode hostNode : allHostNodes) {
                                            if (!((IPDHost)hostNode.getDataObject()).equals(host)) continue;
                                            hostNode.expandSelf();
                                        }
                                    }
                                });
                                if (PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater == null) break block8;
                                int i = 0;
                                while (i < PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater.length) {
                                    PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater[i].addSpecialChangeListener((IPDHost)event.getEntity());
                                    ++i;
                                }
                                break block8;
                            }
                            if (event.getType() != EntityEventType.CHANGED) break block9;
                            IPDHost host = (IPDHost)event.getEntity();
                            final List<SystemsTreeNode> changedHostNodes = treeContent.getNodesFor(host);
                            if (PDHost.getPropertyHostPort().equals(event.getDetail())) {
                                PDSafeUIRunner.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        viewer.refresh();
                                        for (SystemsTreeNode changedHostNode : changedHostNodes) {
                                            List<? extends SystemsTreeNode> hostChildren = changedHostNode.getChildren();
                                            for (SystemsTreeNode systemsTreeNode : hostChildren) {
                                                viewer.collapseToLevel((Object)systemsTreeNode, 1);
                                            }
                                            changedHostNode.refreshSelf();
                                        }
                                    }
                                });
                            } else {
                                PDSafeUIRunner.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        viewer.refresh();
                                    }
                                });
                            }
                            break block8;
                        }
                        if (event.getType() != EntityEventType.REMOVED) break block10;
                        if (PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater == null) break block8;
                        int i = 0;
                        while (i < PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater.length) {
                            PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater[i].removeSpecialChangeListener((IPDHost)event.getEntity());
                            ++i;
                        }
                        break block8;
                    }
                    if (event.getType() == EntityEventType.OLDADDED) {
                        final List<HostNode> allHostNodes = treeContent.getNodesOfType(HostNode.class);
                        PDSafeUIRunner.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IMemento memento;
                                String persistanceNodeName = PDSystemsView.getPersistanceNodeName();
                                String persistanceRootName = PDSystemsView.getPersistanceRootName();
                                String persistanceCloseNodeName = PDSystemsView.getPersistanceCloseNodeName();
                                viewer.refresh();
                                IPDHost host = (IPDHost)event.getEntity();
                                IMemento pdMemento = PDSystemsView.getMemento();
                                if (pdMemento != null && (memento = pdMemento.getChild(persistanceRootName)) != null) {
                                    IMemento[] expandedNodes = memento.getChildren(persistanceNodeName);
                                    for (HostNode hostNode : allHostNodes) {
                                        if (!((IPDHost)hostNode.getDataObject()).equals(host)) continue;
                                        int i = 0;
                                        while (i < expandedNodes.length) {
                                            String id = expandedNodes[i].getID();
                                            if (id != null && hostNode.getPersistanceName().equals(id)) {
                                                hostNode.expandSelf();
                                            }
                                            ++i;
                                        }
                                    }
                                    IMemento[] closedNodes = memento.getChildren(persistanceCloseNodeName);
                                    for (HostNode hostNode : allHostNodes) {
                                        int i = 0;
                                        while (i < closedNodes.length) {
                                            String id = closedNodes[i].getID();
                                            if (id != null && hostNode.getPersistanceName().equals(id)) {
                                                hostNode.collapseSelf();
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        });
                        if (PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater != null) {
                            int i = 0;
                            while (i < PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater.length) {
                                PDNaiveTreeUpdater.this.systemsNaiveTreeUpdater[i].addSpecialChangeListener((IPDHost)event.getEntity());
                                ++i;
                            }
                        }
                    }
                }
            }
        };
        hostRegistry.addListener(this.hostRegistryListener);
        if (this.systemsNaiveTreeUpdater != null && systemsTreeContentHolder != null) {
            i = 0;
            while (i < this.systemsNaiveTreeUpdater.length) {
                this.systemsNaiveTreeUpdater[i].addListeners(systemsTreeContentHolder[i]);
                ++i;
            }
        }
    }

    public <E extends IHostProvider> EListener<EntityEvent<E>> createStandardRegistryListener() {
        EListener listener = new EListener<EntityEvent<E>>(){

            public void onEvent(EntityEvent<E> event) {
                PDSafeUIRunner.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PDNaiveTreeUpdater.this.viewer != null && !(this).PDNaiveTreeUpdater.this.viewer.getControl().isDisposed()) {
                            (this).PDNaiveTreeUpdater.this.viewer.refresh();
                        }
                    }
                });
            }
        };
        return listener;
    }

    public <E extends IHostProvider, V> ContentCache.EntityContentListener<E, V> createStandardContentCacheListener() {
        ContentCache.EntityContentListener listener = new ContentCache.EntityContentListener<E, V>(){

            public void postEntityContentLoad(E entity, IContentLoadStatus<V> status) {
                PDSystemsView.tryRefresh();
            }

            public void preEntityContentUnload(E entity, IContentLoadStatus<V> status) {
                PDSystemsView.tryRefresh();
            }
        };
        return listener;
    }

    private void doAsyncRefresh() {
        PDSafeUIRunner.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PDNaiveTreeUpdater.this.viewer != null && !PDNaiveTreeUpdater.this.viewer.getControl().isDisposed()) {
                    PDNaiveTreeUpdater.this.viewer.refresh();
                }
            }
        });
    }

    public void dispose() {
        this.hostRegistry.removeListener(this.hostRegistryListener);
        if (this.systemsNaiveTreeUpdater != null) {
            ITreeContentHolder[] systemsTreeContentHolder = PDHost.getTreeContentHolders();
            int i = 0;
            while (i < this.systemsNaiveTreeUpdater.length) {
                this.systemsNaiveTreeUpdater[i].dispose(systemsTreeContentHolder[i]);
                ++i;
            }
        }
    }

    public PDTreeContentHolder getTreeContent() {
        return this.treeContent;
    }

    public void initialize(INaiveTreeUpdater pdNaiveTreeUpdater) {
    }

    public void addListeners(ITreeContentHolder iTreeContentHolder) {
    }

    public void dispose(ITreeContentHolder iTreeContentHolder) {
    }

    public void addSpecialChangeListener(IPDHost aHost) {
    }

    public void removeSpecialChangeListener(IPDHost aHost) {
    }
}

