/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class PDUserTask {
    private static final PDLogger logger = PDLogger.get(PDUserTask.class);

    private static Job createJob(final String name, ISchedulingRule rule, final PDUserJobFunction r, boolean user, boolean schedule, JobChangeAdapter jobListener) {
        Objects.requireNonNull(name, "Must provide a non-null name.");
        Objects.requireNonNull(r, "Must provide a non-null Runnable.");
        final String trace = PDLogger.isTraceEnabled() ? Arrays.toString(PDLogger.filter((StackTraceElement[])PDLogger.filteredTraceArray((StackTraceElement[])Thread.currentThread().getStackTrace()), (String[])new String[]{PDUserTask.class.getName(), PDSafeUIRunner.class.getName(), PDSafeRunner.class.getName()})) : null;
        Job job = new Job(name){
            private String originalThreadName;

            protected IStatus run(IProgressMonitor monitor) {
                this.originalThreadName = this.getThread().getName();
                this.getThread().setName(name);
                monitor.beginTask(name, -1);
                try {
                    if (PDLogger.isTraceEnabled()) {
                        logger.trace((Object)("Running job " + name + " | " + trace));
                    }
                    try {
                        if (!monitor.isCanceled()) {
                            r.run(monitor);
                        }
                    }
                    catch (Throwable t) {
                        StringWriter sw = new StringWriter();
                        t.printStackTrace(new PrintWriter(sw));
                        logger.error(new Object[]{"An error occurred while performing an operation: ", sw.toString(), trace});
                    }
                }
                finally {
                    if (PDLogger.isTraceEnabled()) {
                        logger.trace((Object)("Ended job " + name));
                    }
                    monitor.done();
                    this.getThread().setName(this.originalThreadName);
                }
                return Status.OK_STATUS;
            }
        };
        if (rule != null) {
            job.setRule(rule);
        }
        job.setUser(user);
        if (jobListener != null) {
            job.addJobChangeListener((IJobChangeListener)jobListener);
        }
        if (schedule) {
            job.schedule();
        }
        if (PDLogger.isTraceEnabled()) {
            logger.trace((Object)("Created job " + name + " scheduled=" + schedule));
        }
        return job;
    }

    public static Job createAndRunJob(String name, PDUserJobFunction r) {
        return PDUserTask.createJob(name, null, r, false, true, null);
    }

    public static Job createAndRunJob(String name, PDUserJobFunction r, JobChangeAdapter jobListener) {
        return PDUserTask.createJob(name, null, r, false, true, jobListener);
    }

    public static Job createAndRunJob(String name, PDUserJobFunction r, boolean isUser, JobChangeAdapter jobListener) {
        return PDUserTask.createJob(name, null, r, isUser, true, jobListener);
    }

    public static interface PDUserJobFunction {
        public void run(IProgressMonitor var1);
    }
}

