/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.util.PDGenerics;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.util.string.StringInput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDPlatformUIUtils {
    private static final PDLogger logger = PDLogger.get(PDPlatformUIUtils.class);

    @Deprecated
    public static boolean scheduleAndMarkPartBusy(Job job, String id) {
        Objects.requireNonNull(job, "Must specify a non-null job.");
        IViewPart view2 = view.findView(Objects.requireNonNull(id, "Must specify a non-null id."));
        if (view2 != null) {
            PDPlatformUIUtils.scheduleAndMarkPartBusy(job, view2.getSite());
            return true;
        }
        logger.trace(new Object[]{"View ", id, " not found, scheduling job without marking part busy."});
        job.schedule();
        return true;
    }

    public static boolean scheduleAndMarkPartBusy(Job job, IWorkbenchPartSite p) {
        return PDPlatformUIUtils.scheduleAndMarkPartBusy(job, p, 0);
    }

    public static boolean scheduleAndMarkPartBusy(final Job job, final IWorkbenchPartSite p, final int delay) {
        Boolean result = PDSafeUIRunner.syncExec(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                IWorkbenchSiteProgressService siteService;
                Objects.requireNonNull(job, "Must provide a non-null job.");
                if (p != null && (siteService = (IWorkbenchSiteProgressService)p.getAdapter(IWorkbenchSiteProgressService.class)) != null) {
                    siteService.schedule(job, (long)delay, true);
                    return true;
                }
                job.schedule();
                return true;
            }
        });
        return result == null ? false : result;
    }

    public static IWorkbenchPage getActiveIWorkbenchPage() {
        return PDSafeUIRunner.syncExec(new Callable<IWorkbenchPage>(){

            @Override
            public IWorkbenchPage call() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        return window.getActivePage();
                    }
                    logger.trace((Object)"There is no active workbench window.");
                } else {
                    logger.trace((Object)"Could not get the workbench.");
                }
                return null;
            }
        });
    }

    public static Display getDisplay() {
        try {
            return PlatformUI.getWorkbench().getDisplay();
        }
        catch (IllegalStateException e) {
            logger.error((Object)"The workbench has not been created yet? - Failed to get Display. ", (Throwable)e);
            return null;
        }
    }

    public static Shell getActiveShell() {
        return PDSafeUIRunner.syncExec(new Callable<Shell>(){

            @Override
            public Shell call() {
                Display display = PDPlatformUIUtils.getDisplay();
                Shell shell = null;
                if (display != null) {
                    shell = display.getActiveShell();
                }
                return shell;
            }
        });
    }

    public static Shell getActivePartShell() {
        return PDSafeUIRunner.syncExec(new Callable<Shell>(){

            @Override
            public Shell call() {
                try {
                    return PDPlatformUIUtils.getActiveIWorkbenchPage().getActivePart().getSite().getShell();
                }
                catch (Exception e) {
                    logger.trace((Object)"Could not get active part site shell; fall back to asking display...");
                    return PDPlatformUIUtils.getActiveShell();
                }
            }
        });
    }

    public static class command {
        public static void executeCommand(final String id) {
            PDSafeRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    IHandlerService handler_service = (IHandlerService)PDTCCui.getDefault().getWorkbench().getService(IHandlerService.class);
                    try {
                        handler_service.executeCommand(id, null);
                    }
                    catch (NotHandledException ex) {
                        if (PDLogger.isTraceEnabled()) {
                            PDSafeUIRunner.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchPage activeIWorkbenchPage = PDPlatformUIUtils.getActiveIWorkbenchPage();
                                    if (activeIWorkbenchPage != null) {
                                        logger.trace((Object)("Active Part Title: " + activeIWorkbenchPage.getActivePart().getTitle()));
                                        logger.trace((Object)("Active Part class: " + String.valueOf(activeIWorkbenchPage.getActivePart().getClass())));
                                        ISelection selection = activeIWorkbenchPage.getSelection();
                                        if (selection instanceof StructuredSelection) {
                                            StructuredSelection str = (StructuredSelection)selection;
                                            logger.trace((Object)"Active Selection: ");
                                            for (Object o : str.toList()) {
                                                logger.trace((Object)(String.valueOf(o.getClass()) + " --> " + String.valueOf(o)));
                                            }
                                        } else if (selection != null) {
                                            logger.trace((Object)selection);
                                        }
                                    }
                                }
                            });
                            logger.trace((Throwable)ex);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                    }
                }
            });
        }
    }

    public static class editor {
        public static void closeAllEditorsWithInput(EditorInputTester tester) {
            editor.closeAllEditorsWithInput(tester, false);
        }

        public static void closeAllEditorsWithInput(EditorInputTester tester, final boolean promptToSave) {
            Objects.requireNonNull(tester, "Must specify a non-null tester.");
            IEditorReference[] activeEditorReferences = editor.getActiveEditorReferences();
            if (activeEditorReferences != null) {
                IEditorReference[] iEditorReferenceArray = activeEditorReferences;
                int n = activeEditorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    final IEditorReference editor2 = iEditorReferenceArray[n2];
                    if (tester.test(editor.getInputFromEditorReference(editor2))) {
                        PDSafeUIRunner.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                                if (page != null) {
                                    page.closeEditors(new IEditorReference[]{editor2}, promptToSave);
                                } else {
                                    logger.trace((Object)"There is no active workbench page; so can't close all editors.");
                                }
                            }
                        });
                    }
                    ++n2;
                }
            }
        }

        public static IEditorPart openEditorOnActivePage(IFile input) {
            return editor.openEditorOnActivePage(input, null, false);
        }

        public static IEditorPart openEditorOnActivePage(IFile input, String id, boolean activate) {
            return PDSafeUIRunner.syncExec(editor.getOpenEditorCallable(input, id, activate));
        }

        public static IEditorPart openEditorOnActivePage(IStorageEditorInput input, String id, boolean activate) {
            return PDSafeUIRunner.syncExec(editor.getOpenEditorCallable(input, id, activate));
        }

        public static IEditorPart openEditorOnActivePage(StringInput input, String id, boolean activate) {
            return PDSafeUIRunner.syncExec(editor.getOpenEditorCallable(input, id, activate));
        }

        public static IEditorPart openEditorOnActivePage(String title, String textForEditor, String editorId, boolean activate) {
            if (textForEditor.length() <= 4096) {
                return editor.openEditorOnActivePage(StringInput.create(textForEditor, title), editorId, activate);
            }
            try {
                IFile tmpFile = PDFileSystemUtil.getTempFile((String)"PDTools", (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                if (IResourceUtils.createIFile((IFile)tmpFile, (String)textForEditor, (Charset)StandardCharsets.UTF_8, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
                    return editor.openEditorOnActivePage(tmpFile, editorId, activate);
                }
            }
            catch (CoreException e) {
                logger.error((Object)"Failed to display text from FMDialogWithText in editor", (Throwable)e);
            }
            return null;
        }

        public static void openEditorOnActivePageAsync(IFile input) {
            editor.openEditorOnActivePageAsync(input, null, false);
        }

        public static void openEditorOnActivePageAsync(final IFile input, final String id, final boolean activate) {
            PDSafeUIRunner.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PDSafeRunner.call(editor.getOpenEditorCallable(input, id, activate));
                }
            });
        }

        private static Callable<IEditorPart> getOpenEditorCallable(final IFile input, final String id, final boolean activate) {
            return new Callable<IEditorPart>(){

                @Override
                public IEditorPart call() throws PartInitException {
                    Objects.requireNonNull(input, "Must specify a non-null input.");
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        if (id != null) {
                            if (activate) {
                                return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (String)id, (boolean)activate);
                            }
                            return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (String)id);
                        }
                        return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (boolean)activate);
                    }
                    logger.trace(new Object[]{"Opening editor with ", id, ": there is no active workbench page."});
                    return null;
                }
            };
        }

        private static Callable<IEditorPart> getOpenEditorCallable(final IStorageEditorInput input, final String id, final boolean activate) {
            return new Callable<IEditorPart>(){

                @Override
                public IEditorPart call() throws PartInitException {
                    Objects.requireNonNull(input, "Must specify a non-null input.");
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        if (id != null) {
                            if (activate) {
                                return page.openEditor((IEditorInput)input, id, activate);
                            }
                            return page.openEditor((IEditorInput)input, id);
                        }
                        logger.trace((Object)"Editor id not specified, Using : org.eclipse.ui.DefaultTextEditor");
                        return page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
                    }
                    logger.trace(new Object[]{"Opening editor with ", id, ": there is no active workbench page."});
                    return null;
                }
            };
        }

        public static IEditorPart openEditor(final IEditorInput input, final String id) {
            return PDSafeUIRunner.syncExec(new Callable<IEditorPart>(){

                @Override
                public IEditorPart call() throws PartInitException {
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        return page.openEditor(Objects.requireNonNull(input, "Must specify a non-null input."), Objects.requireNonNull(id, "Must specify a non-null id."));
                    }
                    logger.trace(new Object[]{"Opening editor with ", id, ": there is no active workbench page."});
                    return null;
                }
            });
        }

        public static IEditorReference[] getActiveEditorReferences() {
            return PDSafeUIRunner.syncExec(new Callable<IEditorReference[]>(){

                @Override
                public IEditorReference[] call() {
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        return page.getEditorReferences();
                    }
                    logger.trace((Object)"There is no active workbench page.");
                    return null;
                }
            });
        }

        public static IEditorInput getInputFromEditorReference(IEditorReference editor2) {
            return editor.getInputFromEditorReference(editor2, IEditorInput.class);
        }

        public static <T extends IEditorInput> T getInputFromEditorReference(final IEditorReference editor2, final Class<T> clazz) {
            return (T)((IEditorInput)PDSafeUIRunner.syncExec(new Callable<T>(){

                @Override
                public T call() throws PartInitException {
                    IEditorInput editorInput = Objects.requireNonNull(editor2, "Must specify a non-null editor.").getEditorInput();
                    if (editorInput != null) {
                        return (IEditorInput)PDGenerics.cast((Object)editorInput, (Class)Objects.requireNonNull(clazz, "Must specify a non-null clazz."));
                    }
                    logger.trace(new Object[]{"Editor ", editor2, " has no input."});
                    return null;
                }
            }));
        }

        public static IEditorInput getInputFromActiveEditor() {
            return PDSafeUIRunner.syncExec(new Callable<IEditorInput>(){

                @Override
                public IEditorInput call() {
                    IEditorPart activeEditor = editor.getActiveEditor();
                    if (activeEditor != null) {
                        return activeEditor.getEditorInput();
                    }
                    logger.trace((Object)"There is no active editor.");
                    return null;
                }
            });
        }

        public static IEditorPart getActiveEditor() {
            return PDSafeUIRunner.syncExec(new Callable<IEditorPart>(){

                @Override
                public IEditorPart call() {
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        return page.getActiveEditor();
                    }
                    logger.trace((Object)"There is no active workbench page.");
                    return null;
                }
            });
        }

        public static interface EditorInputTester {
            public boolean test(IEditorInput var1);
        }

        public static class text {
            public static String getCurrentTextSelectionFromActiveEditor() {
                return PDSafeUIRunner.syncExec(new Callable<String>(){

                    @Override
                    public String call() {
                        ISelection selection;
                        ITextEditor textEditorFromEditorPart;
                        IEditorPart editorPart = editor.getActiveEditor();
                        if (editorPart != null && (textEditorFromEditorPart = (ITextEditor)editorPart.getAdapter(ITextEditor.class)) != null && (selection = textEditorFromEditorPart.getSelectionProvider().getSelection()) instanceof TextSelection) {
                            return ((ITextSelection)selection).getText();
                        }
                        return null;
                    }
                });
            }
        }
    }

    public static class view {
        public static IViewPart showView(String id) {
            return view.showView(id, IViewPart.class);
        }

        public static <T extends IViewPart> T showView(String id, Class<T> clazz) {
            return view.showView(id, clazz, null, ViewMode.VIEW_ACTIVATE);
        }

        public static <T extends IViewPart> T showView(final String id, final Class<T> clazz, final String secondaryId, final ViewMode mode) {
            return (T)((IViewPart)PDSafeUIRunner.syncExec(new Callable<T>(){

                @Override
                public T call() throws PartInitException {
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        String checkedId = Objects.requireNonNull(id, "Must specify a non-null id.");
                        IViewPart v = null;
                        try {
                            v = page.showView(checkedId, secondaryId, mode.getValue());
                        }
                        catch (NullPointerException e) {
                            logger.error((Object)(String.valueOf(e.getClass()) + " thrown while attempting to showView; The view could not be shown."));
                        }
                        if (v != null) {
                            return (IViewPart)PDGenerics.cast((Object)v, (Class)Objects.requireNonNull(clazz, "Must specify a non-null clazz."));
                        }
                        logger.trace(new Object[]{"The view ", id, " could not be shown."});
                    } else {
                        logger.trace(new Object[]{"Showing view ", id, ": there is no active workbench page."});
                        logger.printCurrentStackTrace(id);
                    }
                    return null;
                }
            }));
        }

        public static IViewPart findView(String id) {
            return view.findView(id, IViewPart.class);
        }

        public static <T extends IViewPart> T findView(final String id, final Class<T> clazz) {
            return (T)((IViewPart)PDSafeUIRunner.syncExec(new Callable<T>(){

                @Override
                public T call() {
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        IViewPart v = page.findView(Objects.requireNonNull(id, "Must specify a non-null id."));
                        if (v != null) {
                            return (IViewPart)PDGenerics.cast((Object)v, (Class)Objects.requireNonNull(clazz, "Must specify a non-null clazz."));
                        }
                    } else {
                        logger.trace(new Object[]{"Finding view ", id, ": there is no active workbench page."});
                    }
                    return null;
                }
            }));
        }

        public static <T extends IViewPart> T activate(final String id, final Class<T> clazz) {
            return (T)((IViewPart)PDSafeUIRunner.syncExec(new Callable<T>(){

                @Override
                public T call() {
                    Object v = view.findView(Objects.requireNonNull(id, "Must specify a non-null id."), Objects.requireNonNull(clazz, "Must specify a non-null clazz."));
                    IWorkbenchPage page = PDPlatformUIUtils.getActiveIWorkbenchPage();
                    if (page != null) {
                        page.activate(v);
                    } else {
                        logger.trace(new Object[]{"Activating ", id, ": there is no active workbench page."});
                    }
                    return v;
                }
            }));
        }

        public static enum ViewMode {
            VIEW_ACTIVATE(1),
            VIEW_VISIBLE(2),
            VIEW_CREATE(3);

            private int mode;

            private ViewMode(int mode) {
                this.mode = mode;
            }

            public int getValue() {
                return this.mode;
            }
        }
    }
}

