/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.util;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class PDDialogs {
    private static final String shortMsgFormat = "{0} : {1}";
    private static final String longMsgFormat = "{0} : {1}: {2}";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(PDDialogs.class);

    public static String getTrace() {
        Object[] filter = PDLogger.filter((StackTraceElement[])PDLogger.filteredTraceArray((StackTraceElement[])new Throwable().getStackTrace()), (String[])new String[]{PDDialogs.class.getCanonicalName(), PDDialogWithText.class.getCanonicalName()});
        if (filter.length > 0) {
            return Arrays.toString(filter);
        }
        return "";
    }

    public static void openErrorThreadSafe(final String message) {
        PDDialogs.logErrorMessage(Messages.ERROR_TITLE, message);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)PDPlatformUIUtils.getActivePartShell(), (String)Messages.Error, (String)message);
            }
        });
    }

    public static void openErrorThreadSafe(final String title, final String message, String longMessage, final String displayMessage) {
        PDDialogs.logLongErrorMessage(title, message, longMessage);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openError(PDPlatformUIUtils.getActivePartShell(), title, message, displayMessage);
            }
        });
    }

    public static void openErrorThreadSafe(final String title, final String message, final String longMessage) {
        PDDialogs.logLongErrorMessage(title, message, longMessage);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openError(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage);
            }
        });
    }

    private static void logLongErrorMessage(String title, String message, String longMessage) {
        logger.error(new Object[]{MessageFormat.format(longMsgFormat, title, message, longMessage), PDDialogs.getTrace()});
    }

    private static void logErrorMessage(String title, String message) {
        logger.error(new Object[]{MessageFormat.format(shortMsgFormat, title, message), PDDialogs.getTrace()});
    }

    private static void logLongWarningMessage(String title, String message, String longMessage) {
        logger.warn(new Object[]{MessageFormat.format(longMsgFormat, title, message, longMessage), PDDialogs.getTrace()});
    }

    private static void logWarningMessage(String title, String message) {
        logger.warn(new Object[]{MessageFormat.format(shortMsgFormat, title, message), PDDialogs.getTrace()});
    }

    private static void logLongTraceMessage(String title, String message, String longMessage) {
        logger.trace(new Object[]{MessageFormat.format(longMsgFormat, title, message, longMessage), PDDialogs.getTrace()});
    }

    private static void logTraceMessage(String title, String message) {
        logger.trace(new Object[]{MessageFormat.format(shortMsgFormat, title, message), PDDialogs.getTrace()});
    }

    public static void openErrorThreadSafe(String message, String longMessage) {
        PDDialogs.openErrorThreadSafe(Messages.Error, message, longMessage);
    }

    public static void openErrorThreadSafe(String message, Throwable t) {
        PDDialogs.openErrorThreadSafe(Messages.Error, message);
        logger.error(t);
    }

    public static void openErrorThreadSafe(String message, String longMessage, Throwable t) {
        PDDialogs.openErrorThreadSafe(Messages.Error, message, longMessage, t);
    }

    public static void openErrorThreadSafe(String title, String message, String longMessage, Throwable t) {
        PDDialogs.openErrorThreadSafe(title, message, longMessage);
        logger.error(t);
    }

    public static void openErrorThreadSafe(final String title, final String message, final String longMessage, final String[] additionaLabels, final PDDialogWithText.ITextDialogRunnable[] actions) {
        PDDialogs.logLongErrorMessage(title, message, longMessage);
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionaLabels, actions);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openError(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage, additionaLabels, actions);
            }
        });
    }

    public static void openErrorThreadSafe(String message, String longMessage, String[] additionaLabels, PDDialogWithText.ITextDialogRunnable[] actions) {
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionaLabels, actions);
        PDDialogs.openErrorThreadSafe(Messages.Error, message, longMessage, additionaLabels, actions);
    }

    public static void openWarningThreadSafe(final String title, final String message) {
        PDDialogs.logWarningMessage(title, message);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PDPlatformUIUtils.getActivePartShell(), (String)title, (String)message);
            }
        });
    }

    public static void openWarningThreadSafe(final String title, final String message, final String longMessage) {
        PDDialogs.logLongWarningMessage(title, message, longMessage);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openWarning(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage);
            }
        });
    }

    public static void openWarningThreadSafe(final String title, final String message, final String longMessage, final String[] additionaLabels, final PDDialogWithText.ITextDialogRunnable[] actions) {
        PDDialogs.logLongWarningMessage(title, message, longMessage);
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionaLabels, actions);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openWarning(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage, additionaLabels, actions);
            }
        });
    }

    public static void openInfoThreadSafe(String message) {
        PDDialogs.openInfoThreadSafe(Messages.Information, message);
    }

    public static void openInfoThreadSafe(final String title, final String message) {
        PDDialogs.logTraceMessage(title, message);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageDialog.openInformation((Shell)PDPlatformUIUtils.getActivePartShell(), (String)title, (String)message);
                }
                catch (NullPointerException e) {
                    logger.error((Throwable)e);
                }
            }
        });
    }

    public static void openInfoThreadSafe(final String title, final String message, final String longMessage) {
        PDDialogs.logLongTraceMessage(title, message, longMessage);
        new Thread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PDDialogWithText.openInformation(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage);
                    }
                });
            }
        }).start();
    }

    public static void openInfoThreadSafe(final String title, final String message, final String longMessage, final String[] additionaLabels, final PDDialogWithText.ITextDialogRunnable[] actions) {
        PDDialogs.logLongTraceMessage(title, message, longMessage);
        PDDialogWithText.checkAdditionalLabelsActionsNonNull(additionaLabels, actions);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PDDialogWithText.openInformation(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage, additionaLabels, actions);
            }
        });
    }

    public static boolean openConfirm(String title, String message) {
        PDDialogs.logTraceMessage(title, message);
        return MessageDialog.openConfirm((Shell)PDPlatformUIUtils.getActivePartShell(), (String)title, (String)message);
    }

    public static boolean openConfirmThreadSafe(final String title, final String message) {
        final AtomicBoolean result = new AtomicBoolean(false);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.set(PDDialogs.openConfirm(title, message));
            }
        });
        return result.get();
    }

    public static boolean openQuestion(String message) {
        return PDDialogs.openQuestion(Messages.QUESTION_TITLE, message);
    }

    public static boolean openQuestion(String title, String message) {
        PDDialogs.logTraceMessage(title, message);
        boolean answer = MessageDialog.openQuestion((Shell)PDPlatformUIUtils.getActivePartShell(), (String)title, (String)message);
        logger.trace(new Object[]{"User clicked: ", answer ? "Yes" : "No"});
        return answer;
    }

    public static boolean openQuestion(String title, String message, String longMessage) {
        PDDialogs.logLongTraceMessage(title, message, longMessage);
        return PDDialogWithText.openQuestion(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage);
    }

    public static boolean openQuestionThreadSafe(final String title, final String message, final String longMessage) {
        final AtomicBoolean result = new AtomicBoolean(true);
        PDDialogs.logLongTraceMessage(title, message, longMessage);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.set(PDDialogWithText.openQuestion(PDPlatformUIUtils.getActivePartShell(), title, message, longMessage));
            }
        });
        return result.get();
    }

    public static boolean openQuestionThreadSafe(final String title, final String message) {
        final AtomicBoolean result = new AtomicBoolean(true);
        PDDialogs.logTraceMessage(title, message);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.set(PDDialogWithText.openQuestion((Shell)PDPlatformUIUtils.getActivePartShell(), (String)title, (String)message));
            }
        });
        return result.get();
    }

    public static boolean openQuestionThreadSafe(String message) {
        return PDDialogs.openQuestionThreadSafe(Messages.QUESTION_TITLE, message);
    }

    private static String openFileDialog(final int style, final String folder, final String[] filterExtensions, final String initialFileName) {
        final AtomicReference chosenFile = new AtomicReference();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWorkbenchWindow != null) {
                    FileDialog dialog = new FileDialog(activeWorkbenchWindow.getShell(), style);
                    dialog.setFilterExtensions(filterExtensions);
                    dialog.setFilterPath(folder);
                    dialog.setFileName(initialFileName);
                    chosenFile.set(dialog.open());
                }
            }
        });
        return (String)chosenFile.get();
    }

    public static String openFileDialogForOpen(String folder, String[] filterExtensions, String initialFileName) {
        return PDDialogs.openFileDialog(4096, folder, filterExtensions, initialFileName);
    }

    public static String openFileDialogForSave(String folder, String[] filterExtensions, String initialFileName) {
        return PDDialogs.openFileDialog(8192, folder, filterExtensions, initialFileName);
    }

    public static <T extends Window, V> V openDialogAndRunCallbackIfOk(final T dialog, final WindowCallback<T, V> onOk, V defaultValue) {
        Objects.requireNonNull(dialog, "Must provide a non-null dialog.");
        Objects.requireNonNull(onOk, "Must provide a non-null onOk callback.");
        final AtomicReference<V> result = new AtomicReference<V>(defaultValue);
        if (dialog.open() == 0) {
            PDSafeRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    result.set(onOk.call(dialog));
                }
            });
        }
        return result.get();
    }

    public static <T extends Window> void openDialogAndRunIfOk(final T dialog, final WindowRunnable<T> runnable) {
        Objects.requireNonNull(dialog, "Must provide a non-null dialog.");
        Objects.requireNonNull(runnable, "Must provide a non-null onOk runnable.");
        if (dialog.open() == 0) {
            PDSafeRunner.run((Runnable)new Runnable(){

                @Override
                public void run() {
                    runnable.run(dialog);
                }
            });
        }
    }

    public static boolean openWarningWithToggleThreadSafe(final String title, final String message, final String toggleMessage, final boolean initialToggleState) {
        final AtomicBoolean toggleState = new AtomicBoolean();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                toggleState.set(MessageDialogWithToggle.openWarning((Shell)PDPlatformUIUtils.getActivePartShell(), (String)title, (String)message, (String)toggleMessage, (boolean)initialToggleState, null, null).getToggleState());
            }
        });
        return toggleState.get();
    }

    public static interface WindowCallback<T extends Window, V> {
        public V call(T var1);
    }

    public static interface WindowRunnable<T extends Window> {
        public void run(T var1);
    }
}

