/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog.lookup;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.Messages;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class LoadingContentProvider
implements IStructuredContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(LoadingContentProvider.class);
    private final ContentLoader.ICallableWithProgress<List<?>> loader;
    private final LookupDialog<?> dialog;
    private final Runnable updateViewRunnable;
    private Viewer viewer = null;
    private volatile PatternState newInput = null;
    private volatile PatternState loadedInput = null;
    private volatile boolean isLoading = false;
    private Job loadJob;
    private volatile List<?> loadedObjects;
    private boolean filtered = true;
    private boolean hasLoadedObjects;

    public List<?> getLoadedObjects() {
        return this.loadedObjects;
    }

    public void setLoadedObjects(List<?> loadedObjects) {
        this.loadedObjects = loadedObjects;
    }

    public LoadingContentProvider(ContentLoader.ICallableWithProgress<List<?>> loader, final LookupDialog<?> dialog) {
        this.loader = Objects.requireNonNull(loader, "Please provide a non-null loader.");
        this.dialog = Objects.requireNonNull(dialog, "Please provide a non-null dialog.");
        this.updateViewRunnable = new Runnable(){

            @Override
            public void run() {
                dialog.updateView();
            }
        };
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof PatternState) {
            this.newInput = (PatternState)newInput;
            this.viewer = viewer;
            if (this.loadJob != null) {
                this.loadJob.cancel();
            }
        }
    }

    public PatternState getNewInput() {
        return this.newInput;
    }

    public PatternState getLoadedInput() {
        return this.loadedInput;
    }

    public void dispose() {
        if (this.loadJob != null) {
            this.loadJob.cancel();
        }
    }

    public synchronized Object[] getElements(Object inputElement) {
        if (this.loadedObjects != null && this.filtered && this.dialog.isFilteredSubset(this.newInput, this.loadedInput)) {
            if (this.loadedObjects.size() > 0) {
                return this.loadedObjects.toArray();
            }
            this.setHasLoadedObjects(false);
            return new Object[]{Messages.LoadingContentProvider_NoMatch};
        }
        if (!this.isLoading) {
            this.loadJob = new Job(Messages.LoadingContentProvider_Loading){
                private IHowIsGoing howIsGoing;

                public IStatus run(IProgressMonitor monitor) {
                    IHowIsGoing howIsGoing;
                    monitor.beginTask(Messages.LoadingContentProvider_Loading, 100);
                    this.howIsGoing = howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    monitor.worked(25);
                    monitor.subTask(Messages.LoadingContentProvider_generating);
                    LoadingContentProvider.this.loadedInput = LoadingContentProvider.this.newInput;
                    try {
                        LoadingContentProvider.this.loadedObjects = Arrays.asList(Messages.LoadingContentProvider_Loading);
                        monitor.worked(25);
                        monitor.subTask(Messages.LoadingContentProvider_running);
                        LoadingContentProvider.this.loadedObjects = LoadingContentProvider.this.loader.call(howIsGoing);
                        monitor.worked(50);
                        LoadingContentProvider.this.isLoading = false;
                        LoadingContentProvider.this.setHasLoadedObjects(true);
                        return Status.OK_STATUS;
                    }
                    catch (InterruptedException e) {
                        logger.debug((Object)"Interrupted while loading objects");
                        LoadingContentProvider.this.loadedObjects = Arrays.asList(Messages.LoadingContentProvider_cancelled);
                        LoadingContentProvider.this.loadJob.cancel();
                        LoadingContentProvider.this.isLoading = false;
                        LoadingContentProvider.this.setHasLoadedObjects(false);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        LoadingContentProvider.this.loadedObjects = Arrays.asList(ThrowableRenderer.renderLocalizedManyLiner((Throwable)e));
                        LoadingContentProvider.this.isLoading = false;
                        LoadingContentProvider.this.setHasLoadedObjects(false);
                        return Status.OK_STATUS;
                    }
                }

                protected void canceling() {
                    this.howIsGoing.setCanceled(true);
                }
            };
            this.loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).LoadingContentProvider.this.viewer.getControl().isDisposed()) {
                                (this).LoadingContentProvider.this.viewer.refresh();
                            }
                        }
                    });
                    LoadingContentProvider.this.updateViewRunnable.run();
                }
            });
            this.loadJob.setUser(true);
            IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
            iProgressService.showInDialog(Display.getDefault().getActiveShell(), this.loadJob);
            this.isLoading = true;
            logger.trace((Object)("Schedule loading of pattern " + String.valueOf(this.newInput)));
            this.loadJob.schedule();
        }
        this.dialog.wSelection.setText(Messages.LoadingContentProvider_Loading);
        this.loadedObjects = Arrays.asList(Messages.LoadingContentProvider_Loading);
        return new Object[]{Messages.LoadingContentProvider_Loading};
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean hasLoadedObjects() {
        return this.hasLoadedObjects;
    }

    public void setHasLoadedObjects(boolean hasLoadedObjects) {
        this.hasLoadedObjects = hasLoadedObjects;
    }
}

