/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog.lookup;

import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.ByteStringComparator;
import com.ibm.pdtools.common.component.ui.dialog.lookup.LookupDialog;
import com.ibm.pdtools.common.component.ui.dialog.lookup.PatternState;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public abstract class FastSortLookupDialog<T>
extends LookupDialog<T> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public FastSortLookupDialog(String[] labelList, String[] colNames, String[] initialPatternList, Class<T> type) {
        super(labelList, colNames, initialPatternList, type);
    }

    @Override
    protected boolean isFilteredSubset(PatternState newInput, PatternState loadedInput) {
        return true;
    }

    protected abstract String getColumnText(Object var1, int var2);

    @Override
    protected ViewerComparator getComparator(int columnIndex) {
        if (this.tableViewerComparator instanceof PlatformObjectTableViewerComparator) {
            ((PlatformObjectTableViewerComparator)this.tableViewerComparator).updateComparator(columnIndex);
            return this.tableViewerComparator;
        }
        this.tableViewerComparator = new PlatformObjectTableViewerComparator(columnIndex, 128);
        return this.tableViewerComparator;
    }

    protected class PlatformObjectTableViewerComparator
    extends LookupDialog.TableViewerComparator {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private ByteStringComparator byteStringComparator;

        public PlatformObjectTableViewerComparator(int columnIndex, int sortDirection) {
            super(FastSortLookupDialog.this, columnIndex, sortDirection);
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            String s1 = FastSortLookupDialog.this.getColumnText(e1, this.getColumnIndex());
            String s2 = FastSortLookupDialog.this.getColumnText(e2, this.getColumnIndex());
            if (this.byteStringComparator != null) {
                if (this.getSortAscending()) {
                    return this.byteStringComparator.compare(s1, s2);
                }
                return -this.byteStringComparator.compare(s1, s2);
            }
            return 0;
        }

        @Override
        public void sort(final Viewer viewer, Object[] elements) {
            if (elements != null && elements.length > 0) {
                if (this.byteStringComparator == null) {
                    if (elements[0] instanceof IHostProvider) {
                        HostType hostType = ((IHostProvider)elements[0]).getSystem().getHostType();
                        this.byteStringComparator = new ByteStringComparator(hostType);
                    } else if (elements[0] instanceof IPDHost) {
                        HostType hostType = ((IPDHost)elements[0]).getHostType();
                        this.byteStringComparator = new ByteStringComparator(hostType);
                    }
                }
                Arrays.sort(elements, new Comparator<Object>(){

                    @Override
                    public int compare(Object a, Object b) {
                        return PlatformObjectTableViewerComparator.this.compare(viewer, a, b);
                    }
                });
            }
        }
    }
}

