/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.dialog;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.PDTCCui;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelDecorator;
import com.ibm.pdtools.common.component.ui.views.systems.SystemsLabelProvider;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class SystemLookupDialog
extends FilteredItemsSelectionDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(SystemLookupDialog.class);

    public SystemLookupDialog() {
        super(Display.getDefault().getActiveShell());
        if (PDLogger.isTraceEnabled()) {
            logger.trace((Object)"Prompting for system.");
        }
        PDTCCui.getDefault().loadSysInfoTreeContents();
        this.setTitle(Messages.SystemSelectionDialog_HOST_SELECT_DIALOG_TITLE);
        this.setMessage(Messages.SystemSelectionDialog_HOST_SELECT_DIALOG_MSG);
        this.setListLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new SystemsLabelProvider(){

            @Override
            public String getText(Object element) {
                IPDHost system;
                if (element instanceof IHostProvider && (system = ((IHostProvider)element).getSystem()) != null) {
                    return super.getText(element) + " (" + system.getCodePage() + ")";
                }
                return super.getText(element);
            }
        }, (ILabelDecorator)new SystemsLabelDecorator()));
        this.setSelectionHistory(new FilteredItemsSelectionDialog.SelectionHistory(){

            protected void storeItemToMemento(Object obj, IMemento imemento) {
            }

            protected Object restoreItemFromMemento(IMemento imemento) {
                return null;
            }

            public synchronized Object[] getHistoryItems() {
                return RegistryLocator.instance().getHostRegistry().all().toArray();
            }
        });
    }

    public IPDHost getSelectedHost() {
        Object[] objects = this.getResult();
        if (objects == null) {
            return null;
        }
        if (objects[0] instanceof IPDHost) {
            return (IPDHost)objects[0];
        }
        return null;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object o) {
                return true;
            }

            public boolean matchItem(Object o) {
                if (o instanceof IPDHost) {
                    return this.matchesRawNamePattern(o);
                }
                return false;
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        List hosts = RegistryLocator.instance().getHostRegistry().all();
        for (IPDHost host : hosts) {
            contentProvider.add((Object)host, itemsFilter);
        }
    }

    protected IDialogSettings getDialogSettings() {
        return PDTCCui.getDefault().getDialogSettings();
    }

    public String getElementName(Object item) {
        if (item instanceof IPDHost) {
            return ((IPDHost)item).getConnectionName();
        }
        return null;
    }

    protected Comparator<Object> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public static SystemLookupDialog getSystemLookupDialogForHosts(final String hostName) {
        return new SystemLookupDialog(){

            @Override
            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                return new FilteredItemsSelectionDialog.ItemsFilter(this){

                    public boolean isConsistentItem(Object o) {
                        return true;
                    }

                    public boolean matchItem(Object o) {
                        return o instanceof IPDHost ? ((IPDHost)o).getHostName().equalsIgnoreCase(hostName) && this.matchesRawNamePattern(o) : false;
                    }
                };
            }
        };
    }
}

