/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui.context;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.text.MessageFormat;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class AbstractContext {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(AbstractContext.class);
    private final IWorkbenchPartSite site;
    private final String contextId;
    private IContextActivation activation;

    public AbstractContext(IWorkbenchPartSite site, String contextId) {
        this.site = site;
        this.contextId = contextId;
    }

    public void enable() {
        if (this.site.getService(IContextService.class) == null || this.site.getService(IHandlerService.class) == null || this.site.getService(ICommandService.class) == null) {
            throw new NullPointerException("Could not get all services required to activate a Context.");
        }
        this.activation = ((IContextService)this.site.getService(IContextService.class)).activateContext(this.contextId);
        logger.trace((Object)MessageFormat.format("Activated {0} context", this.contextId));
    }

    public void disable() {
        if (this.activation != null) {
            IContextService iContextService = (IContextService)this.site.getService(IContextService.class);
            if (iContextService != null) {
                iContextService.deactivateContext(this.activation);
                logger.trace((Object)MessageFormat.format("Deactivated {0} context", this.contextId));
            } else {
                logger.trace((Object)MessageFormat.format("Could not get the context service, to disable the {0}context", this.contextId));
            }
        } else {
            logger.error((Object)MessageFormat.format("Could not disable {0} Context, it might not have been enabled", this.contextId));
        }
    }
}

