/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.ui;

import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.ftt.resources.core.physical.IRemoteCommand;
import com.ibm.ftt.resources.core.physical.util.OperationFailedException;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCPreferenceInitializer;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.comms.AuthenticationFrameworkUtilities;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IUIPluginHostConnection;
import com.ibm.pdtools.common.component.core.model.PDHost;
import com.ibm.pdtools.common.component.jhost.IAuthDetailsFetcher;
import com.ibm.pdtools.common.component.jhost.IAuthTokenManager;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionChangeListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener2;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.model.ICertificateTruster;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.prefs.CertificateInformation;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.MFAErrorDialog;
import com.ibm.pdtools.common.component.ui.OTPDialog;
import com.ibm.pdtools.common.component.ui.prefs.CertificateViewerDialog;
import com.ibm.pdtools.common.component.ui.util.AuthTokenManager;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PDTCCui
extends AbstractUIPlugin {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PLUGIN_ID = "com.ibm.pdtools.common.component.ui";
    private PDLogger _private_logger;
    private static PDTCCui plugin;
    private static final String SAVED_TREE_FILENAME = "tree.xml";
    private boolean treeLoaded = false;
    private boolean experimentalTestingFunctionalityEnabled = false;
    private AuthDetails authDetails = null;
    private boolean mfaEnabled = false;
    private String mfaFailureHost;
    private static final String MFA_USER_ENABLED = "YES";
    private static final String MFA_NOT_MFA_USER = "NO";
    private static final String MFA_PROPERTY = "MFA Property";
    private static final String MFA_USER = "MFA Enabled";
    protected static final PDLogger logger;

    static {
        logger = PDLogger.get(PDTCCui.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PDToolsCommonServerClientJhost.setCertificateTruster((ICertificateTruster)new ICertificateTruster(){

            public boolean isCertificateTrusted(X509Certificate aCertificate) {
                return PDTCCui.this.acceptCertificate(aCertificate);
            }
        });
        PDTCCPreferenceInitializer.setupPreferenceProxy((IPreferenceStore)PDTCCcore.getDefault().getPreferenceStore());
        PDLogger.getBundleInfoLog((String)((Object)((Object)this)).getClass().getCanonicalName()).logBundleInfo(context.getBundle());
        PDToolsCommonServerClientJhost.setAuthDetailsFetcher((IAuthDetailsFetcher)new IAuthDetailsFetcher(){

            public AuthDetails fetchAuthDetails(String hostId) {
                ConnectionUtilities.clearPassword((String)hostId);
                return AuthenticationFrameworkUtilities.getUserNameAndPasswordDialogIfRequired((TheHost)new TheHost(hostId, hostId), (String)"com.ibm.pdtools.comms.cics.category");
            }

            public void clearPassword(String hostId) {
                ConnectionUtilities.clearPassword((String)hostId);
            }

            public boolean mfaEnabled(String userName, final String hostName) {
                PDTCCui.this.mfaEnabled = false;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        block18: {
                            try {
                                String value;
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IViewPart viewPart = page.findView("org.eclipse.rse.ui.view.systemView");
                                ISelection selection = viewPart.getViewSite().getSelectionProvider().getSelection();
                                if (selection == null || !(selection instanceof TreeSelection)) break block18;
                                TreeSelection treeSelection = (TreeSelection)selection;
                                TreePath[] treePaths = treeSelection.getPaths();
                                boolean containsZOS = false;
                                zOSSystem containedZos = null;
                                if (treePaths.length > 0) {
                                    int segCount = treePaths[0].getSegmentCount();
                                    int i = 0;
                                    while (i < segCount) {
                                        if (treePaths[0].getSegment(i) instanceof zOSSystem) {
                                            containsZOS = true;
                                            containedZos = (zOSSystem)treePaths[0].getSegment(i);
                                            break;
                                        }
                                        ++i;
                                    }
                                } else if (selection.isEmpty() && page.getActivePart().getTitle().equals("Remote Systems")) {
                                    containsZOS = true;
                                }
                                if (!containsZOS) {
                                    return;
                                }
                                IConnectorService connectorSvc = null;
                                zOSSystem host = null;
                                if (containedZos != null) {
                                    connectorSvc = this.getSuitableConnectorSVC((IHost)containedZos);
                                    host = containedZos;
                                } else {
                                    IHost[] hosts;
                                    IHost[] iHostArray = hosts = RSECorePlugin.getDefault().getSystemRegistry().getHosts();
                                    int n = hosts.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IHost hostSys = iHostArray[n2];
                                        if (hostSys.getAliasName().equals(hostName)) {
                                            host = hostSys;
                                            break;
                                        }
                                        ++n2;
                                    }
                                    if (host != null) {
                                        connectorSvc = this.getSuitableConnectorSVC((IHost)host);
                                    }
                                }
                                if (connectorSvc == null) break block18;
                                if (!connectorSvc.isConnected()) {
                                    try {
                                        connectorSvc.connect((IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if ("0".equals(value = connectorSvc.getPropertySet(PDTCCui.MFA_PROPERTY).getProperty(PDTCCui.MFA_USER).getValue()) || PDTCCui.this.isMFACmdFailed(connectorSvc)) {
                                    PDTCCui.this.setMFAStatus(host.getAliasName(), connectorSvc);
                                }
                                if (PDTCCui.MFA_USER_ENABLED.equals(value = connectorSvc.getPropertySet(PDTCCui.MFA_PROPERTY).getProperty(PDTCCui.MFA_USER).getValue())) {
                                    (this).PDTCCui.this.mfaEnabled = true;
                                }
                            }
                            catch (NullPointerException ex) {
                                (this).PDTCCui.this.mfaEnabled = false;
                            }
                        }
                    }

                    private IConnectorService getSuitableConnectorSVC(IHost host) {
                        IConnectorService[] connectorServices;
                        IConnectorService connectorSvc = null;
                        IConnectorService[] iConnectorServiceArray = connectorServices = host.getConnectorServices();
                        int n = connectorServices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConnectorService connectorService = iConnectorServiceArray[n2];
                            if (connectorService.getClass().getSimpleName().equals("PDConnectorService")) {
                                connectorSvc = connectorService;
                                break;
                            }
                            ++n2;
                        }
                        return connectorSvc;
                    }
                });
                return PDTCCui.this.mfaEnabled;
            }

            public void invokeLoginDialog(final AuthDetails authDetails) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String passcode = "";
                        OTPDialog dialog = new OTPDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        if (dialog.open() == 0) {
                            passcode = dialog.getPassword().trim();
                            authDetails.setPassword(passcode);
                        }
                    }
                });
            }

            public void setMFAFailureHostDetails(String hostDetails) {
                PDTCCui.this.mfaFailureHost = hostDetails;
            }
        });
        PDToolsCommonServerClientJhost.setPwdChangeFetcher((IAuthDetailsFetcher)new IAuthDetailsFetcher(){

            public AuthDetails fetchAuthDetails(String hostId) {
                HostDetails hostDetails = ConnectionUtilities.getHostDetails((String)hostId);
                PDTCCui.this.authDetails = null;
                try {
                    PDTCCui.this.authDetails = ConnectionUtilities.getLogin((TheHost)new TheHost(hostDetails));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String newPaswword = ConnectionUtilities.changeAndReturnNewPwd((String)hostId, (String)PDTCCui.this.authDetails.getPassword(), (String)PDTCCui.this.authDetails.getUsername());
                PDTCCui.this.authDetails.setPassword(newPaswword);
                return PDTCCui.this.authDetails;
            }

            public void clearPassword(String hostId) {
                ConnectionUtilities.clearPassword((String)hostId);
            }

            public boolean mfaEnabled(String userName, String hostName) {
                return false;
            }

            public void invokeLoginDialog(AuthDetails authDetails) {
            }

            public void setMFAFailureHostDetails(String hostDetails) {
            }
        });
        PDToolsCommonServerClientJhost.setAuthTokenManager((IAuthTokenManager)AuthTokenManager.getInstance());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static IDialogSettings getSavingQueriesRoot4Host(IPDHost pdHost) {
        return PDTCCui.getSection(PDTCCui.getSavingQueriesRoot(), pdHost.getHostID() + (pdHost.getDelegatingHost() == null ? "_sIv" : ""));
    }

    public static IDialogSettings getSavingQueriesRoot() {
        return PDTCCui.getSection(PDTCCui.getDefault().getDialogSettings(), PLUGIN_ID);
    }

    public static IDialogSettings getSection(IDialogSettings parent, String id) {
        IDialogSettings pdDialogSettings = PDTCCui.getExistingSection(parent, id);
        if (pdDialogSettings == null) {
            pdDialogSettings = PDTCCui.addSection(parent, id);
        }
        return pdDialogSettings;
    }

    public static IDialogSettings getExistingSection(IDialogSettings parent, String id) {
        return parent.getSection(id);
    }

    public static IDialogSettings[] getSections(IDialogSettings parent) {
        return parent.getSections();
    }

    public static IDialogSettings addSection(IDialogSettings parent, String id) {
        return parent.addNewSection(id);
    }

    public static PDTCCui getDefault() {
        return plugin;
    }

    private PDLogger getLogger() {
        if (this._private_logger == null) {
            this._private_logger = PDLogger.get(PDTCCui.class);
        }
        return this._private_logger;
    }

    public void __setExperimentalTestingFunctionalityEnabled(boolean enable) {
        String caller = Thread.currentThread().getStackTrace()[3].getClassName();
        if (caller.startsWith("com.ibm.etools.fm.test.helper")) {
            this.experimentalTestingFunctionalityEnabled = enable;
            this.getLogger().info((Object)("Experimental testing functionality " + (enable ? "enabled" : "disabled")));
        } else {
            this.getLogger().debug((Object)("Can't turn on experimental testing functionality from caller " + caller));
        }
    }

    public boolean __isExperimentalTestingFunctionalityEnabled() {
        return this.experimentalTestingFunctionalityEnabled;
    }

    public void loadSysInfoTreeContents() {
        if (this.treeLoaded) {
            return;
        }
        IPath stateLocation = null;
        try {
            stateLocation = PDTCCui.getDefault().getStateLocation();
        }
        catch (NullPointerException e) {
            this.getLogger().error((Throwable)e);
        }
        if (stateLocation != null) {
            String path = stateLocation.append(SAVED_TREE_FILENAME).toString();
            File file = new File(path);
            if (file.exists()) {
                File newFile = new File(path + ".bak");
                try {
                    Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    this.getLogger().error((Throwable)e);
                }
                PDTreeContentHolder.getInstance().getLoadTreeJob("tree.xml.bak", true).schedule();
            } else {
                String fmFolder;
                String pluginFolder = stateLocation.lastSegment();
                file = new File(path = path.replace(pluginFolder, fmFolder = "com.ibm.etools.fm.ui"));
                if (file.exists()) {
                    File newFile = new File(path + ".bak");
                    try {
                        Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.getLogger().error((Throwable)e);
                    }
                    PDTreeContentHolder.getInstance().getLoadTreeJob("tree.xml.bak", true).schedule();
                }
            }
            PDTCCui.setupConnectionProfileChangeHandler();
            this.treeLoaded = true;
        }
    }

    public static void saveSysInfo(IMemento memento) {
        PDTreeContentHolder.getInstance().saveTreeStateToMemento(memento);
    }

    public static void restoreSysInfo(IMemento memento) {
        Objects.requireNonNull(memento, "Requires non null memento to restore state");
        PDTreeContentHolder.getInstance().loadTreeStateFromMemento(memento);
    }

    private static void setupConnectionProfileChangeHandler() {
        ConnectionUtilities.addPDConnectionChangeListener((IPDToolsConnectionChangeListener)new IPDToolsConnectionChangeListener(){

            public void newConnection(HostDetails newHostDetails) {
                if (PDTCCui.getHostById(newHostDetails.getHostID()) == null) {
                    IPDHost system = PDHost.create((HostDetails)newHostDetails);
                    RegistryLocator.instance().getHostRegistry().add((Object)system);
                }
            }

            public void deletedConnection(String hostID) {
                IPDHost aHost = PDTCCui.getHostById(hostID);
                if (aHost != null) {
                    RegistryLocator.instance().getHostRegistry().remove((Object)aHost);
                }
                AuthTokenManager.getInstance().removeHostTokens(hostID);
                ConnectionUtilities.clearPassword((String)hostID);
            }

            public void updatedConnection(HostDetails oldHostDetails, HostDetails updatedHostDetails) {
                IPDHost aHost = PDTCCui.getHostById(oldHostDetails.getHostID());
                if (aHost != null) {
                    PDTCCui.updateHostIfChanged(updatedHostDetails, aHost);
                }
                PDSystemsView.tryRefresh();
            }
        });
        ConnectionUtilities.addPDConnectionRequestListener2((IPDToolsConnectionRequestListener2)new IPDToolsConnectionRequestListener2(){

            public void connect(String hostID, List<String> extensions) {
            }

            public void disconnect(String hostID) {
                final IPDHost aHost = PDTCCui.getHostById(hostID);
                if (aHost != null) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            IUIPluginHostConnection[] uiPluginHostConections = PDHost.getUiSystemExtendPlugins();
                            if (uiPluginHostConections != null) {
                                int i = 0;
                                while (i < uiPluginHostConections.length) {
                                    uiPluginHostConections[i].closeConnections(aHost);
                                    ++i;
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static IPDHost getHostById(String hostID) {
        List allHosts = RegistryLocator.instance().getHostRegistry().all();
        int i = 0;
        while (i < allHosts.size()) {
            IPDHost host = (IPDHost)allHosts.get(i);
            if (host.getHostID().equals(hostID)) {
                return host;
            }
            ++i;
        }
        return null;
    }

    private static void updateHostIfChanged(HostDetails aHostDetails, IPDHost aHost) {
        boolean hostChanged = false;
        if (!aHostDetails.getHostID().equals(aHost.getHostID())) {
            throw new IllegalArgumentException();
        }
        if (!aHostDetails.getHostname().equals(aHost.getHostName())) {
            aHost.setHostName(aHostDetails.getHostname());
            hostChanged = true;
        }
        if (aHostDetails.getPortNumber() != aHost.getPort()) {
            aHost.setPort(aHostDetails.getPortNumber());
            hostChanged = true;
        }
        if (!aHost.getDescription().equals(aHostDetails.getDescription())) {
            aHost.setDescription(aHostDetails.getDescription());
        }
        if (!aHost.getCodePage().equals(aHostDetails.getHostDefaultEncoding())) {
            aHost.setCodePage(aHostDetails.getHostDefaultEncoding());
        }
        if (!aHost.getBidiFormat().equals(aHostDetails.getBidiFormat())) {
            aHost.setBidiFormat(aHostDetails.getBidiFormat());
        }
        if (aHost.getHostType() != aHostDetails.getHostType()) {
            aHost.setHostType(aHostDetails.getHostType());
        }
        if (hostChanged) {
            AuthTokenManager.getInstance().removeHostTokens(aHost.getHostID());
            ConnectionUtilities.clearPassword((String)aHost.getHostID());
            IUIPluginHostConnection[] uiPluginHostConections = PDHost.getUiSystemExtendPlugins();
            if (uiPluginHostConections != null) {
                int i = 0;
                while (i < uiPluginHostConections.length) {
                    uiPluginHostConections[i].updateHost(aHost);
                    ++i;
                }
            }
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("icons/delete.gif", PDTCCui.getImageDescriptor("icons/delete.gif"));
        reg.put("icons/view.gif", PDTCCui.getImageDescriptor("icons/view.gif"));
        reg.put("icons/check.gif", PDTCCui.getImageDescriptor("icons/check.gif"));
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        return PDTCCui.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    @Deprecated
    public ArrayList<CertificateInformation> getKnownCertificates() {
        PDToolsCommonServerClientJhost core = PDToolsCommonServerClientJhost.getDefault();
        if (core != null) {
            return core.getKnownCertificates();
        }
        PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Could not get the PDToolsCommonServerClientJhost plugin; Could not get the known certificates.");
        return new ArrayList<CertificateInformation>();
    }

    @Deprecated
    public void addNewCertificate(CertificateInformation newCertificate) {
        PDToolsCommonServerClientJhost core = PDToolsCommonServerClientJhost.getDefault();
        if (core != null) {
            core.addNewCertificate(newCertificate);
        } else {
            PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Could not get the PDToolsCommonServerClientJhost plugin; The certificate could not be added.");
        }
    }

    @Deprecated
    public boolean certificateExists(CertificateInformation certificateDetails) {
        PDToolsCommonServerClientJhost core = PDToolsCommonServerClientJhost.getDefault();
        if (core != null) {
            return core.certificateExists(certificateDetails);
        }
        PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Could not get the PDToolsCommonServerClientJhost plugin; Returning false");
        return false;
    }

    @Deprecated
    public void removeCertificate(CertificateInformation aCertificate) {
        PDToolsCommonServerClientJhost core = PDToolsCommonServerClientJhost.getDefault();
        if (core != null) {
            core.removeCertificate(aCertificate);
            PDLogger.get(((Object)((Object)this)).getClass()).debug((Object)MessageFormat.format("Removed certificate: {0}", aCertificate));
        } else {
            PDLogger.get(((Object)((Object)this)).getClass()).error((Object)"Could not get the PDToolsCommonServerClientJhost plugin; The certificate could not be removed.");
        }
    }

    public boolean acceptCertificate(X509Certificate aCertificate) {
        final CertificateInformation newCert = CertificateInformation.getInstance((X509Certificate)aCertificate);
        if (PDToolsCommonServerClientJhost.getDefault().certificateExists(newCert)) {
            return true;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CertificateViewerDialog dialog = new CertificateViewerDialog(newCert, false);
                if (dialog.open() == 0) {
                    PDToolsCommonServerClientJhost.getDefault().addNewCertificate(newCert);
                    result.set(Boolean.TRUE);
                } else {
                    result.set(Boolean.FALSE);
                }
            }
        });
        return result.get();
    }

    public void setMFAStatus(String hostName, IConnectorService connectorSvc) {
        String[] MFA_KEYWORDS = new String[]{"FACTOR = AZFSIDP1", "FACTOR = AZFTOTP1", "FACTOR = AZFCERT1", "FACTOR = AZFSFNP1", "FACTOR = AZFRADP1", "FACTOR = AZFSIDR1", "FACTOR = AZFPASS1", "FACTOR = AZFYUBI1"};
        IZOSSystemImage[] systems = PBResourceMvsUtils.getAllMVSSubSystems();
        IZOSSystemImage connectedSystem = null;
        IZOSSystemImage[] iZOSSystemImageArray = systems;
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            IZOSSystemImage system = iZOSSystemImageArray[n2];
            if (system.getName().equals(hostName) && !system.isConnected()) {
                try {
                    system.connect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (system.isConnected() && system.getName().equals(hostName)) {
                connectedSystem = system;
                break;
            }
            ++n2;
        }
        IRemoteCommand remoteCommand = connectedSystem.getCommandObject();
        String command2 = "LISTUSER " + connectorSvc.getUserId() + " MFA";
        remoteCommand.setCommandString(command2);
        remoteCommand.setShellId(null);
        String result = "";
        IProperty mfaProperty = connectorSvc.getPropertySet(MFA_PROPERTY).getProperty(MFA_USER);
        try {
            remoteCommand.run();
            result = remoteCommand.getResults();
        }
        catch (OperationFailedException ex) {
            if (this.isMFACmdFailed(connectorSvc)) {
                logger.error((Throwable)ex);
                PDTCCui.showMFAErrorMsg(connectorSvc);
            } else {
                mfaProperty.setValue(MFA_NOT_MFA_USER);
            }
            return;
        }
        boolean enabled = false;
        if (result.contains("MULTIFACTOR AUTHENTICATION INFORMATION:") || result.contains(Messages.MFA_AUTH_INFO)) {
            String[] stringArray = MFA_KEYWORDS;
            int n3 = MFA_KEYWORDS.length;
            int n4 = 0;
            while (n4 < n3) {
                String statusString;
                int index;
                String[] tokens;
                String MFA_KEYWORD = stringArray[n4];
                if (result.contains(MFA_KEYWORD) && (tokens = result.substring(index = result.indexOf(MFA_KEYWORD)).split("\\r?\\n", result.substring(index).length())).length > 0 && (statusString = tokens[1]).trim().equals("STATUS = ACTIVE")) {
                    enabled = true;
                    break;
                }
                ++n4;
            }
            if (enabled) {
                mfaProperty.setValue(MFA_USER_ENABLED);
            } else {
                mfaProperty.setValue(MFA_NOT_MFA_USER);
            }
        } else {
            mfaProperty.setValue(MFA_NOT_MFA_USER);
        }
    }

    private static void showMFAErrorMsg(final IConnectorService connectorSVC) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MFAErrorDialog mfaErrorDialog = new MFAErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                if (mfaErrorDialog.open() == 0) {
                    IProperty mfaProperty = connectorSVC.getPropertySet(PDTCCui.MFA_PROPERTY).getProperty(PDTCCui.MFA_USER);
                    mfaProperty.setValue(PDTCCui.MFA_USER_ENABLED);
                    return;
                }
                IProperty mfaProperty = connectorSVC.getPropertySet(PDTCCui.MFA_PROPERTY).getProperty(PDTCCui.MFA_USER);
                mfaProperty.setValue(PDTCCui.MFA_NOT_MFA_USER);
            }
        });
    }

    private boolean isMFACmdFailed(IConnectorService connectorSvc) {
        return this.mfaFailureHost != null && this.mfaFailureHost.equals(connectorSvc.getHost().getAliasName() + ":" + connectorSvc.getUserId());
    }
}

