/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.systems.properties;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.handler.historyfile.GetHistoryFilePropertiesHandler;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemsViewHistoryFilePropertySource
implements IPropertySource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(SystemsViewHistoryFilePropertySource.class);
    private static final Object KEY_NAME = new Object();
    private static final Object KEY_PATH = new Object();
    private static final PropertyDescriptor PROPERTY_NAME = new PropertyDescriptor(KEY_NAME, Messages.HistoryFileName);
    private static final PropertyDescriptor PROPERTY_PATH = new PropertyDescriptor(KEY_PATH, Messages.HistoryFileLocalPath);
    private static final int EXTRA_PROPERTIES = 2;
    private SystemsViewHistoryFile historyFile;
    private static final QualifiedName qualifiedName = new QualifiedName("historyFile", "dsn");

    public SystemsViewHistoryFilePropertySource(SystemsViewHistoryFile historyFile) {
        FATPJob j;
        Objects.requireNonNull(historyFile, "Must specify a non-null historyFile.");
        this.historyFile = historyFile;
        if (historyFile.getPersistentProperties() != null && historyFile.getPersistentProperties().size() == 0 && (j = GetHistoryFilePropertiesHandler.getPropertiesFromHost(historyFile)) != null) {
            j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PDSystemsView.refreshPropertyPage();
                            }
                        });
                    }
                }
            });
            boolean alreadyLoading = false;
            Job[] jobArray = Job.getJobManager().find(FATPJob.class);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getName().equals(GetHistoryFilePropertiesHandler.NAME) && historyFile.equals(job.getProperty(qualifiedName))) {
                    logger.debug((Object)"Already loading.");
                    alreadyLoading = true;
                    break;
                }
                ++n2;
            }
            if (!alreadyLoading) {
                j.setProperty(qualifiedName, historyFile);
                j.schedule();
            }
        }
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Properties historyFileProperties = this.historyFile.getPersistentProperties();
        if (historyFileProperties == null) {
            return new IPropertyDescriptor[0];
        }
        Set<Object> keys = historyFileProperties.keySet();
        IPropertyDescriptor[] propDescs = new IPropertyDescriptor[keys.size() + 2];
        propDescs[0] = PROPERTY_NAME;
        propDescs[1] = PROPERTY_PATH;
        int i = 2;
        for (Object key : keys) {
            propDescs[i++] = new PropertyDescriptor(key, key.toString());
        }
        return propDescs;
    }

    public Object getPropertyValue(Object id) {
        Objects.requireNonNull(id, "Must provide a non-null id.");
        if (KEY_NAME.equals(id)) {
            return this.historyFile.getName();
        }
        if (KEY_PATH.equals(id)) {
            return this.historyFile.getHFLocalPath();
        }
        return this.historyFile.getPersistentProperty((String)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

