/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.systems.nodes;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewBrowseLocalView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewBrowseView;
import com.ibm.etools.fa.pdtclient.jhost.core.version.FAFeature;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.Node;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.system.SystemNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.model.SystemsViewBrowseHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseHistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseLocalViewNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseViewNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.views.systems.IHasLabelAndImage;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsHostUniqueNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;

public class SystemsViewFaultAnalyzerRootNode
extends SystemsHostUniqueNode
implements IHasLabelAndImage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFERENCE_ID = "ipv.FA";
    private static BooleanFieldEditor featurePreference = null;

    public SystemsViewFaultAnalyzerRootNode() {
        super((PDFeature)FAFeature.FA);
    }

    public SystemsViewFaultAnalyzerRootNode(IPDHost host, SystemsTreeNode parent) {
        super(host, parent);
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        try {
            if (this.getSystem().getHostType() == HostType.ZOS) {
                ArrayList<String> browseViewNames = new ArrayList<String>();
                for (Node<?> savedView : new SystemNode(this.getSystem().getHostName(), Integer.toString(this.getSystem().getPort())).getChildren()) {
                    if (!(savedView instanceof ViewNode) || browseViewNames.contains(((ViewNode)savedView).getDescription())) continue;
                    browseViewNames.add(((ViewNode)savedView).getDescription());
                }
                ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
                nodes.add(new SystemsViewBrowseHistoryFileNode(SystemsViewBrowseHistoryFile.create(this.getSystem()), (SystemsTreeNode)this));
                for (String browseViewName : browseViewNames) {
                    if (browseViewName.equalsIgnoreCase("local.views")) {
                        nodes.add(new SystemsViewBrowseLocalViewNode(SystemsViewBrowseLocalView.create((IPDHost)this.getSystem()), (SystemsTreeNode)this));
                        continue;
                    }
                    nodes.add(new SystemsViewBrowseViewNode(SystemsViewBrowseView.create((IPDHost)this.getSystem(), (String)browseViewName), (SystemsTreeNode)this));
                }
                return nodes;
            }
        }
        catch (Throwable t) {
            PDLogger.get(((Object)((Object)this)).getClass()).error(t);
        }
        return Collections.emptyList();
    }

    public Object getDataObject() {
        return this.getSystem();
    }

    public String getPDLabel() {
        return this.getSubsysName();
    }

    public String getSubsysName() {
        return Messages.FaRootNode_ZOS;
    }

    public String getPDImageName() {
        return "faultanalyzer";
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fa.pdtclient.ui";
    }

    public String getPreferenceId() {
        return PREFERENCE_ID;
    }

    public void setFeaturePreference(BooleanFieldEditor status) {
        featurePreference = status;
    }

    public BooleanFieldEditor getFeaturePreference() {
        return featurePreference;
    }
}

