/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.systems.model;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.Node;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.history.HistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.faov.tree.system.SystemNode;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.AddHistoryFile;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SystemsViewBrowseHistoryFile
extends PDPlatformObject
implements IHostProvider,
IEntityEventDispatcher<SystemsViewBrowseHistoryFile> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final EntityEventDispatcher<SystemsViewBrowseHistoryFile> eventDispatcher = new EntityEventDispatcher((Object)this);

    public static SystemsViewBrowseHistoryFile create(IPDHost system) {
        Objects.requireNonNull(system, "Please provide a non-null system.");
        return new SystemsViewBrowseHistoryFile(system);
    }

    protected SystemsViewBrowseHistoryFile(IPDHost system) {
        Objects.requireNonNull(system, "Please provide a non-null system.");
        this.setSystem(system);
    }

    public SystemsViewBrowseHistoryFile clone() {
        SystemsViewBrowseHistoryFile clone = SystemsViewBrowseHistoryFile.create(this.getSystem());
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SystemsViewBrowseHistoryFile) {
            SystemsViewBrowseHistoryFile otherQuery = (SystemsViewBrowseHistoryFile)((Object)obj);
            return otherQuery.getSystem().equals(this.getSystem());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode();
    }

    public void addListener(EListener<EntityEvent<SystemsViewBrowseHistoryFile>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<SystemsViewBrowseHistoryFile>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public Result<List<SystemsViewHistoryFile>> loadFiles() {
        ArrayList<SystemsViewHistoryFile> faHFList = new ArrayList<SystemsViewHistoryFile>();
        Result refreshResult = new Result();
        IPDHost pdHost = this.getSystem();
        for (Node<?> savedNode : new SystemNode(pdHost.getHostName(), Integer.toString(pdHost.getPort())).getChildren()) {
            if (!(savedNode instanceof HistoryFileNode)) continue;
            faHFList.add(new SystemsViewHistoryFile(pdHost, ((HistoryFileNode)savedNode).getDescription(), ((HistoryFileNode)savedNode).getPath()));
        }
        refreshResult.setOutput(faHFList);
        AddHistoryFile.loadDefaultHistoryFileIfNotLoadedYet(pdHost);
        return refreshResult;
    }

    public String toString() {
        return this.getPDLabel() + " " + String.valueOf(this.getSystem());
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fa.pdtclient.ui";
    }

    public String getPDImageName() {
        return "IMG_OBJ_FOLDER";
    }

    public String getPDLabel() {
        return Messages.FaBrowseHFNode;
    }
}

