/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.systems.model;

import com.ibm.etools.fa.pdtclient.core.model.SystemsViewBrowseLocalView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewBrowseView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewFault;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewLocalView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewView;
import com.ibm.etools.fa.pdtclient.ui.views.systems.model.SystemsViewBrowseHistoryFile;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.List;

public class FATreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ContentCache<SystemsViewHistoryFile, List<SystemsViewFault>> faHFContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<SystemsViewHistoryFile, List<SystemsViewFault>>(){

        public List<SystemsViewFault> loadEntityContent(SystemsViewHistoryFile aFolder, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
            Result result = aFolder.loadInfo();
            if (!result.isSuccessfulWithoutWarnings()) {
                String message = result.getMessagesCombined().toString();
                throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
            }
            return (List)result.getOutput();
        }

        public String getJobName(SystemsViewHistoryFile entity) {
            return MessageFormat.format(Messages._LOADING_X, entity.getName());
        }
    });
    private final ContentCache<SystemsViewLocalView, List<SystemsViewHistoryFile>> faLVWContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<SystemsViewLocalView, List<SystemsViewHistoryFile>>(){

        public List<SystemsViewHistoryFile> loadEntityContent(SystemsViewLocalView aFolder, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
            Result result = aFolder.loadInfo();
            if (!result.isSuccessfulWithoutWarnings()) {
                String message = result.getMessagesCombined().toString();
                throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
            }
            return (List)result.getOutput();
        }

        public String getJobName(SystemsViewLocalView entity) {
            return MessageFormat.format(Messages._LOADING_X, entity.getName());
        }
    });
    private final ContentCache<SystemsViewView, List<SystemsViewFault>> faVWContentCache;
    private final ContentCache<SystemsViewBrowseHistoryFile, List<SystemsViewHistoryFile>> faBrowseHFContentCache;
    private final ContentCache<SystemsViewBrowseLocalView, List<SystemsViewLocalView>> faBrowseLVWContentCache;
    private final ContentCache<SystemsViewBrowseView, List<SystemsViewView>> faBrowseVWContentCache;

    public FATreeContent() {
        this.faLVWContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<SystemsViewLocalView, List<SystemsViewHistoryFile>>(){

            public void postEntityContentLoad(SystemsViewLocalView entity, IContentLoadStatus<List<SystemsViewHistoryFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (SystemsViewHistoryFile faHF : (List)status.getContentOnly()) {
                        FATreeContent.this.faHFContentCache.acquireContentLock((Object)faHF);
                    }
                }
            }

            public void preEntityContentUnload(SystemsViewLocalView entity, IContentLoadStatus<List<SystemsViewHistoryFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (SystemsViewHistoryFile faHF : (List)status.getContentOnly()) {
                        FATreeContent.this.faHFContentCache.releaseContentLock((Object)faHF);
                    }
                }
            }
        });
        this.faVWContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<SystemsViewView, List<SystemsViewFault>>(){

            public List<SystemsViewFault> loadEntityContent(SystemsViewView aFolder, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = aFolder.loadInfo();
                if (!result.isSuccessfulWithoutWarnings()) {
                    String message = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
                }
                return (List)result.getOutput();
            }

            public String getJobName(SystemsViewView entity) {
                return MessageFormat.format(Messages._LOADING_X, entity.getName());
            }
        });
        this.faVWContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<SystemsViewView, List<SystemsViewFault>>(){

            public void postEntityContentLoad(SystemsViewView entity, IContentLoadStatus<List<SystemsViewFault>> status) {
                PDLogger.get(this.getClass()).trace((Object)("Acquired lock for " + String.valueOf(entity)));
                FATreeContent.this.faVWContentCache.acquireContentLock((Object)entity);
            }

            public void preEntityContentUnload(SystemsViewView entity, IContentLoadStatus<List<SystemsViewFault>> status) {
                FATreeContent.this.faVWContentCache.releaseContentLock((Object)entity);
            }
        });
        this.faBrowseHFContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<SystemsViewBrowseHistoryFile, List<SystemsViewHistoryFile>>(){

            public List<SystemsViewHistoryFile> loadEntityContent(SystemsViewBrowseHistoryFile faBrowseHF, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result<List<SystemsViewHistoryFile>> result = faBrowseHF.loadFiles();
                if (!result.isSuccessfulWithoutWarnings()) {
                    String message = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
                }
                return (List)result.getOutput();
            }

            public String getJobName(SystemsViewBrowseHistoryFile entity) {
                return MessageFormat.format(Messages._LOADING_X, entity.getSystem());
            }
        });
        this.faBrowseHFContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<SystemsViewBrowseHistoryFile, List<SystemsViewHistoryFile>>(){

            public void postEntityContentLoad(SystemsViewBrowseHistoryFile entity, IContentLoadStatus<List<SystemsViewHistoryFile>> status) {
                List contentOnly;
                if (status.getError() == null && (contentOnly = (List)status.getContentOnly()) != null) {
                    for (SystemsViewHistoryFile faHF : contentOnly) {
                        FATreeContent.this.faHFContentCache.acquireContentLock((Object)faHF);
                    }
                }
            }

            public void preEntityContentUnload(SystemsViewBrowseHistoryFile entity, IContentLoadStatus<List<SystemsViewHistoryFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (SystemsViewHistoryFile faHF : (List)status.getContentOnly()) {
                        FATreeContent.this.faHFContentCache.releaseContentLock((Object)faHF);
                    }
                }
            }
        });
        this.faBrowseLVWContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<SystemsViewBrowseLocalView, List<SystemsViewLocalView>>(){

            public List<SystemsViewLocalView> loadEntityContent(SystemsViewBrowseLocalView faBrowseLVW, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = faBrowseLVW.loadFiles();
                if (!result.isSuccessfulWithoutWarnings()) {
                    String message = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
                }
                return (List)result.getOutput();
            }

            public String getJobName(SystemsViewBrowseLocalView entity) {
                return MessageFormat.format(Messages._LOADING_X, entity.getSystem());
            }
        });
        this.faBrowseLVWContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<SystemsViewBrowseLocalView, List<SystemsViewLocalView>>(){

            public void postEntityContentLoad(SystemsViewBrowseLocalView entity, IContentLoadStatus<List<SystemsViewLocalView>> status) {
                if (status.getError() == null) {
                    for (SystemsViewLocalView faLVW : (List)status.getContentOnly()) {
                        FATreeContent.this.faLVWContentCache.acquireContentLock((Object)faLVW);
                    }
                }
            }

            public void preEntityContentUnload(SystemsViewBrowseLocalView entity, IContentLoadStatus<List<SystemsViewLocalView>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (SystemsViewLocalView faLVW : (List)status.getContentOnly()) {
                        FATreeContent.this.faLVWContentCache.releaseContentLock((Object)faLVW);
                    }
                }
            }
        });
        this.faBrowseVWContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<SystemsViewBrowseView, List<SystemsViewView>>(){

            public List<SystemsViewView> loadEntityContent(SystemsViewBrowseView faBrowseVW, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = faBrowseVW.loadFiles();
                if (!result.isSuccessfulWithoutWarnings()) {
                    String message = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
                }
                return (List)result.getOutput();
            }

            public String getJobName(SystemsViewBrowseView entity) {
                return MessageFormat.format(Messages._LOADING_X, entity.getSystem());
            }
        });
        this.faBrowseVWContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<SystemsViewBrowseView, List<SystemsViewView>>(){

            public void postEntityContentLoad(SystemsViewBrowseView entity, IContentLoadStatus<List<SystemsViewView>> status) {
                if (status.getError() == null) {
                    for (SystemsViewView faVW : (List)status.getContentOnly()) {
                        FATreeContent.this.faVWContentCache.acquireContentLock((Object)faVW);
                    }
                }
            }

            public void preEntityContentUnload(SystemsViewBrowseView entity, IContentLoadStatus<List<SystemsViewView>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (SystemsViewView faVW : (List)status.getContentOnly()) {
                        FATreeContent.this.faVWContentCache.releaseContentLock((Object)faVW);
                    }
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    FATreeContent.this.faBrowseHFContentCache.acquireContentLock((Object)SystemsViewBrowseHistoryFile.create(host));
                    FATreeContent.this.faBrowseLVWContentCache.acquireContentLock((Object)SystemsViewBrowseLocalView.create((IPDHost)host));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    FATreeContent.this.faBrowseHFContentCache.releaseContentLock((Object)SystemsViewBrowseHistoryFile.create(host));
                    FATreeContent.this.faBrowseLVWContentCache.releaseContentLock((Object)SystemsViewBrowseLocalView.create((IPDHost)host));
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.faBrowseHFContentCache.acquireContentLock((Object)SystemsViewBrowseHistoryFile.create(host));
            this.faBrowseLVWContentCache.acquireContentLock((Object)SystemsViewBrowseLocalView.create((IPDHost)host));
        }
    }

    public ContentCache<SystemsViewHistoryFile, List<SystemsViewFault>> getFaHFContentCache() {
        return this.faHFContentCache;
    }

    public ContentCache<SystemsViewLocalView, List<SystemsViewHistoryFile>> getFaLVWContentCache() {
        return this.faLVWContentCache;
    }

    public ContentCache<SystemsViewView, List<SystemsViewFault>> getFaVWContentCache() {
        return this.faVWContentCache;
    }

    public ContentCache<SystemsViewBrowseHistoryFile, List<SystemsViewHistoryFile>> getFaBrowseHFContentCache() {
        return this.faBrowseHFContentCache;
    }

    public ContentCache<SystemsViewBrowseLocalView, List<SystemsViewLocalView>> getFaBrowseLVWContentCache() {
        return this.faBrowseLVWContentCache;
    }

    public ContentCache<SystemsViewBrowseView, List<SystemsViewView>> getFaBrowseVWContentCache() {
        return this.faBrowseVWContentCache;
    }
}

