/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.systems;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewFault;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewHistoryFile;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewLocalView;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewView;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.OpenHistoryFile;
import com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditorInput;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewFaultNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewHistoryFileNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewLocalViewNode;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewViewNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsView;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDEventNode;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorInput;

public class FASystemsView
implements ISystemsView {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FASystemsView.class);

    public void doubleClick(ISystemsView pdSystemsView, Object eventObject, boolean defaultCommandProcessed) {
        if (eventObject instanceof PDEventNode) {
            return;
        }
        EventObject event = (EventObject)eventObject;
        ITreeSelection selection = (ITreeSelection)((DoubleClickEvent)event).getSelection();
        Object target = selection.getFirstElement();
        try {
            if (target instanceof SystemsViewHistoryFileNode) {
                SystemsViewHistoryFile a = (SystemsViewHistoryFile)((SystemsViewHistoryFileNode)((Object)target)).getDataObject();
                OpenHistoryFile.openHistoryFile(a.getSystem(), a.getSystem().getHostName(), Integer.toString(a.getSystem().getPort()), a.getName(), null, null, false);
            } else if (target instanceof SystemsViewViewNode) {
                SystemsViewView a = (SystemsViewView)((SystemsViewViewNode)((Object)target)).getDataObject();
                OpenHistoryFile.openHistoryFile(a.getSystem(), a.getSystem().getHostName(), Integer.toString(a.getSystem().getPort()), a.getVwName(), a.getVwMemberName(), null, true);
            } else if (target instanceof SystemsViewLocalViewNode) {
                SystemsViewLocalView a = (SystemsViewLocalView)((SystemsViewLocalViewNode)((Object)target)).getDataObject();
                OpenHistoryFile.openHistoryFile(a.getSystem(), a.getSystem().getHostName(), Integer.toString(a.getSystem().getPort()), "local.views", a.getName(), null, true);
            } else if (target instanceof SystemsViewFaultNode) {
                String reportName = ((SystemsViewFault)((SystemsViewFaultNode)((Object)target)).getDataObject()).getName();
                reportName = "/".concat(reportName).concat("/").concat(reportName).concat(".faml");
                reportName = ((SystemsViewHistoryFile)((SystemsViewFaultNode)((Object)target)).getParent().getDataObject()).getHFLocalPath().concat(reportName);
                IFile reportPath = FACorePlugin.getRoot().getFile(FACorePlugin.getRoot().getProjectRelativePath().append(reportName));
                if (!reportPath.exists()) {
                    PDDialogs.openErrorThreadSafe((String)Messages.FaSystemsView_CachedFileNotFound, (String)reportPath.getName());
                } else {
                    PDPlatformUIUtils.editor.openEditor((IEditorInput)new FaultAnalyzerReportEditorInput(reportPath, ((SystemsViewFault)((SystemsViewFaultNode)((Object)target)).getDataObject()).getSystem()), (String)"com.ibm.etools.fa.pdtclient.ui.report.FaultAnalyzerReportEditor");
                }
            }
        }
        catch (InterruptedException e) {
            logger.trace((Object)"Interrupted.");
        }
    }
}

