/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.FAVersionHolder;
import com.ibm.etools.fa.pdtclient.ui.faobjects.FaultAnalyzerParameters;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.impl.historyfile.RefreshHistoryFile;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public abstract class MoveFaultEntry {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static void moveFaultEntry(String hostId, String address, String service, String datasetDest, String includeDataSets, Map<String, String> memberOriginList, boolean showResultsDialog) {
        Objects.requireNonNull(address, "Must specify a non-null address.");
        Objects.requireNonNull(service, "Must specify a non-null service.");
        Objects.requireNonNull(datasetDest, "Must specify a non-null datasetDest.");
        Objects.requireNonNull(memberOriginList, "Must specify a non-null member_origin_list.");
        final StringBuffer messages = new StringBuffer();
        final ArrayList<Job> jobs = new ArrayList<Job>();
        String user = null;
        try {
            user = FaultAnalyzerParameters.getUserFromHost(address, service, PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()));
        }
        catch (InterruptedException e1) {
            PDLogger.get(MoveFaultEntry.class).error((Throwable)e1);
            return;
        }
        for (Map.Entry<String, String> entry : memberOriginList.entrySet()) {
            MoveFaultEntry.moveFaultEntriesFromSingleDataset(hostId, address, service, datasetDest, includeDataSets, user, messages, jobs, entry.getKey(), entry.getValue());
        }
        if (showResultsDialog) {
            Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent e) {
                    if (!messages.toString().isEmpty()) {
                        if (jobs.isEmpty()) {
                            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                        } else {
                            for (Job job : jobs) {
                                if (job.getResult() != null) continue;
                                return;
                            }
                            jobs.clear();
                            PDDialogs.openInfoThreadSafe((String)Messages.MoveFaultEntryHandler_MoveFaultEntryResult, (String)messages.toString());
                            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                        }
                    }
                }
            });
        }
    }

    private static void moveFaultEntriesFromSingleDataset(String hostId, String address, String service, String datasetDest, String includeDataSets, String user, final StringBuffer messages, ArrayList<Job> jobs, String srcDataset, String srcMembers) {
        String[] member_list = srcMembers.split(",");
        Object members = "";
        ArrayList<FATP> requests = new ArrayList<FATP>();
        int i = 0;
        while (i < member_list.length) {
            members = (String)members + member_list[i] + ",";
            if (i % 100 == 99 || i + 1 == member_list.length) {
                URI _dst;
                URI _src = FARL.getFARLURI((String)Ipv6Utils.decodeAndWrap((String)address), (String)service, (String)srcDataset, (String)((String)members).substring(0, ((String)members).length() - 1));
                FATP fatp = FARL.move_fault_entry((URI)_src, (URI)(_dst = FARL.getFARLURI((String)Ipv6Utils.decodeAndWrap((String)address), (String)service, (String)datasetDest)), (String)includeDataSets, (FAVersionHolder.getInstance().getVersion(hostId) >= 150102 ? 1 : 0) != 0);
                if (fatp == null) {
                    PDLogger.get(MoveFaultEntry.class).error((Object)("Check source or destination dataset names? source:" + String.valueOf(_src) + " destination:" + String.valueOf(_dst)));
                } else {
                    requests.add(fatp);
                }
                members = "";
            }
            ++i;
        }
        FATPJob job = new FATPJob(Messages.MoveFaultEntryHandler_MoveFaultEntry, requests.toArray(new FATP[requests.size()]), null){

            @Override
            protected void finalize_responses(IProgressMonitor _monitor) {
                for (FATP[] request_response : this.responses) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try {
                        FATP request = request_response[0];
                        try {
                            block19: {
                                try (FATP response = request_response[1];){
                                    String status_code;
                                    if (!response.is_successful_response() || !(status_code = response.get_status_code()).equals("200")) break block19;
                                    PDLogger.get(MoveFaultEntry.class).debug((Object)request.toString());
                                    Charset charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader(response.get_entity_header("Content-Type"));
                                    try {
                                        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(response.get_body(charset)));
                                        IMemento[] iMementoArray = memento.getChildren("tr");
                                        int n = iMementoArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IMemento tr = iMementoArray[n2];
                                            messages.append(this.getResultMessageWithDataset(request, tr.getChildren("td")[3].getTextData().trim()) + "\n");
                                            ++n2;
                                        }
                                    }
                                    catch (WorkbenchException e) {
                                        PDLogger.get(MoveFaultEntry.class).warn((Throwable)e);
                                    }
                                }
                            }
                            if (request == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (request != null) {
                                request.close();
                            }
                            throw throwable;
                        }
                        request.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                RefreshHistoryFile.refresh(true);
            }

            private String getResultMessageWithDataset(FATP request, String raw) {
                String[] parts;
                String get_request_uri = request.get_request_uri();
                if (get_request_uri != null && !get_request_uri.trim().isEmpty() && get_request_uri.trim().length() > 1 && (parts = get_request_uri.replace("/", "").split("\\(")).length > 0) {
                    String copiedTo = "moved to";
                    return parts[0].trim() + "(" + raw.trim().replace(copiedTo, ") " + copiedTo);
                }
                return raw;
            }
        };
        jobs.add(job);
        job.set_user(user);
        job.schedule();
    }
}

