/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl;

import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.report.RefreshReportHandler;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl.CachedFaultEntry;
import com.ibm.etools.fa.pdtclient.ui.views.systems.nodes.SystemsViewBrowseHistoryFileNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class ClearCachedReport {
    public static boolean clearCachedReport(String address, String service, String dataset, String member) {
        IFolder report_path = FAResourceUtils.getFaultEntryFolder((String)address, (String)service, (String)dataset, (String)member);
        IFile savedFilePath = FAResourceUtils.getSavedReportFile((String)address, (String)service, (String)dataset, (String)member);
        if (report_path.exists() && !savedFilePath.exists()) {
            if (PDDialogs.openConfirmThreadSafe((String)Messages.ClearCachedReportHandler_ClearingCachedReport, (String)MessageFormat.format(Messages.ClearCachedReport_WarningBookmarksWillBeDeleted, member))) {
                ClearCachedReport.clearCachedReport(report_path);
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean clearCachedReport(List<CachedFaultEntry> cached) {
        StringBuilder selectedEntries = new StringBuilder(System.lineSeparator());
        int count = 0;
        for (CachedFaultEntry e : cached) {
            selectedEntries.append(e.getFaultEntry()).append(" ");
            if (++count != 10) continue;
            selectedEntries.append(System.lineSeparator());
            count = 0;
        }
        if (PDDialogs.openConfirmThreadSafe((String)Messages.ClearCachedReportHandler_ClearingCachedReport, (String)MessageFormat.format(Messages.ClearCachedReport_WarningBookmarksWillBeDeleted, selectedEntries.toString()))) {
            for (CachedFaultEntry entry : cached) {
                IFolder report_path = FAResourceUtils.getFaultEntryFolder((String)entry.getAddress(), (String)entry.getPort(), (String)entry.getHistFile(), (String)entry.getFaultEntry());
                ClearCachedReport.clearCachedReport(report_path);
            }
            return true;
        }
        return false;
    }

    private static void clearCachedReport(final IFolder report_path) {
        PDLogger.get(ClearCachedReport.class).trace((Object)MessageFormat.format("Attempting to Clear cached report {0} ", report_path));
        RefreshReportHandler.cancelRefreshJobs();
        PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

            public boolean test(IEditorInput input) {
                return input instanceof IFileEditorInput && ((IFileEditorInput)input).getFile().getParent().getProjectRelativePath().equals((Object)report_path.getProjectRelativePath());
            }
        });
        if (report_path.exists()) {
            IResourceUtils.deleteIFolder((IFolder)report_path, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        Activator.updateAll(SystemsViewBrowseHistoryFileNode.class);
    }

    public static void clearSavedReport(final IFile filePath) {
        PDLogger.get(ClearCachedReport.class).trace((Object)MessageFormat.format("Attempting to Clear cached report {0} ", filePath));
        RefreshReportHandler.cancelRefreshJobs();
        PDPlatformUIUtils.editor.closeAllEditorsWithInput((PDPlatformUIUtils.editor.EditorInputTester)new PDPlatformUIUtils.editor.EditorInputTester(){

            public boolean test(IEditorInput input) {
                return input instanceof IFileEditorInput && ((IFileEditorInput)input).getFile().getParent().getProjectRelativePath().equals((Object)filePath.getProjectRelativePath());
            }
        });
        if (filePath.exists()) {
            IResourceUtils.deleteIFile((IFile)filePath, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        Activator.updateAll(SystemsViewBrowseHistoryFileNode.class);
    }
}

