/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist.handler;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.PromptUserWithDialog;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.api.dialog.loader.FATPQueries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.handler.historyfile.NewHistoryFileHandler;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListDisplayedResource;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.impl.MoveFaultEntry;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class MoveFaultEntryHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        List<Map<String, String>> selectedFaultEntries;
        ReportsList reportsList;
        ReportsListDisplayedResource res;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof ReportsList && (res = (reportsList = (ReportsList)activePart).getDisplayedResource()).isAResourceBeingDisplayed() && !(selectedFaultEntries = reportsList.getSelectedFaultEntries()).isEmpty()) {
            final HashMap<String, String> member_origin_list = new HashMap<String, String>();
            for (Map<String, String> fe : selectedFaultEntries) {
                String origin = FACorePlugin.getRoot().getFile(fe.get(ViewParser.class.getCanonicalName()).toString()).getProjectRelativePath().segment(2);
                if (!member_origin_list.containsKey(origin)) {
                    member_origin_list.put(origin, "");
                }
                member_origin_list.put(origin, ((String)member_origin_list.get(origin)).concat(fe.get("FAULT_ID")).concat(","));
            }
            final IPDHost host = res.getHost() != null ? res.getHost() : PDTreeHandlerUtil.getHost((String)res.getResourceAddress(), (int)Integer.parseInt(res.getResourceService()));
            final PromptUserWithDialog.DSNAndInclude choices = PromptUserWithDialog.askForDataSetAndIncludeTightlyCoupled(host, Messages.MoveFaultEntryHandler_MoveFaultEntry, Messages.MoveFaultEntryHandler_0, Messages.FaultAnalyzerParameters_Dataset_destination_name, "com.ibm.etools.fa.pdtclient.ui.faobjects.history.MoveFaultEntryHandler.dest.dataset", member_origin_list.size() > 0 ? (String)member_origin_list.entrySet().iterator().next().getKey() : "");
            if (choices != null) {
                Job job = new Job(Messages.MoveFaultEntryHandler_CheckingIfHistoryFileExists){

                    protected IStatus run(IProgressMonitor monitor) {
                        Result<FATPQueries.EXISTS_STATUS> checkExistsResult = FATPQueries.checkExists(res.getResourceAddress(), res.getResourceService(), monitor, choices.getDataSetName());
                        FATPQueries.EXISTS_STATUS output = (FATPQueries.EXISTS_STATUS)((Object)checkExistsResult.getOutput());
                        if (FATPQueries.EXISTS_STATUS.NOT_EXISTS.equals((Object)output)) {
                            NewHistoryFileHandler.promptForHistoryFileParameters(null, host, choices.getDataSetName(), new JobChangeAdapter(){

                                public void done(IJobChangeEvent changeEvent) {
                                    if (changeEvent.getResult().isOK()) {
                                        MoveFaultEntry.moveFaultEntry(host.getHostID(), res.getResourceAddress(), res.getResourceService(), choices.getDataSetName(), choices.getIncludeDataSets(), member_origin_list, true);
                                    }
                                }
                            });
                        } else {
                            MoveFaultEntry.moveFaultEntry(host.getHostID(), res.getResourceAddress(), res.getResourceService(), choices.getDataSetName(), choices.getIncludeDataSets(), member_origin_list, true);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }
}

