/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.ui.util.EclipseUtils;
import com.ibm.etools.fa.pdtclient.ui.util.FilterParser;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.SortTypes;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ReportsListViewerFilter
extends ViewerFilter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Map<String, String> filters = new HashMap<String, String>();

    public ReportsListViewerFilter(Map<String, String> filters) {
        this.filters = filters;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        HashMap faultProperties = parentElement instanceof HashMap ? (HashMap)parentElement : (HashMap)element;
        if (this.filters.isEmpty()) {
            return true;
        }
        int matchCount = 0;
        block0: for (Map.Entry<String, String> entry : this.filters.entrySet()) {
            String propertyValue = (String)faultProperties.get(entry.getKey());
            String filterValue = entry.getValue();
            String[] stringArray = EclipseUtils.splitFilter(filterValue);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (ReportsListViewerFilter.filterMatches(entry.getKey(), propertyValue, filter)) {
                    ++matchCount;
                    continue block0;
                }
                ++n2;
            }
        }
        return matchCount == this.filters.size();
    }

    private static boolean filterMatches(String columnName, String propertyValue, String filter) {
        SortTypes type = ReportsList.getColumnType(columnName);
        switch (type) {
            case DATE: {
                return FilterParser.parseAndEvalDateField(columnName, propertyValue, filter);
            }
            case HEXADECIMAL: {
                return FilterParser.parseAndEvalHex(columnName, propertyValue, filter);
            }
            case INTEGER: {
                return FilterParser.parseAndEvalInteger(columnName, propertyValue, filter);
            }
        }
        return propertyValue.matches("(?i)" + filter);
    }
}

