/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.SortTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ReportsListViewerComparator
extends ViewerComparator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String SEPARATOR = " ";
    private static final String DUP_TIME = "DUP_TIME";
    private static final String DUP_DATE = "DUP_DATE";
    private static final String TIME = "TIME";
    private static final String DATE = "DATE";
    private static final SortTypes[] column_types = new SortTypes[]{SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.INTEGER, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.DATE, SortTypes.DATE, SortTypes.DATE, SortTypes.INTEGER, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.BOOLEAN, SortTypes.STRING, SortTypes.BOOLEAN, SortTypes.STRING, SortTypes.STRING, SortTypes.HEXADECIMAL, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.STRING, SortTypes.DATE, SortTypes.STRING, SortTypes.STRING};
    private final ReportsList reportsList;

    public ReportsListViewerComparator(ReportsList reportsList) {
        this.reportsList = reportsList;
    }

    public int compare(Viewer viewer, Object first, Object second) {
        boolean secondObjectInvalid;
        boolean firstObjectInvalid = first == null || !(first instanceof HashMap);
        boolean bl = secondObjectInvalid = second == null || !(second instanceof HashMap);
        if (firstObjectInvalid && secondObjectInvalid) {
            return 0;
        }
        if (firstObjectInvalid) {
            return -1;
        }
        if (secondObjectInvalid) {
            return 1;
        }
        HashMap fCols = (HashMap)first;
        HashMap sCols = (HashMap)second;
        String firstValue = (String)fCols.get(this.reportsList.getSortColumn());
        String secondValue = (String)sCols.get(this.reportsList.getSortColumn());
        SortTypes sort_type = column_types[new ArrayList<String>(Arrays.asList(ColumnNames.column_names)).indexOf(this.reportsList.getSortColumn())];
        if (sort_type == SortTypes.DATE) {
            String secondTime;
            boolean isDateTime = this.reportsList.getSortColumn().equals(DATE) || this.reportsList.getSortColumn().equals(TIME);
            String firstDate = isDateTime ? (String)fCols.get(DATE) : (String)fCols.get(DUP_DATE);
            String firstTime = isDateTime ? (String)fCols.get(TIME) : (String)fCols.get(DUP_TIME);
            String secondDate = isDateTime ? (String)sCols.get(DATE) : (String)sCols.get(DUP_DATE);
            String string = secondTime = isDateTime ? (String)sCols.get(TIME) : (String)sCols.get(DUP_TIME);
            if (this.reportsList.getSortColumn().equals(DATE) || this.reportsList.getSortColumn().equals(DUP_DATE)) {
                firstValue = firstDate.concat(SEPARATOR + firstTime);
                secondValue = secondDate.concat(SEPARATOR + secondTime);
            } else if (this.reportsList.getSortColumn().equals(TIME) || this.reportsList.getSortColumn().equals(DUP_TIME)) {
                firstValue = firstTime.concat(SEPARATOR + firstDate);
                secondValue = secondTime.concat(SEPARATOR + secondDate);
            }
        }
        boolean firstValueEmpty = firstValue == null || firstValue.isEmpty();
        boolean secondValueEmpty = secondValue == null || secondValue.isEmpty();
        int difference = 0;
        if (firstValueEmpty && secondValueEmpty) {
            difference = 0;
        } else if (firstValueEmpty) {
            difference = -1;
        } else if (secondValueEmpty) {
            difference = 1;
        } else {
            switch (sort_type) {
                case DATE: {
                    difference = firstValue.compareTo(secondValue);
                    break;
                }
                case INTEGER: {
                    try {
                        difference = Integer.valueOf(firstValue).compareTo(Integer.valueOf(secondValue));
                    }
                    catch (NumberFormatException e) {
                        difference = firstValue.compareTo(secondValue);
                    }
                    break;
                }
                case HEXADECIMAL: {
                    try {
                        difference = Integer.valueOf(Integer.parseInt(firstValue, 16)).compareTo(Integer.parseInt(secondValue, 16));
                    }
                    catch (NumberFormatException e) {
                        difference = firstValue.compareTo(secondValue);
                    }
                    break;
                }
                default: {
                    difference = firstValue.compareTo(secondValue);
                }
            }
        }
        if (!this.reportsList.isSortAscending()) {
            difference = -difference;
        }
        return difference;
    }
}

