/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.FaultEntries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.Configurations;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ReportsListTreeContentProvider
implements ITreeContentProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ReportsList reportsList;
    private FaultEntries entries = new FaultEntries();

    public ReportsListTreeContentProvider(ReportsList reportsList) {
        this.reportsList = reportsList;
    }

    public void dispose() {
        this.reportsList.saveColumnsEnabledInReportsList();
    }

    public String[] getChildren(Object parentElement) {
        if (parentElement instanceof Map) {
            Map map = (Map)parentElement;
            String path = (String)map.get(ViewParser.class.getCanonicalName());
            IFolder folder = FACorePlugin.getRoot().getFolder(FACorePlugin.getRoot().getFile(path).getProjectRelativePath().removeLastSegments(1).append((String)map.get("FAULT_ID")));
            if (folder.exists()) {
                ArrayList<String> children = new ArrayList<String>();
                for (IResource childMembers : IResourceUtils.ls((IFolder)folder, (IProgressMonitor)new NullProgressMonitor(), (boolean)false)) {
                    if (childMembers.getType() == 2) continue;
                    IPath member_path = childMembers.getProjectRelativePath();
                    if (FAResourceUtils.isFileExtension((IPath)member_path, (String)"faml")) {
                        children.add(member_path.toString());
                        continue;
                    }
                    if (FAResourceUtils.isFileExtension((IPath)member_path, (String)"mdml") && !member_path.removeFileExtension().lastSegment().contains(".")) {
                        children.add(member_path.toString());
                        continue;
                    }
                    if (member_path.lastSegment().startsWith(".") || "tmp".equals(member_path.getFileExtension()) || "lxml".equals(member_path.getFileExtension()) || "dump".equals(member_path.getFileExtension()) || member_path.toString().endsWith("async.info.xml")) continue;
                    children.add(member_path.toString());
                }
                return children.toArray(new String[0]);
            }
        }
        return new String[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.entries.getList();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Map) {
            Map map = (Map)element;
            String path = (String)map.get(ViewParser.class.getCanonicalName());
            File path_file = FACorePlugin.getRoot().getLocation().append(path).removeLastSegments(1).append((String)map.get("FAULT_ID")).toFile();
            if (path_file.exists()) {
                return path_file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File arg0, String arg1) {
                        return arg1.endsWith(".mdml") || arg1.endsWith(".faml") || arg1.endsWith(".log") || arg1.endsWith(".jcl") || arg1.endsWith(".txt");
                    }
                }).length > 0;
            }
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof String) {
            String inputString = (String)newInput;
            if (inputString.isEmpty()) {
                this.entries = new FaultEntries();
            } else {
                IFile history_file = FACorePlugin.getRoot().getFile(inputString);
                if (history_file.exists()) {
                    Configurations.ignore_colname = history_file.getProjectRelativePath().lastSegment().endsWith(").hfml");
                    ArrayList<String> oldColumns = new ArrayList<String>(this.reportsList.getEnabledColumns());
                    HashMap<String, String> oldFilters = new HashMap<String, String>(this.reportsList.get_filters());
                    this.entries = ViewParser.parse(inputString, (IProgressMonitor)new NullProgressMonitor());
                    if (newInput.equals(oldInput)) {
                        this.reportsList.set_columns(oldColumns);
                        this.reportsList.setFilters(oldFilters, this.reportsList.getLocalFilterFlag());
                    } else {
                        this.reportsList.resetFilters(false);
                        this.reportsList.set_columns(this.entries.getColumns());
                        this.reportsList.setFilters(this.entries.getFilters());
                    }
                    Activator.cache("com.ibm.etools.fa.pdtclient.ui.reports.dataset", String.valueOf(newInput));
                }
            }
        }
    }
}

