/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.report.OpenAddressHandler;
import com.ibm.etools.fa.pdtclient.ui.report.OpenReportHandler;
import com.ibm.etools.fa.pdtclient.ui.report.impl.ViewIditrace;
import com.ibm.etools.fa.pdtclient.ui.report.impl.ViewJobJCL;
import com.ibm.etools.fa.pdtclient.ui.report.impl.ViewSavedReport;
import com.ibm.etools.fa.pdtclient.ui.report.impl.ViewZZDEBUG;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListDisplayedResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDUserTask;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;

public class ReportsListOpenListener
implements IOpenListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ReportsListDisplayedResource displayedResource;

    public ReportsListOpenListener() {
    }

    public ReportsListOpenListener(ReportsListDisplayedResource displayedResource) {
        this.displayedResource = displayedResource;
    }

    public void open(final OpenEvent event) {
        PDUserTask.createAndRunJob((String)Messages.ReportsListOpenListener_OpeningReport, (PDUserTask.PDUserJobFunction)new PDUserTask.PDUserJobFunction(){

            public void run(IProgressMonitor monitor) {
                block36: {
                    Object element;
                    IPDHost host;
                    block35: {
                        host = ReportsListOpenListener.this.displayedResource == null ? null : ReportsListOpenListener.this.displayedResource.getHost();
                        element = ((StructuredSelection)event.getSelection()).getFirstElement();
                        if (!(element instanceof Map)) break block35;
                        PDLogger.get(this.getClass()).trace(element);
                        IPath history_file = FACorePlugin.getRoot().getFile((String)((Map)element).get(ViewParser.class.getCanonicalName())).getProjectRelativePath();
                        OpenReportHandler.openReport(host, history_file.segment(0), history_file.segment(1), history_file.segment(2), (String)((Map)element).get("FAULT_ID"));
                        break block36;
                    }
                    if (!(element instanceof String)) break block36;
                    IFile resource = FACorePlugin.getRoot().getFile((String)element);
                    IPath history_file = resource.getProjectRelativePath().removeLastSegments(1);
                    String section = null;
                    String extension = "";
                    if (resource.getType() == 1 && resource.getFileExtension() != null) {
                        extension = resource.getFileExtension();
                    }
                    switch (extension) {
                        case "faml": {
                            section = String.valueOf(element) + "#0";
                            break;
                        }
                        case "mdml": {
                            OpenAddressHandler.open(history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3), "0");
                            return;
                        }
                        case "log": {
                            if (resource.getName().startsWith("IDITRACE")) {
                                ViewIditrace.openIditrace(history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3));
                                return;
                            }
                            if (!resource.getName().startsWith("ZZDEBUG")) break;
                            ViewZZDEBUG.openZZDEBUG(history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3));
                            return;
                        }
                        case "jcl": {
                            ViewJobJCL.openLocalJCLFile(history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3));
                            return;
                        }
                        case "c": 
                        case "asm": 
                        case "cob": 
                        case "pli": 
                        case "txt": 
                        case "cobol": {
                            ViewSavedReport.openSavedReport(history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3));
                        }
                        case "java": {
                            this.openSource(history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3), resource.getProjectRelativePath().lastSegment());
                            return;
                        }
                    }
                    OpenReportHandler.openReport(host, history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3));
                    if (section != null) {
                        OpenReportHandler.openSectionOrAddress(host, element, history_file.segment(0), history_file.segment(1), history_file.segment(2), history_file.segment(3));
                    }
                }
            }

            private void openSource(String host, String port, String histFile, String faultEntry, String javaSrcFile) {
                IFile file = FAResourceUtils.getFaultEntryFolder((String)host, (String)port, (String)histFile, (String)faultEntry).getFile(javaSrcFile);
                if (file.exists()) {
                    String editor_id = ReportsListOpenListener.getEditorIdForFile(file);
                    PDPlatformUIUtils.editor.openEditorOnActivePageAsync((IFile)file, (String)editor_id, (boolean)true);
                }
            }
        });
    }

    public static String getEditorIdForFile(IFile file) {
        IFileEditorMapping[] editors;
        String editor_id = "org.eclipse.ui.DefaultTextEditor";
        String name = file.getFileExtension().toLowerCase();
        IFileEditorMapping[] iFileEditorMappingArray = editors = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IFileEditorMapping editor2 = iFileEditorMappingArray[n2];
            if (editor2.getExtension().equalsIgnoreCase(name)) {
                editor_id = editor2.getDefaultEditor().getId();
                break;
            }
            ++n2;
        }
        return editor_id;
    }
}

