/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;

public class ReportsListDisplayedResource {
    private static final PDLogger logger = PDLogger.get(ReportsListDisplayedResource.class);
    private String address;
    private String service;
    private String dataset;
    private String member;
    private IPDHost host;

    @Deprecated
    public void setDisplayedResourceProperties(String resourcePath) {
        this.setDisplayedResourceProperties(null, resourcePath);
    }

    public void setDisplayedResourceProperties(IPDHost host, String resourcePath) {
        Pattern resourcePattern = Pattern.compile("^(?<address>.+?)/(?<service>\\d+)/(?<dataset>.+?)(?:\\((?<member>.+?)\\))?$");
        Matcher resourceMatcher = resourcePattern.matcher(resourcePath);
        if (resourceMatcher.matches() && resourceMatcher.groupCount() >= 3) {
            this.address = resourceMatcher.group("address");
            this.service = resourceMatcher.group("service");
            this.dataset = resourceMatcher.group("dataset");
            this.member = resourceMatcher.group("member");
            this.host = host;
        } else {
            this.address = null;
            this.service = null;
            this.dataset = null;
            this.member = null;
            host = null;
            if (resourcePath != null && !"".equals(resourcePath)) {
                logger.warn((Object)MessageFormat.format("ERROR: did not match resource correctly. resourcePath=''{0}''", resourcePath));
            }
        }
    }

    public boolean isAResourceBeingDisplayed() {
        return this.address != null && this.service != null && this.dataset != null;
    }

    public String getResourceAddress() {
        return this.address;
    }

    public String getResourceService() {
        return this.service;
    }

    public String getResourceDataset() {
        return this.dataset;
    }

    public String getResourceMember() {
        return this.member;
    }

    public IPDHost getHost() {
        return this.host;
    }

    @Deprecated
    public static ReportsListDisplayedResource getResourceFromElement(IFile element) {
        return ReportsListDisplayedResource.getResourceFromElement(null, element);
    }

    public static ReportsListDisplayedResource getResourceFromElement(IPDHost host, IFile element) {
        Objects.requireNonNull(element, "Must provide a non-null Ifile element.");
        ReportsListDisplayedResource reportsListDisplayedResource = new ReportsListDisplayedResource();
        reportsListDisplayedResource.setDisplayedResourceProperties(host, element.getProjectRelativePath().toString());
        return reportsListDisplayedResource;
    }
}

