/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import java.util.Objects;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeColumn;

public class ReportsListColumnSelectionAdapter
extends SelectionAdapter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ReportsList reportsList;
    private final String name;
    private final TreeColumn column;

    public ReportsListColumnSelectionAdapter(ReportsList reportsList, String name, TreeColumn column) {
        this.reportsList = Objects.requireNonNull(reportsList, "Must provide non-null reportsList.");
        this.name = Objects.requireNonNull(name, "Must provide non-null name.");
        this.column = Objects.requireNonNull(column, "Must provide non-null column");
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.name.equals(this.reportsList.getSortColumn())) {
            this.reportsList.setSortAscending(!this.reportsList.isSortAscending());
        } else {
            this.reportsList.setSortAscending(true);
        }
        this.reportsList.setSortColumn(this.name);
        try {
            this.reportsList.getTable().getTree().setRedraw(false);
            this.reportsList.getTable().getTree().setSortColumn(this.column);
            if (this.reportsList.isSortAscending()) {
                this.reportsList.getTable().getTree().setSortDirection(128);
            } else {
                this.reportsList.getTable().getTree().setSortDirection(1024);
            }
            this.reportsList.getTable().refresh();
        }
        finally {
            this.reportsList.getTable().getTree().setRedraw(true);
        }
    }
}

