/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Preferences;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;

public class ReportsListColumnLabelProvider
extends ColumnLabelProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String name;
    private final TreeViewer table;
    private final ReportsList reportsList;
    public static Set<String> deletedFaultIds = new HashSet<String>();

    public ReportsListColumnLabelProvider(TreeViewer table, String name, ReportsList reportsList) {
        this.table = table;
        this.name = name;
        this.reportsList = reportsList;
    }

    public Color getBackground(Object element) {
        if (element instanceof Map) {
            if ("true".equals(((Map)element).get(ViewParser.class.getCanonicalName() + ".deleted"))) {
                String string = ((Map)element).get("FAULT_ID").toString();
                deletedFaultIds.add(string);
                return Preferences.getDeletedFaultEntryHighlightColor();
            }
            if (this.reportsList.isFilterColumn(this.name)) {
                return Preferences.getBookmarkUsernoteColor();
            }
        }
        return super.getBackground(element);
    }

    public String getText(Object element) {
        String extension;
        if (element instanceof Map) {
            Map map = (Map)element;
            return (String)map.get(this.name);
        }
        int[] order = this.table.getTree().getColumnOrder();
        if (order.length > 0 && !this.name.equals(this.table.getTree().getColumn(order[0]).getText())) {
            return "";
        }
        IPath path = FACorePlugin.getRoot().getFile((String)element).getProjectRelativePath();
        switch (extension = path.getFileExtension()) {
            case "faml": {
                switch (path.removeFileExtension().lastSegment()) {
                    case "abend": {
                        return Messages.ReportsList_Abend_information;
                    }
                    case "event": {
                        return Messages.ReportsList_Event_details;
                    }
                    case "main": {
                        return Messages.ReportsList_Main_report;
                    }
                    case "misc": {
                        return Messages.ReportsList_Miscellaneous;
                    }
                    case "system": {
                        return Messages.ReportsList_System_wide_information;
                    }
                }
                return Messages.ReportsList_Report;
            }
            case "mdml": {
                return Messages.ReportsList_Minidump;
            }
            case "opt": {
                return Messages.ReportsList_Options;
            }
        }
        if (!path.lastSegment().startsWith(".")) {
            return path.lastSegment();
        }
        return String.valueOf(element);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setBackground(this.getBackground(element));
        super.update(cell);
    }

    public String getToolTipText(Object element) {
        return ColumnNames.ColumnTooltips.getTooltip(this.name);
    }
}

