/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ReportsListColumnControlAdapter
extends ControlAdapter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ReportsList reportsList;

    public ReportsListColumnControlAdapter(ReportsList reportsList) {
        this.reportsList = reportsList;
    }

    public void controlMoved(ControlEvent e) {
        try {
            this.reportsList.getTable().getTree().setRedraw(false);
            int[] oldOrder = this.reportsList.getColumnOrderArray();
            TreeColumn treeColumn = (TreeColumn)e.getSource();
            int[] newOrder = treeColumn.getParent().getColumnOrder();
            if (!Arrays.equals(oldOrder, newOrder) && this.reportsList.getColumnOrderArray() != null) {
                TreeItem[] newTreeItems;
                TreeItem[] treeItems = treeColumn.getParent().getItems();
                LinkedList<String> toReopen = new LinkedList<String>();
                TreeItem[] treeItemArray = treeItems;
                int n = treeItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    if (treeItem.getExpanded()) {
                        toReopen.add(treeItem.getText());
                    }
                    ++n2;
                }
                this.reportsList.getTable().refresh();
                LinkedList<TreeItem> toCollapse = new LinkedList<TreeItem>();
                TreeItem[] treeItemArray2 = newTreeItems = treeColumn.getParent().getItems();
                int n3 = newTreeItems.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem treeItem = treeItemArray2[n4];
                    toCollapse.add(treeItem);
                    for (String reopenItem : toReopen) {
                        if (!treeItem.getText().equalsIgnoreCase(reopenItem)) continue;
                        toCollapse.remove(treeItem);
                    }
                    ++n4;
                }
                for (TreeItem treeItem : toCollapse) {
                    treeItem.setExpanded(false);
                }
                this.reportsList.setColumnOrderArray(treeColumn.getParent().getColumnOrder());
            }
            this.reportsList.setColumnOrderArray(treeColumn.getParent().getColumnOrder());
        }
        finally {
            this.reportsList.setDirty(true);
            this.reportsList.getTable().getTree().setRedraw(true);
        }
    }
}

