/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.Activator;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.AutomaticReportsListRefreshJob;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.FaultEntries;
import com.ibm.etools.fa.pdtclient.ui.faobjects.view.ViewParser;
import com.ibm.etools.fa.pdtclient.ui.util.EclipseUtils;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.Configurations;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListColumnControlAdapter;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListColumnLabelProvider;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListColumnSelectionAdapter;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListDisplayedResource;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListOpenListener;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListTreeContentProvider;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListViewerComparator;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsListViewerFilter;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.SortTypes;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.util.PDUserTask;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ReportsList
extends ViewPart
implements ISaveablePart {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ReportsList.class);
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.reports";
    private static final String EMPTY = "";
    private final Map<String, String> filters = new HashMap<String, String>();
    private TreeViewer table;
    private boolean sort_ascending = false;
    private String sort_column = "DATE";
    private Composite parent;
    private Label label;
    private Text text;
    private Button checkBox;
    private final Map<String, String> localFilters = new HashMap<String, String>();
    private boolean localFilterFlag;
    private int[] columnOrder;
    private static final Map<String, SortTypes> columnTypeMap = Collections.unmodifiableMap(ReportsList.createColumnTypeMap());
    private final ColumnModel model = new ColumnModel();
    private static final Pattern TAG_REGEX = Pattern.compile("<li>(.+?)</li>", 32);
    ReportsListColumnControlAdapter reportsListColumnControlAdapter = new ReportsListColumnControlAdapter(this);
    public static final int PROP_SOURCE_CHANGED = 66;
    private final ReportsListDisplayedResource displayedResource = new ReportsListDisplayedResource();
    private boolean isDirty = false;

    public ReportsList() {
        this.initialiseConfiguration();
    }

    public static ReportsList showView() {
        return (ReportsList)PDPlatformUIUtils.view.showView((String)ID, ReportsList.class);
    }

    public static SortTypes getColumnType(String column) {
        SortTypes type = columnTypeMap.get(column);
        if (type == null) {
            logger.debug((Object)("An unknown column name was queried for its type: " + column));
            return SortTypes.STRING;
        }
        return type;
    }

    private static Map<String, SortTypes> createColumnTypeMap() {
        HashMap<String, SortTypes> typeMap = new HashMap<String, SortTypes>();
        typeMap.put("FAULT_ID", SortTypes.STRING);
        typeMap.put("JOB/TRAN", SortTypes.STRING);
        typeMap.put("USER_ID", SortTypes.STRING);
        typeMap.put("SYS/JOB", SortTypes.STRING);
        typeMap.put("ABEND", SortTypes.STRING);
        typeMap.put("I_ABEND", SortTypes.STRING);
        typeMap.put("JOB_ID", SortTypes.STRING);
        typeMap.put("JOBNAME", SortTypes.STRING);
        typeMap.put("USERNAME", SortTypes.STRING);
        typeMap.put("PROGRAM", SortTypes.STRING);
        typeMap.put("MD_PAGES", SortTypes.INTEGER);
        typeMap.put("APPL_ID", SortTypes.STRING);
        typeMap.put("CLASS", SortTypes.STRING);
        typeMap.put("CICS_TRN", SortTypes.STRING);
        typeMap.put("DATE", SortTypes.DATE);
        typeMap.put("DUP_DATE", SortTypes.DATE);
        typeMap.put("DUP_TIME", SortTypes.DATE);
        typeMap.put("DUPS", SortTypes.INTEGER);
        typeMap.put("EXEC_PGM", SortTypes.STRING);
        typeMap.put("HISTORY_FILE_DSN", SortTypes.STRING);
        typeMap.put("IMS_PGM", SortTypes.STRING);
        typeMap.put("JOB_TYPE", SortTypes.STRING);
        typeMap.put("LOCK", SortTypes.STRING);
        typeMap.put("MINIDUMP", SortTypes.BOOLEAN);
        typeMap.put("MODULE", SortTypes.STRING);
        typeMap.put("MVS_DUMP", SortTypes.BOOLEAN);
        typeMap.put("MVS_DUMP_DSN", SortTypes.STRING);
        typeMap.put("NETNAME", SortTypes.STRING);
        typeMap.put("OFFSET", SortTypes.HEXADECIMAL);
        typeMap.put("STEPNAME", SortTypes.STRING);
        typeMap.put("SYSTEM", SortTypes.STRING);
        typeMap.put("TASK", SortTypes.STRING);
        typeMap.put("TERM_ID", SortTypes.STRING);
        typeMap.put("TIME", SortTypes.DATE);
        typeMap.put("USER_TITLE", SortTypes.STRING);
        typeMap.put("LOCK_USERID", SortTypes.STRING);
        typeMap.put("GROUP_ID", SortTypes.STRING);
        typeMap.put("DTFJ_STATUS", SortTypes.STRING);
        typeMap.put("LOCKED", SortTypes.STRING);
        typeMap.put("SPILLED", SortTypes.STRING);
        typeMap.put("PROGRAM_(LONG)", SortTypes.STRING);
        return typeMap;
    }

    public static void runAndMarkPartBusy(Job job) {
        Objects.requireNonNull(job, "Must specify a non-null job.");
        ReportsList list = ReportsList.showView();
        if (list != null) {
            PDPlatformUIUtils.scheduleAndMarkPartBusy((Job)job, (IWorkbenchPartSite)list.getSite());
        } else {
            job.schedule();
        }
    }

    private void initialiseConfiguration() {
        this.sort_ascending = false;
        this.setPartName(Messages.ReportsList_FaultEntryList);
    }

    public TreeColumn getColumnWithNameFromTable(String name) {
        TreeColumn[] treeColumnArray = this.table.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn t = treeColumnArray[n2];
            if (t.getText().startsWith(name)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    private List<String> getEnabledColumnsViewOrder() {
        final LinkedList<String> displayedColumns = new LinkedList<String>();
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!ReportsList.this.table.getTree().isDisposed() && ReportsList.this.table.getTree().getColumnOrder().length != 0) {
                    int[] nArray = ReportsList.this.table.getTree().getColumnOrder();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        displayedColumns.add(ReportsList.this.table.getTree().getColumn(i).getText());
                        ++n2;
                    }
                } else if (ReportsList.this.table.getTree().isDisposed()) {
                    logger.trace((Object)"Could not get column order as part is disposed.");
                }
            }
        });
        return displayedColumns;
    }

    public List<String> getEnabledColumns() {
        return this.model.getEnabledColumnNames();
    }

    public void showColumn(String columnName) {
        this.showColumn(columnName, true);
        this.table.refresh(true);
    }

    private void showColumn(final String columnName, final boolean setDirty) {
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ReportsList.this.model.showColumn(columnName);
                    Map<String, Integer> oldColWidths = ReportsList.this.disposeAllColumns();
                    ReportsList.this.createAllEnabledColumns(oldColWidths);
                    ReportsList.this.setColumnOrderArray(ReportsList.this.table.getTree().getColumnOrder());
                }
                finally {
                    ReportsList.this.setDirty(setDirty);
                }
            }
        });
    }

    private void execWithoutTreeRedraw(Runnable r) {
        try {
            this.setTreeRedraw(false);
            r.run();
        }
        finally {
            this.setTreeRedraw(true);
        }
    }

    private void setTreeRedraw(final boolean treeRedraw) {
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ReportsList.this.table.getTree().setRedraw(treeRedraw);
            }
        });
    }

    private Map<String, Integer> disposeAllColumns() {
        final HashMap<String, Integer> oldWidths = new HashMap<String, Integer>();
        this.execWithoutTreeRedraw(new Runnable(){

            @Override
            public void run() {
                TreeColumn[] treeColumnArray = ReportsList.this.table.getTree().getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn tc = treeColumnArray[n2];
                    tc.removeControlListener((ControlListener)ReportsList.this.reportsListColumnControlAdapter);
                    ++n2;
                }
                while (ReportsList.this.table.getTree().getColumnCount() > 0) {
                    TreeColumn treeColumn = ReportsList.this.table.getTree().getColumns()[0];
                    oldWidths.put(treeColumn.getText(), treeColumn.getWidth());
                    treeColumn.dispose();
                }
            }
        });
        return oldWidths;
    }

    private void createAllEnabledColumns() {
        this.createAllEnabledColumns(Collections.EMPTY_MAP);
    }

    private void createAllEnabledColumns(final Map<String, Integer> colWidths) {
        Objects.requireNonNull(colWidths);
        this.execWithoutTreeRedraw(new Runnable(){

            @Override
            public void run() {
                for (String colName : ReportsList.this.getEnabledColumns()) {
                    Integer width = (Integer)colWidths.get(colName);
                    if (width != null) {
                        ReportsList.this.createColumn(colName).getColumn().setWidth(width.intValue());
                        continue;
                    }
                    ReportsList.this.createColumn(colName);
                }
                TreeColumn columnToSort = ReportsList.this.getColumnWithNameFromTable(ReportsList.this.sort_column);
                if (columnToSort != null) {
                    ReportsList.this.table.getTree().setSortColumn(columnToSort);
                }
            }
        });
    }

    private void hideColumn(String columnName) {
        try {
            this.model.hideColumn(columnName);
            Map<String, Integer> oldColWidths = this.disposeAllColumns();
            this.createAllEnabledColumns(oldColWidths);
            this.setColumnOrderArray(this.table.getTree().getColumnOrder());
        }
        finally {
            this.table.refresh(true);
            this.setDirty(true);
        }
    }

    public void setLocalFilterFlag(boolean flag) {
        this.localFilterFlag = flag;
    }

    public boolean getLocalFilterFlag() {
        return this.localFilterFlag;
    }

    public void setLocalFilters(Map<String, String> filters) {
        this.setLocalFilterFlag(true);
        this.localFilters.putAll(filters);
        this.setFilterSelection(true);
    }

    public void setLocalFiltersMap(Map<String, String> filters) {
        this.setLocalFilterFlag(true);
        this.localFilters.clear();
        this.localFilters.putAll(filters);
        this.setFilterSelection(true);
    }

    public Map<String, String> getLocalFilters() {
        return this.localFilters;
    }

    public void removeLocalFilters() {
        this.setLocalFilterFlag(false);
        this.localFilters.clear();
    }

    private void toggleFilterHandler() {
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                if (btn.getSelection()) {
                    ReportsList.this.setFilters(ReportsList.this.getLocalFilters());
                } else {
                    ReportsList.this.setFilters(new HashMap<String, String>(), true);
                }
                ReportsList.this.table.setInput(ReportsList.this.table.getInput());
            }
        });
    }

    public void createPartControl(Composite parentComp) {
        ((IContextService)this.getSite().getService(IContextService.class)).activateContext(ID);
        this.parent = parentComp;
        parentComp.setLayoutData((Object)new GridData(256, 2, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parentComp.setLayout((Layout)layout);
        Composite labelComposite = new Composite(parentComp, 0);
        labelComposite.setLayout((Layout)new GridLayout(3, false));
        this.label = new Label(labelComposite, 0);
        this.label.setText(Messages.FilterCriteriaLabel);
        this.text = new Text(labelComposite, 2056);
        this.text.setEditable(false);
        this.text.setEnabled(false);
        this.text.setText(Messages.FilterCriteriaNone);
        this.checkBox = new Button(labelComposite, 32);
        this.checkBox.setToolTipText(Messages.FilterCriteriaToggleTooltip);
        this.checkBox.setEnabled(false);
        this.toggleFilterHandler();
        GridData gridData = new GridData(4, 4, true, true);
        this.table = new TreeViewer(parentComp, 0x10010002);
        this.table.getTree().setLayoutData((Object)gridData);
        this.table.getTree().setHeaderVisible(true);
        this.table.getTree().setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.table);
        String old = null;
        IFile file = FACorePlugin.getRoot().getFile(".cols");
        XMLMemento oldM = MementoUtils.loadXMLMementoFromIFile((IFile)file, (boolean)true, (Charset)StandardCharsets.UTF_8, null);
        if (oldM != null) {
            old = oldM.toString();
            List<String> columns = ReportsList.getTagValues(old = old.replace("&#x0A;", "\r\n"));
            if (columns.size() > 0) {
                int name_index = 0;
                for (String name : columns) {
                    this.model.addColumn(name, name_index < columns.size());
                    ++name_index;
                }
            }
        } else {
            int name_index = 0;
            String[] stringArray = ColumnNames.defaultColumns;
            int n = ColumnNames.defaultColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.model.addColumn(name, name_index < ColumnNames.defaultColumns.length);
                ++name_index;
                ++n2;
            }
        }
        this.createAllEnabledColumns();
        this.attachTreeViewerListeners();
        this.setDirty(false);
        if (PDLoggerJhost.isTraceEnabled()) {
            logger.trace((Object)MessageFormat.format("Expecting these columns to be displayed: {0} | Displayed columns are {1}", this.getEnabledColumns(), this.getEnabledColumnsViewOrder()));
        }
    }

    private static List<String> getTagValues(String str) {
        ArrayList<String> tagValues = new ArrayList<String>();
        Matcher matcher = TAG_REGEX.matcher(str);
        while (matcher.find()) {
            tagValues.add(matcher.group(1));
        }
        return tagValues;
    }

    private TreeViewerColumn createColumn(String name) {
        TreeViewerColumn col = new TreeViewerColumn(this.table, 0);
        TreeColumn column = col.getColumn();
        column.setText(name);
        column.setToolTipText(ColumnNames.ColumnTooltips.getTooltip(name));
        col.setLabelProvider((CellLabelProvider)new ReportsListColumnLabelProvider(this.table, name, this));
        column.addSelectionListener((SelectionListener)new ReportsListColumnSelectionAdapter(this, name, column));
        column.addControlListener((ControlListener)this.reportsListColumnControlAdapter);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(100);
        return col;
    }

    private void attachTreeViewerListeners() {
        this.table.setContentProvider((IContentProvider)new ReportsListTreeContentProvider(this));
        this.table.setFilters(new ViewerFilter[]{new ReportsListViewerFilter(this.filters)});
        this.table.setComparator((ViewerComparator)new ReportsListViewerComparator(this));
        this.getSite().setSelectionProvider((ISelectionProvider)this.table);
        MenuManager mgr = new MenuManager();
        this.table.getControl().setMenu(mgr.createContextMenu(this.table.getControl()));
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.table);
        this.table.addOpenListener((IOpenListener)new ReportsListOpenListener(this.displayedResource));
        this.table.getTree().addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                String family = "ReportsListFirstColumnPackJob";
                UIJob uiJob = new UIJob("Packing..."){

                    public boolean belongsTo(Object f) {
                        return "ReportsListFirstColumnPackJob".equals(f);
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (monitor != null && !monitor.isCanceled()) {
                            int[] displayColumnOrder = ReportsList.this.getTable().getTree().getColumnOrder();
                            if (displayColumnOrder != null && displayColumnOrder.length != 0) {
                                List<String> enabledColumns2 = ReportsList.this.getEnabledColumnsViewOrder();
                                if (!enabledColumns2.isEmpty()) {
                                    String col = enabledColumns2.get(0);
                                    logger.trace((Object)("Packing: " + col));
                                    TreeColumn columnWithNameFromTable = ReportsList.this.getColumnWithNameFromTable(col);
                                    columnWithNameFromTable.pack();
                                }
                            } else {
                                logger.error((Object)"col order is null / empty");
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                Job.getJobManager().cancel((Object)"ReportsListFirstColumnPackJob");
                uiJob.schedule();
            }

            public void treeCollapsed(TreeEvent e) {
            }
        });
    }

    public static String formatPartName(String partPath) {
        Objects.requireNonNull(partPath, "Must provide a non-null pathPath.");
        return Ipv6Utils.encodedPathToUri((String)partPath.replaceFirst("/", " : "), (String)" : ");
    }

    public Map<String, String> get_filters() {
        return this.filters;
    }

    public String get_source() {
        return this.table.getInput() == null ? null : this.table.getInput().toString();
    }

    public void refresh() {
        this.refresh(null, null);
    }

    @Deprecated
    public void refresh(String host, String port, String hf, String fe) {
        this.refresh(null, FAResourceUtils.getProjectRelativePath((String)host, (String)port, (String)hf, (String)fe));
    }

    public void refresh(IPDHost system, String host, String port, String hf, String fe) {
        this.refresh(system, FAResourceUtils.getProjectRelativePath((String)host, (String)port, (String)hf, (String)fe));
    }

    @Deprecated
    public void refresh(String sourcePath) {
        this.refresh(null, sourcePath);
    }

    public void refresh(IPDHost system, String sourcePath) {
        if (sourcePath != null) {
            logger.trace((Object)("Source set to " + sourcePath));
            this.set_source(system, sourcePath);
        } else {
            this.set_source(system, (String)this.table.getInput());
        }
        this.saveColumnsEnabledInReportsList();
    }

    public void set_columns(final List<String> newColumns) {
        if (newColumns.isEmpty()) {
            this.resetColumns();
            return;
        }
        this.model.hideAll();
        this.execWithoutTreeRedraw(new Runnable(){

            @Override
            public void run() {
                for (String name : newColumns) {
                    ReportsList.this.model.showColumn(name);
                    ReportsList.this.showColumn(name, false);
                }
            }
        });
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ReportsList.this.execWithoutTreeRedraw(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ReportsList.this.table.isBusy()) {
                            (this).ReportsList.this.table.refresh();
                        } else {
                            logger.trace((Object)"Can't refresh tree when it is already busy");
                        }
                        if (PDLoggerJhost.isTraceEnabled()) {
                            List<String> enabledColumnsViewOrder = ReportsList.this.getEnabledColumnsViewOrder();
                            logger.trace((Object)MessageFormat.format("hiding all columns, then showing columns: {0} | Displayed columns are: {1}", newColumns, enabledColumnsViewOrder));
                            if (!newColumns.toString().equals(enabledColumnsViewOrder.toString())) {
                                logger.trace((Object)"Warning column order changed / not as expected.");
                            }
                        }
                    }
                });
            }
        });
    }

    public void resetFilters() {
        this.resetFilters(false);
    }

    public void resetFilters(boolean refresh) {
        this.resetFilters(refresh, false);
    }

    public void resetFilters(boolean refresh, boolean localFilter) {
        this.setFilters(new HashMap<String, String>(), localFilter);
        if (refresh) {
            this.refresh();
        }
    }

    public void setFilters(Map<String, String> newFilters) {
        this.setFilters(newFilters, false);
    }

    public void setFilterSelection(boolean flag) {
        this.checkBox.setSelection(flag);
    }

    private void disableFilterDisplay() {
        if (this.checkBox != null) {
            this.checkBox.setEnabled(false);
            this.checkBox.setSelection(false);
        }
        if (this.text != null) {
            this.text.setEnabled(false);
        }
    }

    private void enableFilterDisplay() {
        this.checkBox.setEnabled(true);
        this.text.setEnabled(true);
    }

    public void setFilters(Map<String, String> newFilters, boolean localFilter) {
        this.filters.clear();
        this.filters.putAll(newFilters);
        this.refreshFilterText(localFilter);
    }

    public void refreshFilterText(boolean localFilter) {
        Object labelText = EMPTY;
        LinkedHashSet<String> mySet = new LinkedHashSet<String>(this.getEnabledColumnsViewOrder());
        Map<String, String> currentFilter = localFilter ? this.localFilters : this.filters;
        for (String name : mySet) {
            String currentFilterValue = currentFilter.get(name);
            if (!currentFilter.containsKey(name) || currentFilterValue == null) continue;
            if (labelText != EMPTY) {
                labelText = (String)labelText + " AND ";
            }
            labelText = (String)labelText + name + "(" + EclipseUtils.sanitiseRegexOutput(currentFilterValue) + ")";
        }
        if (labelText == EMPTY) {
            this.disableFilterDisplay();
        } else {
            this.enableFilterDisplay();
            this.checkBox.setEnabled(true);
            if (this.filters.isEmpty() && localFilter) {
                this.text.setEnabled(false);
                this.setFilterSelection(false);
            }
        }
        if (this.text != null) {
            this.text.setText((String)(labelText != EMPTY ? labelText : "None"));
        }
        if (this.parent != null) {
            this.parent.layout();
        }
    }

    private void set_source(IPDHost host, final String _source) {
        if (_source == null || _source.equals(EMPTY)) {
            AutomaticReportsListRefreshJob.cancelAnyJobs();
            this.displayedResource.setDisplayedResourceProperties(host, EMPTY);
            this.setPartName(Messages.ReportsList_FaultEntryList);
        } else {
            this.setPartName(ReportsList.formatPartName(FACorePlugin.getRoot().getFile(_source).getProjectRelativePath().removeFileExtension().toString()));
            this.displayedResource.setDisplayedResourceProperties(host, FACorePlugin.getRoot().getFile(_source).getProjectRelativePath().removeFileExtension().toString());
            AutomaticReportsListRefreshJob.update();
        }
        PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ReportsList.this.table.setInput((Object)_source);
                PDUserTask.createAndRunJob((String)Messages.ReportsList_LoadedPropertyChangeFire, (PDUserTask.PDUserJobFunction)new PDUserTask.PDUserJobFunction(){

                    public void run(IProgressMonitor monitor) {
                        ReportsList.this.firePropertyChange(66);
                    }
                });
            }
        });
    }

    public void reset() {
        this.initialiseConfiguration();
        this.set_source(null, EMPTY);
    }

    public void setFocus() {
        this.table.getControl().setFocus();
    }

    private void loadLastUsedHistoryFile() {
        List<String> saved = Activator.retrieve("com.ibm.etools.fa.pdtclient.ui.reports.dataset");
        if (this.table != null && this.get_source() == null && !saved.isEmpty() && ReportsList.getIfOpen() != null) {
            this.set_source(null, saved.get(0));
        }
    }

    public static ReportsList activate() {
        return (ReportsList)PDPlatformUIUtils.view.activate((String)ID, ReportsList.class);
    }

    @Deprecated
    public static void setSource(String source) {
        ReportsList.setSource(null, source);
    }

    public static void setSource(IPDHost host, String source) {
        Objects.requireNonNull(source, "Must provide a non-null source.");
        ReportsList reportsList = ReportsList.getIfOpen();
        if (reportsList != null) {
            reportsList.set_source(host, source);
        }
    }

    @Deprecated
    public static void setSource(String address, String port, String dataset, String member) {
        ReportsList.setSource(null, FAResourceUtils.getProjectRelativePath((String)address, (String)port, (String)dataset, (String)member));
    }

    public static void setSource(IPDHost host, String address, String port, String dataset, String member) {
        ReportsList.setSource(host, FAResourceUtils.getProjectRelativePath((String)address, (String)port, (String)dataset, (String)member));
    }

    public static ReportsList show() {
        return ReportsList.show(true);
    }

    public static ReportsList show(boolean loadLast) {
        ReportsList v = (ReportsList)PDPlatformUIUtils.view.showView((String)ID, ReportsList.class);
        if (v != null && loadLast) {
            v.loadLastUsedHistoryFile();
        }
        return v;
    }

    public List<Map<String, String>> getSelectedFaultEntries() {
        if (this.table != null && this.table.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
            List selected = selection.toList();
            ArrayList<Map<String, String>> typed = new ArrayList<Map<String, String>>();
            for (Object o : selected) {
                if (!(o instanceof HashMap)) continue;
                HashMap h = (HashMap)o;
                HashMap<String, String> typedMap = new HashMap<String, String>();
                for (Map.Entry e : h.entrySet()) {
                    typedMap.put((String)e.getKey(), (String)e.getValue());
                }
                typed.add(typedMap);
            }
            return typed;
        }
        return Collections.EMPTY_LIST;
    }

    public int getDisplayedFaultEntryCount() {
        Integer num = (Integer)PDSafeUIRunner.syncExec((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ReportsList.this.table.getTree().getItemCount();
            }
        });
        return num == null ? -1 : num;
    }

    public String getInputName() {
        Object input;
        if (this.table != null && (input = this.table.getInput()) instanceof String) {
            return (String)input;
        }
        return null;
    }

    public static ReportsList getIfOpen() {
        return (ReportsList)PDPlatformUIUtils.view.findView((String)ID, ReportsList.class);
    }

    public String getSelectedFaultIDsString() {
        List<Map<String, String>> selectedFaultEntries;
        if (this.getInputName() != null && !(selectedFaultEntries = this.getSelectedFaultEntries()).isEmpty()) {
            StringBuffer member_list = new StringBuffer();
            for (Map<String, String> fe : selectedFaultEntries) {
                member_list.append(fe.get("FAULT_ID")).append(",");
            }
            return member_list.substring(0, member_list.length() - 1);
        }
        return EMPTY;
    }

    public static void resetIfInputIs(String path) {
        String inputName;
        ReportsList reportsList = ReportsList.getIfOpen();
        if (reportsList != null && (inputName = reportsList.getInputName()) != null && inputName.equals(path)) {
            reportsList.reset();
        }
    }

    public void resetConfiguration() {
        this.resetColumns();
        this.resetFilters(true);
        Configurations.deleteSavedSelectedConfigFileName();
    }

    public void resetColumns() {
        this.resetColumns(false);
    }

    public void resetColumns(boolean refresh) {
        this.set_columns(Arrays.asList(ColumnNames.defaultColumns));
        if (refresh) {
            this.refresh();
        }
        this.setDirty(true);
    }

    public void saveColumnsEnabledInReportsList() {
        String fam = "SaverColumnsInListFamily";
        Job saver = new Job("Saver"){

            protected IStatus run(IProgressMonitor monitor) {
                List<String> enabledColumns2 = ReportsList.this.getEnabledColumnsViewOrder();
                if (!enabledColumns2.isEmpty()) {
                    IFile file = FACorePlugin.getRoot().getFile(".cols");
                    String old = null;
                    if (!file.exists()) {
                        IResourceUtils.createEmptyIFile((IFile)file, (boolean)true, (IProgressMonitor)monitor);
                    } else {
                        XMLMemento oldM = MementoUtils.loadXMLMementoFromIFile((IFile)file, (boolean)true, (Charset)StandardCharsets.UTF_8, (IProgressMonitor)monitor);
                        if (oldM != null) {
                            old = oldM.toString();
                            old = old.replace("&#x0A;", "\r\n");
                        }
                    }
                    XMLMemento root = XMLMemento.createWriteRoot((String)"ul");
                    IMemento li = root.createChild("li");
                    li.putString("id", "columns");
                    IMemento ol = li.createChild("ol");
                    for (String columnName : enabledColumns2) {
                        li = ol.createChild("li");
                        li.putTextData(columnName);
                    }
                    if (!(old != null && old.equals(root.toString()) || MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)root, (IFile)file, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)monitor))) {
                        logger.trace((Object)"Error occurred while saving...");
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "SaverColumnsInListFamily".equals(family);
            }
        };
        Job.getJobManager().cancel((Object)"SaverColumnsInListFamily");
        saver.schedule();
    }

    public void promptForFilter(String name) {
        String filter = this.filters.get(name);
        filter = filter == null ? EMPTY : EclipseUtils.sanitiseRegexOutput(filter);
        SortTypes type = ReportsList.getColumnType(name);
        String message = switch (type) {
            default -> Messages.Filters_String_Filter;
            case SortTypes.BOOLEAN -> Messages.Filters_Boolean_Filter;
            case SortTypes.DATE -> Messages.Filters_Date_Filter;
            case SortTypes.HEXADECIMAL -> Messages.Filters_Hex_Filter;
            case SortTypes.INTEGER -> Messages.Filters_Integer_Filter;
        };
        String title = MessageFormat.format(Messages.Filters_Specify_filter_for_column, new Object[]{name, type});
        InputDialog diag = new InputDialog(Display.getCurrent().getActiveShell(), title, message, filter, null);
        if (diag.open() == 0) {
            String newFilter = diag.getValue();
            if (newFilter != null && !newFilter.isEmpty()) {
                this.filters.put(name, EclipseUtils.sanitiseRegexInput(newFilter));
                this.setLocalFilters(this.filters);
            } else {
                this.filters.remove(name);
                this.localFilters.remove(name);
            }
            this.refresh();
        }
    }

    public void enableColumnConfiguration(String configFileName) {
        FaultEntries parsedConfig = ViewParser.parse(configFileName);
        this.set_columns(parsedConfig.getColumns());
        this.setFilters(parsedConfig.getFilters());
        this.refresh();
        if (this.get_source() != null && !this.get_source().endsWith(").hfml")) {
            this.saveColumnsEnabledInReportsList();
        }
    }

    public void toggleColumn(String name, boolean selected) {
        if (selected) {
            this.showColumn(name);
        } else if (!name.equalsIgnoreCase("FAULT_ID")) {
            this.hideColumn(name);
        } else {
            PDDialogs.openInfoThreadSafe((String)Messages.Column_FaultID_Deselect, (String)Messages.Column_FaultID_Deselect_Message);
        }
    }

    public String getSortColumn() {
        return this.sort_column;
    }

    public void setSortColumn(String sort_column) {
        this.sort_column = Objects.requireNonNull(sort_column);
    }

    public int[] getColumnOrderArray() {
        return this.columnOrder;
    }

    public boolean isSortAscending() {
        return this.sort_ascending;
    }

    public void setSortAscending(boolean sort_ascending) {
        this.sort_ascending = sort_ascending;
    }

    public TreeViewer getTable() {
        return this.table;
    }

    public void setColumnOrderArray(int[] columnOrder) {
        this.columnOrder = columnOrder;
    }

    public ReportsListDisplayedResource getDisplayedResource() {
        return this.displayedResource;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
        if (isDirty) {
            this.doSave(null);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveColumnsEnabledInReportsList();
        this.setDirty(false);
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public static ReportsList getReportsListIfActivePart(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        return activePart instanceof ReportsList ? (ReportsList)activePart : null;
    }

    public static Map<String, List<String>> getSelectedFaultEntriesFromReportsList(ExecutionEvent event) {
        List<Map<String, String>> selected;
        ReportsList r;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof ReportsList && (r = (ReportsList)activePart).getDisplayedResource().isAResourceBeingDisplayed() && !(selected = r.getSelectedFaultEntries()).isEmpty()) {
            HashMap<String, List<String>> member_origin_list = new HashMap<String, List<String>>();
            for (Map<String, String> fe : selected) {
                String origin = FACorePlugin.getRoot().getFile(fe.get(ViewParser.class.getCanonicalName()).toString()).getProjectRelativePath().segment(2);
                if (!member_origin_list.containsKey(origin)) {
                    member_origin_list.put(origin, new ArrayList());
                }
                List list = (List)member_origin_list.get(origin);
                list.add(fe.get("FAULT_ID"));
                member_origin_list.put(origin, list);
            }
            return member_origin_list;
        }
        return null;
    }

    public boolean isFilterColumn(String column) {
        Map<String, String> currentFilters = this.get_filters();
        for (String name : new TreeSet<String>(Arrays.asList(ColumnNames.column_names))) {
            if (!currentFilters.containsKey(name) || !name.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    private static class ColumnModel {
        private final Map<String, Boolean> enabledColumns = new LinkedHashMap<String, Boolean>();

        private ColumnModel() {
        }

        synchronized void hideColumn(String name) {
            logger.trace((Object)("hiding " + name));
            this.enabledColumns.remove(name);
            this.enabledColumns.put(name, false);
        }

        synchronized void hideAll() {
            for (Map.Entry<String, Boolean> e : this.enabledColumns.entrySet()) {
                e.setValue(false);
            }
        }

        synchronized void showColumn(String name) {
            this.enabledColumns.remove(name);
            this.enabledColumns.put(name, true);
        }

        synchronized void addColumn(String name, boolean enabled) {
            this.enabledColumns.put(name, enabled);
        }

        synchronized LinkedList<String> getEnabledColumnNames() {
            LinkedList<String> cols = new LinkedList<String>();
            for (Map.Entry<String, Boolean> e : this.enabledColumns.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                cols.add(e.getKey());
            }
            if (!cols.contains("FAULT_ID")) {
                cols.add("FAULT_ID");
            }
            return cols;
        }
    }
}

