/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.ui.util.EclipseUtils;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class Filters
extends ContributionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fa.pdtclient.ui.filters";
    private static final PDLogger logger = PDLogger.get(Filters.class);

    public void fill(Menu menu, int index) {
        final ReportsList reportsList = ReportsList.show(false);
        if (reportsList != null) {
            Map<String, String> currentFilters = reportsList.get_filters();
            for (final String name : new TreeSet<String>(Arrays.asList(ColumnNames.column_names))) {
                String currentFilterValue = currentFilters.get(name);
                MenuItem item = new MenuItem(menu, 32);
                item.setText(name + (String)(currentFilterValue == null ? "" : " (" + EclipseUtils.sanitiseRegexOutput(currentFilterValue) + ")"));
                item.setSelection(currentFilters.containsKey(name));
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Object src = e.getSource();
                        if (src instanceof MenuItem) {
                            reportsList.promptForFilter(name);
                        }
                    }
                });
            }
        } else {
            logger.warn((Object)"Reports list could not be opened.");
        }
    }
}

