/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;

public class Configurations
extends CompoundContributionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Configurations.class);
    public static boolean ignore_colname = false;

    public void fill(Menu menu, int index) {
        List<String> configs = Configurations.getListOfColsFiles();
        if (configs.isEmpty()) {
            MenuItem item = new MenuItem(menu, 0);
            item.setText(Messages.Configurations_NoColumnConfigurationsDefined);
            item.setEnabled(false);
        } else {
            for (String config : configs) {
                final MenuItem item = new MenuItem(menu, 16);
                String savedName = Configurations.loadSavedSelectedConfigFileName();
                if (savedName != null) {
                    item.setSelection(!ignore_colname && config.equals(savedName));
                }
                item.setText(config);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ignore_colname = false;
                        Configurations.saveSelectedConfigFileName(item.getText());
                        ReportsList r = ReportsList.show(false);
                        if (r != null) {
                            r.enableColumnConfiguration(item.getText());
                        }
                    }
                });
            }
        }
    }

    private static String loadSavedSelectedConfigFileName() {
        IFile colname = FACorePlugin.getRoot().getFile(".colname");
        if (colname.exists()) {
            try {
                List<String> lines = Files.readAllLines(colname.getLocation().toFile().toPath(), StandardCharsets.UTF_8);
                if (!lines.isEmpty()) {
                    return lines.get(0);
                }
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
        }
        return null;
    }

    private static void saveSelectedConfigFileName(String name) {
        IFile colnameFile = FACorePlugin.getRoot().getFile(".colname");
        if (!colnameFile.exists()) {
            IResourceUtils.createEmptyIFile((IFile)colnameFile, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        IResourceUtils.setIFileContents((IFile)colnameFile, (String)name, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
    }

    private static List<String> getListOfColsFiles() {
        final ArrayList<String> configs = new ArrayList<String>();
        try {
            Files.walkFileTree(FACorePlugin.getRoot().getLocation().toFile().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String name;
                    Objects.requireNonNull(file);
                    Objects.requireNonNull(attrs);
                    Path fileName = file.getFileName();
                    if (fileName != null && (name = fileName.toString()) != null && !name.isEmpty() && name.matches(".+\\.cols")) {
                        configs.add(name);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e1) {
            logger.warn((Object)"", (Throwable)e1);
        }
        Collections.sort(configs);
        return configs;
    }

    protected IContributionItem[] getContributionItems() {
        return new IContributionItem[]{this};
    }

    public static void deleteSavedSelectedConfigFileName() {
        IFile colname = FACorePlugin.getRoot().getFile(".colname");
        if (colname.exists()) {
            IResourceUtils.deleteIFile((IFile)colname, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
    }
}

