/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.util.EclipseUtils;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnNames;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.IColumnConfigurationUser;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;

public class ColumnConfigurationTable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ColumnConfigurationTable.class);
    private static final String MATCH_ATTRIBUTE = "match";
    private static final String COLUMNS_ATTRIBUTE = "columns";
    private static final String FILTER_ATTRIBUTE = "filter";
    private IColumnConfigurationUser tableUser;
    private Composite tableComposite;
    private List<ReportsListColumnInfo> columnInfoModelList;
    private Table columnTable;
    private CheckboxTableViewer columnTableViewer;
    private TableViewerColumn nameColumn;
    private TableViewerColumn filterColumn;
    private Composite tableButtonsComposite;
    private Button upButton;
    private Button downButton;
    private Button allButton;
    private Button noneButton;

    public ColumnConfigurationTable(IColumnConfigurationUser tableUser) {
        this.tableUser = tableUser;
    }

    public void createTable(Composite parent, GridData data) {
        if (this.tableComposite != null) {
            throw new IllegalStateException("Cannot create this table more than once");
        }
        this.tableComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)data);
        GridData tableData = GUI.grid.d.fillAll();
        tableData.heightHint = 370;
        this.columnTable = GUI.table((Composite)this.tableComposite, (Object)tableData, (int)67618);
        this.columnTable.setHeaderVisible(true);
        this.columnTable.setLinesVisible(true);
        this.columnTableViewer = new CheckboxTableViewer(this.columnTable);
        this.columnTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createTableViewerColumns();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.columnTableViewer);
        GridData buttonData = new GridData(16384, 128, false, false, 1, 1);
        buttonData.widthHint = 100;
        this.tableButtonsComposite = GUI.composite((Composite)this.tableComposite, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)new GridData(-1, 4, false, true, 1, 1));
        this.upButton = GUI.button.push((Composite)this.tableButtonsComposite, (String)Messages.ColumnConfigurationTable_UpButtonLabel, (Object)buttonData);
        this.downButton = GUI.button.push((Composite)this.tableButtonsComposite, (String)Messages.ColumnConfigurationTable_DownButtonLabel, (Object)buttonData);
        this.allButton = GUI.button.push((Composite)this.tableButtonsComposite, (String)Messages.ColumnConfigurationTable_selectAll, (Object)buttonData);
        this.noneButton = GUI.button.push((Composite)this.tableButtonsComposite, (String)Messages.ColumnConfigurationTable_deselectAll, (Object)buttonData);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.createListeners();
    }

    private void createListeners() {
        this.columnTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ReportsListColumnInfo columnInfo = (ReportsListColumnInfo)selection.getFirstElement();
                    if (columnInfo.getName().equals("FAULT_ID")) {
                        ColumnConfigurationTable.this.columnTableViewer.setChecked((Object)columnInfo, true);
                    } else {
                        ColumnConfigurationTable.this.columnTableViewer.setChecked((Object)columnInfo, !ColumnConfigurationTable.this.columnTableViewer.getChecked((Object)columnInfo));
                        columnInfo.setEnabled(!columnInfo.isEnabled());
                    }
                }
            }
        });
        this.columnTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ReportsListColumnInfo columnInfo = (ReportsListColumnInfo)event.getElement();
                if (columnInfo.getName().equals("FAULT_ID")) {
                    ColumnConfigurationTable.this.columnTableViewer.setChecked((Object)columnInfo, true);
                } else {
                    columnInfo.setEnabled(event.getChecked());
                }
            }
        });
        this.columnTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null || selection.isEmpty()) {
                    ColumnConfigurationTable.this.upButton.setEnabled(false);
                    ColumnConfigurationTable.this.downButton.setEnabled(false);
                } else {
                    ReportsListColumnInfo columnInfo = (ReportsListColumnInfo)selection.getFirstElement();
                    ColumnConfigurationTable.this.upButton.setEnabled(ColumnConfigurationTable.this.validUpPosition(columnInfo));
                    ColumnConfigurationTable.this.downButton.setEnabled(ColumnConfigurationTable.this.validDownPosition(columnInfo));
                }
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportsListColumnInfo columnInfo;
                IStructuredSelection selection = (IStructuredSelection)ColumnConfigurationTable.this.columnTableViewer.getSelection();
                if (selection != null && !selection.isEmpty() && ColumnConfigurationTable.this.validUpPosition(columnInfo = (ReportsListColumnInfo)selection.getFirstElement())) {
                    ColumnConfigurationTable.this.swapPositions(ColumnConfigurationTable.this.columnInfoModelList.indexOf(columnInfo), ColumnConfigurationTable.this.columnInfoModelList.indexOf(columnInfo) - 1, ColumnConfigurationTable.this.columnInfoModelList);
                }
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportsListColumnInfo columnInfo;
                IStructuredSelection selection = (IStructuredSelection)ColumnConfigurationTable.this.columnTableViewer.getSelection();
                if (selection != null && !selection.isEmpty() && ColumnConfigurationTable.this.validDownPosition(columnInfo = (ReportsListColumnInfo)selection.getFirstElement())) {
                    ColumnConfigurationTable.this.swapPositions(ColumnConfigurationTable.this.columnInfoModelList.indexOf(columnInfo), ColumnConfigurationTable.this.columnInfoModelList.indexOf(columnInfo) + 1, ColumnConfigurationTable.this.columnInfoModelList);
                }
            }
        });
        this.allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ReportsListColumnInfo i : ColumnConfigurationTable.this.columnInfoModelList) {
                    i.setEnabled(true);
                }
                ColumnConfigurationTable.this.columnTableViewer.setAllChecked(true);
            }
        });
        this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnConfigurationTable.this.columnTableViewer.setAllChecked(false);
                for (ReportsListColumnInfo i : ColumnConfigurationTable.this.columnInfoModelList) {
                    if (!i.getName().equals("FAULT_ID")) {
                        i.setEnabled(false);
                        continue;
                    }
                    ColumnConfigurationTable.this.columnTableViewer.setChecked((Object)i, true);
                }
            }
        });
    }

    private void createTableViewerColumns() {
        this.nameColumn = ColumnConfigurationTable.createTableViewerColumn(this.columnTableViewer, Messages.ColumnConfigurationTable_NameColumn, 200, 0);
        this.filterColumn = ColumnConfigurationTable.createTableViewerColumn(this.columnTableViewer, Messages.ColumnConfigurationTable_FilterColumn, 300, 0);
        this.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ReportsListColumnInfo)element).getName();
            }

            public String getToolTipText(Object element) {
                return ((ReportsListColumnInfo)element).getTooltipText();
            }
        });
        this.filterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ReportsListColumnInfo)element).getFilter();
            }

            public String getToolTipText(Object element) {
                return ((ReportsListColumnInfo)element).getTooltipText();
            }
        });
        this.filterColumn.setEditingSupport((EditingSupport)new FilterEditingSupport((TableViewer)this.columnTableViewer));
    }

    private static TableViewerColumn createTableViewerColumn(CheckboxTableViewer tableViewer, String title, int width, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(width);
        column.setResizable(false);
        column.setMoveable(false);
        return viewerColumn;
    }

    public void setTableContentsFromInputFile(IMemento memento) {
        int n;
        int n2;
        IMemento[] iMementoArray;
        IMemento currentMemento;
        LinkedHashMap<String, ReportsListColumnInfo> loadedColumnInfo = new LinkedHashMap<String, ReportsListColumnInfo>();
        IMemento[] iMementoArray2 = memento.getChildren("li");
        int n3 = iMementoArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            currentMemento = iMementoArray2[n4];
            if (currentMemento.getString("id") != null && currentMemento.getString("id").equals(COLUMNS_ATTRIBUTE)) {
                IMemento olColumns = currentMemento.getChild("ol");
                iMementoArray = olColumns.getChildren("li");
                n2 = iMementoArray.length;
                n = 0;
                while (n < n2) {
                    IMemento columnMemento = iMementoArray[n];
                    loadedColumnInfo.put(columnMemento.getTextData().trim(), new ReportsListColumnInfo(columnMemento.getTextData().trim(), true, ""));
                    ++n;
                }
            }
            ++n4;
        }
        iMementoArray2 = memento.getChildren("li");
        n3 = iMementoArray2.length;
        n4 = 0;
        while (n4 < n3) {
            currentMemento = iMementoArray2[n4];
            if (currentMemento.getString("id") != null && currentMemento.getString("id").equals(MATCH_ATTRIBUTE)) {
                IMemento olMatch = currentMemento.getChild("ol");
                iMementoArray = olMatch.getChildren("li");
                n2 = iMementoArray.length;
                n = 0;
                while (n < n2) {
                    IMemento matchMemento = iMementoArray[n];
                    if (loadedColumnInfo.containsKey(matchMemento.getTextData().trim())) {
                        ((ReportsListColumnInfo)loadedColumnInfo.get(matchMemento.getTextData().trim())).alterFilter(EclipseUtils.sanitiseRegexOutput(matchMemento.getString(FILTER_ATTRIBUTE)));
                    } else {
                        loadedColumnInfo.put(matchMemento.getTextData().trim(), new ReportsListColumnInfo(matchMemento.getTextData().trim(), false, matchMemento.getString(FILTER_ATTRIBUTE)));
                    }
                    ++n;
                }
            }
            ++n4;
        }
        ArrayList<ReportsListColumnInfo> resultList = new ArrayList<ReportsListColumnInfo>();
        for (Map.Entry columnInfo : loadedColumnInfo.entrySet()) {
            resultList.add((ReportsListColumnInfo)columnInfo.getValue());
        }
        this.getComplementAndPopulateTable(resultList);
    }

    public void setTableContentsFromReportsList() {
        ReportsList reportsList = ReportsList.getIfOpen();
        if (reportsList != null) {
            LinkedHashMap<String, ReportsListColumnInfo> loadedColumnInfo = new LinkedHashMap<String, ReportsListColumnInfo>();
            List<String> enabledList = reportsList.getEnabledColumns();
            Map<String, String> filterMap = reportsList.get_filters();
            for (String string : enabledList) {
                loadedColumnInfo.put(string, new ReportsListColumnInfo(string, true, ""));
            }
            for (Map.Entry entry : filterMap.entrySet()) {
                if (loadedColumnInfo.containsKey(entry.getKey())) {
                    ((ReportsListColumnInfo)loadedColumnInfo.get(entry.getKey())).alterFilter(EclipseUtils.sanitiseRegexOutput((String)entry.getValue()));
                    continue;
                }
                loadedColumnInfo.put((String)entry.getKey(), new ReportsListColumnInfo((String)entry.getKey(), false, (String)entry.getValue()));
            }
            ArrayList<ReportsListColumnInfo> arrayList = new ArrayList<ReportsListColumnInfo>();
            for (Map.Entry columnInfo : loadedColumnInfo.entrySet()) {
                arrayList.add((ReportsListColumnInfo)columnInfo.getValue());
            }
            this.getComplementAndPopulateTable(arrayList);
        } else {
            this.setTableContentsAsDefault();
        }
    }

    public IMemento saveConfiguration(IMemento memento) {
        IMemento liColumns = memento.createChild("li");
        liColumns.putString("id", COLUMNS_ATTRIBUTE);
        IMemento olColumns = liColumns.createChild("ol");
        for (ReportsListColumnInfo columnInfo : this.columnInfoModelList) {
            if (!columnInfo.isEnabled() && !columnInfo.getName().equals("FAULT_ID")) continue;
            IMemento columnMemento = olColumns.createChild("li");
            columnMemento.putTextData(columnInfo.getName().trim());
        }
        IMemento liMatch = memento.createChild("li");
        liMatch.putString("id", MATCH_ATTRIBUTE);
        IMemento olMatch = liMatch.createChild("ol");
        for (ReportsListColumnInfo columnInfo : this.columnInfoModelList) {
            IMemento filterMemento = olMatch.createChild("li");
            filterMemento.putString(FILTER_ATTRIBUTE, columnInfo.getFilter().trim());
            filterMemento.putTextData(columnInfo.getName().trim());
        }
        return memento;
    }

    public void setTableContentsAsDefault() {
        ArrayList<ReportsListColumnInfo> loadedColumnInfo = new ArrayList<ReportsListColumnInfo>();
        int i = 0;
        while (i < ColumnNames.defaultColumns.length) {
            loadedColumnInfo.add(new ReportsListColumnInfo(ColumnNames.defaultColumns[i], true, ""));
            ++i;
        }
        this.getComplementAndPopulateTable(loadedColumnInfo);
    }

    private void getComplementAndPopulateTable(List<ReportsListColumnInfo> inputColumnInfoList) {
        logger.trace((Object)MessageFormat.format("start: {0}", inputColumnInfoList));
        ArrayList<ReportsListColumnInfo> columnInfoList = new ArrayList<ReportsListColumnInfo>();
        ArrayList<ReportsListColumnInfo> otherColumns = new ArrayList<ReportsListColumnInfo>();
        String[] stringArray = ColumnNames.column_names;
        int n = ColumnNames.column_names.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            otherColumns.add(new ReportsListColumnInfo(columnName, false, ""));
            ++n2;
        }
        otherColumns.removeAll(inputColumnInfoList);
        logger.trace((Object)MessageFormat.format("before add to columnInfoList: {0}", columnInfoList));
        columnInfoList.addAll(inputColumnInfoList);
        logger.trace((Object)MessageFormat.format("after add to columnInfoList: {0}", columnInfoList));
        columnInfoList.addAll(otherColumns);
        logger.trace((Object)MessageFormat.format("after add other to columnInfoList: {0}", columnInfoList));
        this.columnInfoModelList = columnInfoList;
        this.columnTableViewer.setInput(this.columnInfoModelList);
        for (ReportsListColumnInfo row : columnInfoList) {
            this.columnTableViewer.setChecked((Object)row, row.isEnabled());
        }
        for (ReportsListColumnInfo row : columnInfoList) {
            if (!row.getName().equals("FAULT_ID")) continue;
            this.columnTableViewer.setChecked((Object)row, true);
            break;
        }
        this.columnTableViewer.refresh();
    }

    private boolean validUpPosition(ReportsListColumnInfo columnInfo) {
        int index = this.columnInfoModelList.indexOf(columnInfo);
        return index > 0;
    }

    private boolean validDownPosition(ReportsListColumnInfo columnInfo) {
        int index = this.columnInfoModelList.indexOf(columnInfo);
        return index < this.columnInfoModelList.size() - 1;
    }

    private void swapPositions(int source, int target, List<ReportsListColumnInfo> columnInfoList) {
        ReportsListColumnInfo temp = columnInfoList.get(target);
        columnInfoList.set(target, columnInfoList.get(source));
        columnInfoList.set(source, temp);
        this.columnTableViewer.refresh();
        this.upButton.setEnabled(this.validUpPosition(columnInfoList.get(target)));
        this.downButton.setEnabled(this.validDownPosition(columnInfoList.get(target)));
        this.columnTableViewer.reveal((Object)columnInfoList.get(target));
        this.tableUser.setDirtyByTable();
    }

    public void setReportsListColumns() {
        ReportsList.show(false);
        ReportsList reportsList = ReportsList.getIfOpen();
        if (reportsList != null) {
            ArrayList<String> showColumns = new ArrayList<String>();
            Map<String, String> filters = reportsList.get_filters();
            filters.clear();
            for (ReportsListColumnInfo columnInfo : this.columnInfoModelList) {
                if (columnInfo.isEnabled()) {
                    showColumns.add(columnInfo.getName());
                }
                if (columnInfo.getFilter().trim().isEmpty()) continue;
                filters.put(columnInfo.getName(), EclipseUtils.sanitiseRegexInput(columnInfo.getFilter()));
            }
            reportsList.set_columns(showColumns);
            reportsList.setLocalFiltersMap(filters);
            reportsList.refreshFilterText(true);
            reportsList.refresh();
        } else {
            logger.error((Object)"Could not open / find the reportslist. is it open?");
        }
    }

    public void setToolTipText(String text2) {
        this.columnTable.setToolTipText(text2);
    }

    public boolean setFocus() {
        return this.columnTable.setFocus();
    }

    private static class FilterEditingSupport
    extends EditingSupport {
        private TableViewer viewer;
        private TextCellEditor editor;

        public FilterEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editor = new TextCellEditor((Composite)this.viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((ReportsListColumnInfo)element).getFilter();
        }

        protected void setValue(Object element, Object value) {
            ((ReportsListColumnInfo)element).setFilter((String)value);
            this.viewer.update(element, null);
        }
    }

    private class ReportsListColumnInfo {
        private final String name;
        private boolean enabled;
        private String filter;
        private String tooltip;

        private ReportsListColumnInfo(String name, boolean enabled, String filter) {
            this.name = name;
            this.tooltip = ColumnNames.ColumnTooltips.getTooltip(this.name);
            this.enabled = enabled;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltipText() {
            return this.tooltip;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            if (this.name.equals("FAULT_ID")) {
                this.enabled = true;
            } else {
                this.enabled = enabled;
                ColumnConfigurationTable.this.tableUser.setDirtyByTable();
            }
        }

        public String getFilter() {
            return EclipseUtils.sanitiseRegexOutput(this.filter);
        }

        public void alterFilter(String alteredFilter) {
            this.filter = EclipseUtils.sanitiseRegexInput(alteredFilter);
        }

        public void setFilter(String filter) {
            this.filter = EclipseUtils.sanitiseRegexInput(filter);
            ColumnConfigurationTable.this.tableUser.setDirtyByTable();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReportsListColumnInfo other = (ReportsListColumnInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        private ColumnConfigurationTable getOuterType() {
            return ColumnConfigurationTable.this;
        }

        public String toString() {
            return MessageFormat.format("ReportsListColumnInfo [name={0}, enabled={1}, filter={2}]", this.name, this.enabled, this.filter);
        }
    }
}

