/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.ui.views.reportslist;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.etools.fa.pdtclient.core.FAResourceUtils;
import com.ibm.etools.fa.pdtclient.core.MementoUtils;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ColumnConfigurationTable;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.IColumnConfigurationUser;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ColumnConfigurationDialog
extends BaseTitleAreaDialog
implements IColumnConfigurationUser {
    private static final String CURRENT_REPORTSLIST = Messages.ColumnConfigurationDialog_CurrentReportsListComboEntry;
    private static final String DEFAULT_CONFIGURATION = Messages.ColumnConfigurationDialog_DefaultConfigurationComboEntry;
    private String currentConfigurationSelection;
    private boolean dirty = false;
    private List<String> configurationsList;
    private ColumnConfigurationTable columnTable = new ColumnConfigurationTable(this);

    protected Composite createDialogContent(Composite parent) {
        this.getShell().setText(Messages.ColumnConfiguration_Title);
        this.setTitle(Messages.ColumnConfiguration_Title);
        this.setMessage(Messages.ColumnConfiguration_Msg);
        Composite dialogComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)true), (Object)GUI.grid.d.fillAll());
        Composite configurationsComposite = GUI.composite((Composite)dialogComposite, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.left1());
        GridData comboData = GUI.grid.d.standard();
        comboData.widthHint = 200;
        Combo configurationsCombo = GUI.combo((Composite)configurationsComposite, (Object)comboData, (int)8);
        ComboViewer configurationsComboViewer = new ComboViewer(configurationsCombo);
        configurationsComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configurationsList = ColumnConfigurationDialog.getConfigurationFileList();
        configurationsComboViewer.setInput(this.configurationsList);
        configurationsCombo.select(0);
        GridData buttonData = GUI.grid.d.standard();
        buttonData.widthHint = 75;
        Button configurationsSaveButton = GUI.button.push((Composite)configurationsComposite, (String)Messages.ColumnConfigurationDialog_SaveButton, (Object)buttonData);
        Button configurationsNewButton = GUI.button.push((Composite)configurationsComposite, (String)Messages.ColumnConfigurationDialog_NewButton, (Object)buttonData);
        Button configurationsRenameButton = GUI.button.push((Composite)configurationsComposite, (String)Messages.ColumnConfigurationDialog_RenameButton, (Object)buttonData);
        Button configurationsDeleteButton = GUI.button.push((Composite)configurationsComposite, (String)Messages.ColumnConfigurationDialog_DeleteButton, (Object)buttonData);
        configurationsSaveButton.setEnabled(false);
        configurationsRenameButton.setEnabled(false);
        configurationsDeleteButton.setEnabled(false);
        GridData tableGroupData = GUI.grid.d.fillAll();
        tableGroupData.heightHint = 400;
        Group columnTableGroup = GUI.group((Composite)dialogComposite, (String)Messages.ColumnConfigurationDialog_ConfigurationTableGroupTitle, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)tableGroupData);
        this.columnTable.createTable((Composite)columnTableGroup, GUI.grid.d.fillAll());
        this.setTableContents(CURRENT_REPORTSLIST);
        this.currentConfigurationSelection = CURRENT_REPORTSLIST;
        this.createListeners(configurationsComboViewer, configurationsSaveButton, configurationsNewButton, configurationsRenameButton, configurationsDeleteButton);
        return dialogComposite;
    }

    private void createListeners(final ComboViewer configurationsComboViewer, final Button configurationsSaveButton, Button configurationsNewButton, final Button configurationsRenameButton, final Button configurationsDeleteButton) {
        configurationsComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)configurationsComboViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    configurationsSaveButton.setEnabled(false);
                    configurationsRenameButton.setEnabled(false);
                    configurationsDeleteButton.setEnabled(false);
                    return;
                }
                String previousSelection = ColumnConfigurationDialog.this.currentConfigurationSelection;
                int previousIndex = configurationsComboViewer.getCombo().indexOf(ColumnConfigurationDialog.this.currentConfigurationSelection);
                String selectedFileName = (String)selection.getFirstElement();
                if (ColumnConfigurationDialog.this.isDirty()) {
                    switch (ColumnConfigurationDialog.this.saveQuestionDialog()) {
                        case 0: {
                            ColumnConfigurationDialog.this.saveConfiguration(previousSelection);
                            ColumnConfigurationDialog.this.setDirty(false);
                            break;
                        }
                        case 1: {
                            ColumnConfigurationDialog.this.setDirty(false);
                            break;
                        }
                        default: {
                            configurationsComboViewer.getCombo().select(previousIndex);
                            return;
                        }
                    }
                }
                boolean b = !selectedFileName.equals(CURRENT_REPORTSLIST) && !selectedFileName.equals(DEFAULT_CONFIGURATION);
                configurationsSaveButton.setEnabled(b);
                configurationsRenameButton.setEnabled(b);
                configurationsDeleteButton.setEnabled(b);
                ColumnConfigurationDialog.this.currentConfigurationSelection = selectedFileName;
                ColumnConfigurationDialog.this.setTableContents(selectedFileName);
                ColumnConfigurationDialog.this.columnTable.setFocus();
            }
        });
        configurationsSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)configurationsComboViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    ColumnConfigurationDialog.this.saveConfiguration((String)selection.getFirstElement());
                    ColumnConfigurationDialog.this.setDirty(false);
                }
            }
        });
        configurationsNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object configurationName = "newColumnConfig.cols";
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ColumnConfigurationDialog_NewFileDialogTitle, Messages.ColumnConfigurationDialog_NewFileDialogMessage, (String)configurationName, (IInputValidator)new NameInputValidator());
                if (dialog.open() == 0) {
                    configurationName = dialog.getValue();
                    if (!((String)configurationName).endsWith(".cols")) {
                        configurationName = (String)configurationName + ".cols";
                    }
                    ColumnConfigurationDialog.this.configurationsList.add((String)configurationName);
                    ColumnConfigurationDialog.this.saveConfiguration((String)configurationName);
                    configurationsComboViewer.refresh();
                    configurationsComboViewer.setSelection((ISelection)new StructuredSelection(configurationName), true);
                }
            }
        });
        configurationsRenameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)configurationsComboViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    InputDialog dialog;
                    Object selectedFileName = (String)selection.getFirstElement();
                    String oldName = selectedFileName;
                    if (ColumnConfigurationDialog.this.isDirty()) {
                        switch (ColumnConfigurationDialog.this.saveQuestionDialog()) {
                            case 0: {
                                ColumnConfigurationDialog.this.saveConfiguration((String)selectedFileName);
                                ColumnConfigurationDialog.this.setDirty(false);
                                break;
                            }
                            case 1: {
                                ColumnConfigurationDialog.this.setDirty(false);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if ((dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ColumnConfigurationDialog_RenameFileDialogTitle, Messages.ColumnConfigurationDialog_RenameFileDialogMessage, (String)selectedFileName, (IInputValidator)new NameInputValidator())).open() == 0) {
                        selectedFileName = dialog.getValue();
                        if (!((String)selectedFileName).endsWith(".cols")) {
                            selectedFileName = (String)selectedFileName + ".cols";
                        }
                        ColumnConfigurationDialog.renameConfiguration(oldName, (String)selectedFileName);
                        ColumnConfigurationDialog.this.configurationsList.set(ColumnConfigurationDialog.this.configurationsList.indexOf(oldName), (String)selectedFileName);
                        configurationsComboViewer.refresh();
                        boolean tempDirty = ColumnConfigurationDialog.this.isDirty();
                        ColumnConfigurationDialog.this.setDirty(false);
                        configurationsComboViewer.setSelection((ISelection)new StructuredSelection(selectedFileName), true);
                        ColumnConfigurationDialog.this.setDirty(tempDirty);
                    }
                }
            }
        });
        configurationsDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)configurationsComboViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    String selectedFileName = (String)selection.getFirstElement();
                    if (PDDialogs.openConfirmThreadSafe((String)Messages.ColumnConfigurationDialog_DeleteFileDialogTitle, (String)Messages.ColumnConfigurationDialog_DeleteFileDialogMessage)) {
                        IResourceUtils.deleteIFile((IFile)FACorePlugin.getRoot().getFile(selectedFileName), (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
                        ColumnConfigurationDialog.this.configurationsList.remove(selectedFileName);
                        configurationsComboViewer.refresh();
                        ColumnConfigurationDialog.this.setDirty(false);
                        configurationsComboViewer.setSelection((ISelection)new StructuredSelection((Object)ColumnConfigurationDialog.this.configurationsList.get(0)), true);
                    }
                }
            }
        });
    }

    private static List<String> getConfigurationFileList() {
        final ArrayList<String> configurationList = new ArrayList<String>();
        configurationList.add(CURRENT_REPORTSLIST);
        configurationList.add(DEFAULT_CONFIGURATION);
        try {
            FACorePlugin.getRoot().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy resource) throws CoreException {
                    if (resource.getType() == 2) {
                        return true;
                    }
                    IPath path = resource.requestFullPath().removeFirstSegments(1);
                    if (path.segmentCount() < 1) {
                        return true;
                    }
                    if (FAResourceUtils.isFileExtension((IPath)path, (String)"cols") && !path.toString().equals(".cols")) {
                        configurationList.add(path.toString());
                    }
                    return false;
                }
            }, 0);
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
        }
        return configurationList;
    }

    private void setTableContents(String input) {
        if (input == null || input.equals(CURRENT_REPORTSLIST)) {
            this.columnTable.setTableContentsFromReportsList();
        } else if (input.equals(DEFAULT_CONFIGURATION)) {
            this.columnTable.setTableContentsAsDefault();
        } else {
            this.loadConfiguration(input);
        }
    }

    private void loadConfiguration(String configurationFile) {
        this.columnTable.setTableContentsFromInputFile((IMemento)MementoUtils.loadXMLMementoFromIFile((IFile)FACorePlugin.getRoot().getFile(configurationFile), (boolean)true, (Charset)StandardCharsets.UTF_8));
    }

    private void saveConfiguration(String configuration) {
        IFile columnConfigurationFile = FACorePlugin.getRoot().getFile(configuration);
        if (!columnConfigurationFile.exists()) {
            IResourceUtils.createEmptyIFile((IFile)columnConfigurationFile, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        }
        XMLMemento configurationSaveMementoUnordered = XMLMemento.createWriteRoot((String)"ul");
        configurationSaveMementoUnordered.putString("class", "view");
        this.columnTable.saveConfiguration((IMemento)configurationSaveMementoUnordered);
        MementoUtils.saveXMLMementoToIFileAsUTF8((XMLMemento)configurationSaveMementoUnordered, (IFile)columnConfigurationFile, (Charset)StandardCharsets.UTF_8, (boolean)true, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void renameConfiguration(String oldName, String newName) {
        IFile oldNameConfiguration = FACorePlugin.getRoot().getFile(oldName);
        IFile newNameConfiguration = FACorePlugin.getRoot().getFile(newName);
        try {
            oldNameConfiguration.move(newNameConfiguration.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            logger.warn((Throwable)e);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (!this.currentConfigurationSelection.equals(CURRENT_REPORTSLIST) && !this.currentConfigurationSelection.equals(DEFAULT_CONFIGURATION)) {
            this.dirty = dirty;
        }
    }

    protected void okPressed() {
        if (this.isDirty()) {
            this.saveConfiguration(this.currentConfigurationSelection);
        }
        PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ColumnConfigurationDialog.this.columnTable.setReportsListColumns();
            }
        });
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.isDirty()) {
            switch (this.saveQuestionDialog()) {
                case 0: {
                    this.saveConfiguration(this.currentConfigurationSelection);
                    super.cancelPressed();
                    break;
                }
                case 1: {
                    super.cancelPressed();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        super.cancelPressed();
    }

    private int saveQuestionDialog() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.ColumnConfigurationDialog_SaveConfigurationDialogTitle, null, Messages.ColumnConfigurationDialog_SaveConfigurationDialogMessage, 6, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no"), JFaceResources.getString((String)"cancel")}, 0);
        return dialog.open();
    }

    @Override
    public void setDirtyByTable() {
        this.setDirty(true);
    }

    private class NameInputValidator
    implements IInputValidator {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2019. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private NameInputValidator() {
        }

        public String isValid(String newText) {
            if (newText == null || newText.isEmpty() || newText.trim().equals(".cols")) {
                return Messages.ColumnConfigurationDialog_NameValidatorEmptyName;
            }
            Matcher invalidMatcher = Pattern.compile("[^a-zA-Z0-9.\\-_]").matcher(newText);
            if (invalidMatcher.find()) {
                return Messages.ColumnConfigurationDialog_NameValidatorInvalidCharacter;
            }
            return null;
        }
    }
}

